/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AvailabilityMonitor;

public class AvailabilityMonitorTest {
    @Test
    public final void testPoll() {
        AvailabilityMonitor sm = new AvailabilityMonitor();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("timeout", "3000");
        MonitoredService svc = new MonitoredService(){

            public InetAddress getAddress() {
                InetAddress addr = InetAddressUtils.addr((String)"127.0.0.1");
                if (addr == null) {
                    throw new IllegalStateException("Error getting localhost address");
                }
                return addr;
            }

            public String getIpAddr() {
                return InetAddressUtils.str((InetAddress)this.getAddress());
            }

            public NetworkInterface<InetAddress> getNetInterface() {
                return new InetNetworkInterface(this.getAddress());
            }

            public int getNodeId() {
                return 0;
            }

            public String getNodeLabel() {
                return "localhost";
            }

            public String getSvcName() {
                return "ICMP";
            }

            public String getSvcUrl() {
                return null;
            }
        };
        PollStatus status = sm.poll(svc, parameters);
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
    }
}

