/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.config.poller.outages.Interface;
import org.opennms.netmgt.config.poller.outages.Node;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.opennms.netmgt.config.poller.outages.Time;
import org.opennms.netmgt.mock.MockMonitor;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class MockPollerConfig
extends PollOutagesConfigManager
implements PollerConfig {
    private String m_criticalSvcName;
    private Package m_currentPkg = new Package();
    private boolean m_outageProcessingEnabled = false;
    private Vector<Package> m_pkgs = new Vector();
    private Map<String, ServiceMonitor> m_svcMonitors = new TreeMap<String, ServiceMonitor>();
    private int m_threads = 1;
    private long m_defaultPollInterval = 7654L;
    private boolean m_pollAll = true;
    private boolean m_serviceUnresponsiveEnabled = false;
    private String m_nextOutageIdSql;
    private Service m_currentSvc;
    private MockNetwork m_network;

    public MockPollerConfig(MockNetwork network) {
        this.m_network = network;
        this.setConfigResource((Resource)new ByteArrayResource("<outages></outages>".getBytes()));
        this.afterPropertiesSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Parameter> parameters(Service svc) {
        this.getReadLock().lock();
        try {
            List list = svc.getParameters();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void addDowntime(long interval, long begin, long end, boolean delete) {
        Downtime downtime = new Downtime();
        downtime.setDelete(delete ? "true" : "false");
        downtime.setBegin(Long.valueOf(begin));
        downtime.setInterval(Long.valueOf(interval));
        if (end >= 0L) {
            downtime.setEnd(Long.valueOf(end));
        }
        this.m_currentPkg.addDowntime(downtime);
    }

    public void addScheduledOutage(Package pkg, String outageName, long begin, long end, int nodeid) {
        Outage outage = new Outage();
        outage.setName(outageName);
        Node node = new Node();
        node.setId(Integer.valueOf(nodeid));
        outage.addNode(node);
        Time time = new Time();
        Date beginDate = new Date(begin);
        Date endDate = new Date(end);
        time.setBegins(new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(beginDate));
        time.setEnds(new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(endDate));
        outage.addTime(time);
        this.getConfig().addOutage(outage);
        pkg.addOutageCalendar(outageName);
    }

    public void addScheduledOutage(String outageName, long begin, long end, int nodeid) {
        this.addScheduledOutage(this.m_currentPkg, outageName, begin, end, nodeid);
    }

    public void addScheduledOutage(Package pkg, String outageName, long begin, long end, String ipAddr) {
        Outage outage = new Outage();
        outage.setName(outageName);
        Interface iface = new Interface();
        iface.setAddress(ipAddr);
        outage.addInterface(iface);
        Time time = new Time();
        Date beginDate = new Date(begin);
        Date endDate = new Date(end);
        time.setBegins(new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(beginDate));
        time.setEnds(new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(endDate));
        outage.addTime(time);
        this.getConfig().addOutage(outage);
        pkg.addOutageCalendar(outageName);
    }

    public void addScheduledOutage(String outageName, long begin, long end, String ipAddr) {
        this.addScheduledOutage(this.m_currentPkg, outageName, begin, end, ipAddr);
    }

    public void addScheduledOutage(Package pkg, String outageName, String dayOfWeek, String beginTime, String endTime, String ipAddr) {
        Outage outage = new Outage();
        outage.setName(outageName);
        outage.setType("weekly");
        Interface iface = new Interface();
        iface.setAddress(ipAddr);
        outage.addInterface(iface);
        Time time = new Time();
        time.setDay(dayOfWeek);
        time.setBegins(beginTime);
        time.setEnds(endTime);
        outage.addTime(time);
        this.getConfig().addOutage(outage);
        pkg.addOutageCalendar(outageName);
    }

    public void addScheduledOutage(String outageName, String dayOfWeek, String beginTime, String endTime, String ipAddr) {
        this.addScheduledOutage(this.m_currentPkg, outageName, dayOfWeek, beginTime, endTime, ipAddr);
    }

    public void addService(String name, ServiceMonitor monitor) {
        this.addService(name, this.m_defaultPollInterval, monitor);
    }

    public void addService(String name, long interval, ServiceMonitor monitor) {
        Service service = this.findService(this.m_currentPkg, name);
        if (service == null) {
            service = new Service();
            service.setName(name);
            service.setInterval(Long.valueOf(interval));
            this.m_currentPkg.addService(service);
            this.m_currentSvc = service;
        }
        this.addServiceMonitor(name, monitor);
    }

    private void addServiceMonitor(String name, ServiceMonitor monitor) {
        if (!this.hasServiceMonitor(name)) {
            this.m_svcMonitors.put(name, monitor);
        }
    }

    public void addService(MockService svc) {
        this.addService(svc.getSvcName(), this.m_defaultPollInterval, (ServiceMonitor)new MockMonitor(svc.getNetwork(), svc.getSvcName()));
        this.m_currentPkg.addSpecific(svc.getIpAddr());
    }

    public void clearDowntime() {
        List emptyList = Collections.emptyList();
        this.m_currentPkg.setDowntimes(emptyList);
    }

    public void addPackage(String name) {
        this.m_currentPkg = new Package();
        this.m_currentPkg.setName(name);
        this.m_pkgs.add(this.m_currentPkg);
    }

    public void addMonitor(String svcName, String className) {
        this.addServiceMonitor(svcName, (ServiceMonitor)new MockMonitor(this.m_network, svcName));
    }

    public Enumeration<Package> enumeratePackage() {
        return this.m_pkgs.elements();
    }

    private Service findService(Package pkg, String svcName) {
        for (Service svc : pkg.getServices()) {
            if (!svcName.equals(svc.getName())) continue;
            return svc;
        }
        return null;
    }

    public String getCriticalService() {
        return this.m_criticalSvcName;
    }

    public Package getFirstPackageMatch(String ipaddr) {
        return null;
    }

    public String getNextOutageIdSql() {
        return this.m_nextOutageIdSql;
    }

    public Package getPackage(String name) {
        for (Package pkg : this.m_pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    public List<String> getRRAList(Package pkg) {
        return null;
    }

    public ServiceMonitor getServiceMonitor(String svcName) {
        return this.getServiceMonitors().get(svcName);
    }

    public Map<String, ServiceMonitor> getServiceMonitors() {
        return this.m_svcMonitors;
    }

    public int getStep(Package pkg) {
        return 0;
    }

    public int getThreads() {
        return this.m_threads;
    }

    public boolean shouldNotifyXmlrpc() {
        return false;
    }

    public boolean hasServiceMonitor(String svcName) {
        return this.getServiceMonitor(svcName) != null;
    }

    public boolean isInterfaceInPackage(String iface, Package pkg) {
        for (String ipAddr : pkg.getSpecifics()) {
            if (!ipAddr.equals(iface)) continue;
            return true;
        }
        return false;
    }

    public boolean isPolled(String ipaddr) {
        return false;
    }

    public boolean isPolled(String svcName, Package pkg) {
        return false;
    }

    public boolean isPolled(String ipaddr, String svcName) {
        return false;
    }

    public boolean isNodeOutageProcessingEnabled() {
        return this.m_outageProcessingEnabled;
    }

    public boolean shouldPollAllIfNoCriticalServiceDefined() {
        return this.m_pollAll;
    }

    public void setPollAllIfNoCriticalServiceDefined(boolean pollAll) {
        this.m_pollAll = pollAll;
    }

    public void rebuildPackageIpListMap() {
    }

    public boolean isServiceInPackageAndEnabled(String svcName, Package pkg) {
        for (Service svc : pkg.getServices()) {
            if (!svc.getName().equals(svcName)) continue;
            return true;
        }
        return false;
    }

    public boolean isServiceMonitored(String svcName) {
        return false;
    }

    public boolean isServiceUnresponsiveEnabled() {
        return this.m_serviceUnresponsiveEnabled;
    }

    public void setNextOutageIdSql(String nextOutageIdSql) {
        this.m_nextOutageIdSql = nextOutageIdSql;
    }

    public void setServiceUnresponsiveEnabled(boolean serviceUnresponsiveEnabled) {
        this.m_serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public void setCriticalService(String criticalSvcName) {
        this.m_criticalSvcName = criticalSvcName;
    }

    public void setInterfaceMatch(String matchRegexp) {
        this.m_currentPkg.addIncludeUrl(matchRegexp);
    }

    public void setNodeOutageProcessingEnabled(boolean outageProcessingEnabled) {
        this.m_outageProcessingEnabled = outageProcessingEnabled;
    }

    public void setPollInterval(String svcName, long interval) {
        this.setPollInterval(this.m_currentPkg, svcName, interval);
    }

    public void setPollInterval(Package pkg, String svcName, long interval) {
        Service svc = this.findService(pkg, svcName);
        if (svc == null) {
            throw new IllegalArgumentException("No service named: " + svcName + " in package " + pkg);
        }
        svc.setInterval(Long.valueOf(interval));
    }

    public void setPollerThreads(int threads) {
        this.m_threads = threads;
    }

    public void setDefaultPollInterval(long defaultPollInterval) {
        this.m_defaultPollInterval = defaultPollInterval;
    }

    public void populatePackage(MockNetwork network) {
        MockVisitorAdapter populator = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                MockPollerConfig.this.addService(svc);
            }
        };
        network.visit((MockVisitor)populator);
    }

    protected void saveXML(String xmlString) throws IOException, MarshalException, ValidationException {
    }

    public Service getServiceInPackage(String svcName, Package pkg) {
        return this.findService(pkg, svcName);
    }

    public void update() {
    }

    public void save() {
    }

    public void addParameter(String key, String value) {
        Parameter param = new Parameter();
        param.setKey(key);
        param.setValue(value);
        this.m_currentSvc.addParameter(param);
    }

    public void addPackage(Package pkg) {
        this.m_pkgs.add(pkg);
    }

    public PollerConfiguration getConfiguration() {
        return null;
    }

    public List<String> getAllPackageMatches(String ipAddr) {
        return new ArrayList<String>(0);
    }

    public boolean isPathOutageEnabled() {
        return false;
    }

    public void releaseAllServiceMonitors() {
    }

    public List<InetAddress> getIpList(Package pkg) {
        return Collections.emptyList();
    }

    public ServiceSelector getServiceSelectorForPackage(Package pkg) {
        return null;
    }

    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Package getFirstLocalPackageMatch(String ipaddr) {
        throw new UnsupportedOperationException("MockPollerConfig.getFirstLocalPackageMatch is not yet implemented");
    }

    public boolean isPolledLocally(String ipaddr) {
        throw new UnsupportedOperationException("MockPollerConfig.isPolledLocally is not yet implemented");
    }

    public boolean isPolledLocally(String ipaddr, String svcName) {
        throw new UnsupportedOperationException("MockPollerConfig.isPolledLocally is not yet implemented");
    }
}

