/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.nb.Nms7467NetworkBuilder;

public class Nms7467Test
extends LinkdTestBuilder {
    Nms7467NetworkBuilder builder = new Nms7467NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt"), @JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt"), @JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    public void testAllLink() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(true);
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.save((Object)this.builder.getNetGearSw108());
        this.m_nodeDao.save((Object)this.builder.getDarwin108());
        this.m_nodeDao.save((Object)this.builder.getLinuxUbuntu());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mrgarrison.internal.opennms.com", "172.20.1.5"));
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("workstation", "172.20.1.101"));
        this.m_nodeDao.flush();
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        OnmsNode linux = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        OnmsNode ciscoap = this.m_nodeDao.findByForeignId("linkd", "mrgarrison.internal.opennms.com");
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        Assert.assertEquals((long)7L, (long)this.m_nodeDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linux.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(ciscoap.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)5L, (long)linkables.size());
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)5L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)8L, (long)this.m_dataLinkInterfaceDao.countAll());
        DataLinkInterface mactongsw108link = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(mac.getId(), Integer.valueOf(4)).iterator().next();
        Assert.assertEquals((Object)mac.getId(), (Object)mactongsw108link.getNode().getId());
        Assert.assertEquals((long)4L, (long)mactongsw108link.getIfIndex().intValue());
        Assert.assertEquals((Object)ngsw108.getId(), (Object)mactongsw108link.getNodeParentId());
        Assert.assertEquals((long)1L, (long)mactongsw108link.getParentIfIndex().intValue());
        DataLinkInterface ngsw108linktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ngsw108.getId(), Integer.valueOf(8)).iterator().next();
        Assert.assertEquals((Object)ngsw108.getId(), (Object)ngsw108linktociscows.getNode().getId());
        Assert.assertEquals((long)8L, (long)ngsw108linktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ngsw108linktociscows.getNodeParentId());
        Assert.assertEquals((long)9L, (long)ngsw108linktociscows.getParentIfIndex().intValue());
        DataLinkInterface ciscorouterlinktociscows2 = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ciscows.getId(), Integer.valueOf(52)).iterator().next();
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscorouterlinktociscows2.getNode().getId());
        Assert.assertEquals((long)52L, (long)ciscorouterlinktociscows2.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscorouter.getId(), (Object)ciscorouterlinktociscows2.getNodeParentId());
        Assert.assertEquals((long)3L, (long)ciscorouterlinktociscows2.getParentIfIndex().intValue());
        DataLinkInterface linuxubuntulinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(linux.getId(), Integer.valueOf(4)).iterator().next();
        Assert.assertEquals((Object)linux.getId(), (Object)linuxubuntulinktociscows.getNode().getId());
        Assert.assertEquals((long)4L, (long)linuxubuntulinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)linuxubuntulinktociscows.getNodeParentId());
        Assert.assertEquals((long)11L, (long)linuxubuntulinktociscows.getParentIfIndex().intValue());
        DataLinkInterface workstationlinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(workstation.getId(), Integer.valueOf(-1)).iterator().next();
        Assert.assertEquals((Object)workstation.getId(), (Object)workstationlinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)workstationlinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)workstationlinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)workstationlinktociscows.getParentIfIndex().intValue());
        DataLinkInterface ciscoaplinktociscows = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(ciscoap.getId(), Integer.valueOf(-1)).iterator().next();
        Assert.assertEquals((Object)ciscoap.getId(), (Object)ciscoaplinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)ciscoaplinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscoaplinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)ciscoaplinktociscows.getParentIfIndex().intValue());
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        for (OnmsAtInterface onmsat : this.m_atInterfaceDao.findAll()) {
            this.printAtInterface(onmsat);
        }
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            this.printLink(link);
        }
        Assert.assertEquals((long)8L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt")})
    public void testBridgeLinkCiscoSwitchVsRouter() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(true);
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        for (OnmsAtInterface onmsat : this.m_atInterfaceDao.findAll()) {
            this.printAtInterface(onmsat);
        }
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            this.printLink(link);
        }
        Assert.assertEquals((long)2L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.28", port=161, resource="classpath:linkd/nms7467/172.20.1.28-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    public void testLinkDarwinNetgear() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNetGearSw108());
        this.m_nodeDao.save((Object)this.builder.getDarwin108());
        this.m_nodeDao.flush();
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String macpackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.28")).getName();
        String ngsw108packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.8")).getName();
        Assert.assertEquals((Object)"example1", (Object)macpackageName);
        Assert.assertEquals((Object)"example1", (Object)ngsw108packageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface mactongsw108link = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)mac.getId(), (Object)mactongsw108link.getNode().getId());
        Assert.assertEquals((long)4L, (long)mactongsw108link.getIfIndex().intValue());
        Assert.assertEquals((Object)ngsw108.getId(), (Object)mactongsw108link.getNodeParentId());
        Assert.assertEquals((long)1L, (long)mactongsw108link.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.8", port=161, resource="classpath:linkd/nms7467/172.20.1.8-walk.txt")})
    public void testLinkNetgearCiscoWs() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setForceIpRouteDiscoveryOnEthernet(false);
        this.m_nodeDao.save((Object)this.builder.getNetGearSw108());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        String ngsw108packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.8")).getName();
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertEquals((Object)"example1", (Object)ngsw108packageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : links) {
            this.printLink(link);
        }
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface ngsw108linktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)ngsw108.getId(), (Object)ngsw108linktociscows.getNode().getId());
        Assert.assertEquals((long)8L, (long)ngsw108linktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ngsw108linktociscows.getNodeParentId());
        Assert.assertEquals((long)9L, (long)ngsw108linktociscows.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.14", port=161, resource="classpath:linkd/nms7467/172.20.1.14-walk.txt")})
    public void testLinuxUbuntuCiscoWs() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getLinuxUbuntu());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode linuxubuntu = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linuxubuntu.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linuxubuntu.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        String linuxubuntupackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.14")).getName();
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertEquals((Object)"example1", (Object)linuxubuntupackageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface linuxubuntulinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)linuxubuntu.getId(), (Object)linuxubuntulinktociscows.getNode().getId());
        Assert.assertEquals((long)4L, (long)linuxubuntulinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)linuxubuntulinktociscows.getNodeParentId());
        Assert.assertEquals((long)11L, (long)linuxubuntulinktociscows.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    public void testLinkWorkstationCiscoWs() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("workstation", "172.20.1.101"));
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces("example1", "60334b0817a8");
        Assert.assertEquals((long)1L, (long)ats.size());
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        String ciscowspackageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"172.20.1.7")).getName();
        Assert.assertEquals((Object)"example1", (Object)ciscowspackageName);
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface workstationlinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)workstation.getId(), (Object)workstationlinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)workstationlinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)workstationlinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)workstationlinktociscows.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt"), @JUnitSnmpAgent(host="172.20.1.1", port=161, resource="classpath:linkd/nms7467/172.20.1.1-walk.txt")})
    public void testLinkCiscoRouterCiscoWsUsingCdp() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setEnableVlanDiscovery(false);
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        Assert.assertEquals((long)2L, (long)this.m_nodeDao.countAll());
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)linkables.size());
        for (LinkableNode lnode : linkables) {
            Assert.assertEquals((Object)true, (Object)lnode.hasCdpInterfaces());
            Assert.assertEquals((long)1L, (long)lnode.getCdpInterfaces().size());
        }
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface link = (DataLinkInterface)links.get(0);
        this.printLink(link);
        Assert.assertEquals((Object)ciscows.getId(), (Object)link.getNode().getId());
        Assert.assertEquals((long)52L, (long)link.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscorouter.getId(), (Object)link.getNodeParentId());
        Assert.assertEquals((long)3L, (long)link.getParentIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.20.1.7", port=161, resource="classpath:linkd/nms7467/172.20.1.7-walk.txt")})
    public void testLinkCiscoAccessPointCiscoWsUsingCdp() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setEnableVlanDiscovery(false);
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mrgarrison.internal.opennms.com", "172.20.1.5"));
        this.m_nodeDao.flush();
        Assert.assertEquals((long)2L, (long)this.m_nodeDao.countAll());
        OnmsNode ciscoap = this.m_nodeDao.findByForeignId("linkd", "mrgarrison.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(ciscoap.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscows.getId().intValue()));
        Collection linkables = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)1L, (long)linkables.size());
        for (LinkableNode lnode : linkables) {
            if (ciscows.getId().intValue() == lnode.getNodeId()) {
                Assert.assertEquals((Object)true, (Object)lnode.hasCdpInterfaces());
                Assert.assertEquals((long)2L, (long)lnode.getCdpInterfaces().size());
                continue;
            }
            Assert.assertTrue((String)"Found node not added!!!!!", (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((long)1L, (long)links.size());
        DataLinkInterface ciscoaplinktociscows = (DataLinkInterface)links.get(0);
        Assert.assertEquals((Object)ciscoap.getId(), (Object)ciscoaplinktociscows.getNode().getId());
        Assert.assertEquals((long)-1L, (long)ciscoaplinktociscows.getIfIndex().intValue());
        Assert.assertEquals((Object)ciscows.getId(), (Object)ciscoaplinktociscows.getNodeParentId());
        Assert.assertEquals((long)47L, (long)ciscoaplinktociscows.getParentIfIndex().intValue());
    }
}

