/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms4930NetworkBuilder;

public class Nms4930Test
extends LinkdTestBuilder {
    Nms4930NetworkBuilder builder = new Nms4930NetworkBuilder();

    @Before
    public void setUpNetwork4930() throws Exception {
        this.builder.setNodeDao(this.m_nodeDao);
        this.builder.buildNetwork4930();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Network() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setEnableVlanDiscovery(false);
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found 1 link", (long)1L, (long)ifaces.size());
        for (DataLinkInterface link : ifaces) {
            this.checkLink(dlink1, dlink2, 24, 10, link);
            Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)link.getProtocol());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930NetworkReverse() throws Exception {
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setEnableVlanDiscovery(false);
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found one link", (long)1L, (long)ifaces.size());
        for (DataLinkInterface link : ifaces) {
            this.checkLink(dlink1, dlink2, 24, 10, link);
            Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)link.getProtocol());
        }
    }
}

