/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class Nms17216Test
extends LinkdTestBuilder {
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt"), @JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt"), @JUnitSnmpAgent(host="192.168.100.245", port=161, resource="classpath:linkd/nms17216/router1-walk.txt"), @JUnitSnmpAgent(host="192.168.100.241", port=161, resource="classpath:linkd/nms17216/router2-walk.txt"), @JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt"), @JUnitSnmpAgent(host="10.10.10.1", port=161, resource="classpath:linkd/nms17216/router4-walk.txt")})
    public void testNetwork17216Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.save((Object)this.builder.getSwitch4());
        this.m_nodeDao.save((Object)this.builder.getSwitch5());
        this.m_nodeDao.save((Object)this.builder.getRouter1());
        this.m_nodeDao.save((Object)this.builder.getRouter2());
        this.m_nodeDao.save((Object)this.builder.getRouter3());
        this.m_nodeDao.save((Object)this.builder.getRouter4());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode switch5 = this.m_nodeDao.findByForeignId("linkd", "Switch5");
        OnmsNode router1 = this.m_nodeDao.findByForeignId("linkd", "Router1");
        OnmsNode router2 = this.m_nodeDao.findByForeignId("linkd", "Router2");
        OnmsNode router3 = this.m_nodeDao.findByForeignId("linkd", "Router3");
        OnmsNode router4 = this.m_nodeDao.findByForeignId("linkd", "Router4");
        Integer switch1id = switch1.getId();
        Integer switch2id = switch2.getId();
        Integer switch3id = switch3.getId();
        Integer switch4id = switch4.getId();
        Integer switch5id = switch5.getId();
        Integer router1id = router1.getId();
        Integer router2id = router2.getId();
        Integer router3id = router3.getId();
        Integer router4id = router4.getId();
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch5id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router4id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch5id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router4id.intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)9L, (long)nodes.size());
        for (LinkableNode node : nodes) {
            int nodeId = node.getNodeId();
            if (nodeId == switch1id) {
                Assert.assertEquals((long)5L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Switch1", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == switch2id) {
                Assert.assertEquals((long)6L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Switch2", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == switch3id) {
                Assert.assertEquals((long)4L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Switch3", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == switch4id) {
                Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Switch4", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == switch5id) {
                Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Switch5", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == router1id) {
                Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Router1", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == router2id) {
                Assert.assertEquals((long)2L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Router2", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == router3id) {
                Assert.assertEquals((long)3L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Router3", (Object)node.getCdpDeviceId());
                continue;
            }
            if (nodeId == router4id) {
                Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
                Assert.assertEquals((Object)"Router4", (Object)node.getCdpDeviceId());
                continue;
            }
            Assert.fail((String)(nodeId + " did not match any known nodes."));
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)19L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(datalinkinterfaces);
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(switch2, switch1, 10101, 10109, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 11) {
                this.checkLink(switch2, switch1, 10101, 10109, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(switch2, switch1, 10102, 10110, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 12) {
                this.checkLink(switch2, switch1, 10102, 10110, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(switch2, switch1, 10103, 10111, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 13) {
                this.checkLink(switch2, switch1, 10103, 10111, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(switch2, switch1, 10104, 10112, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 14) {
                this.checkLink(switch2, switch1, 10104, 10112, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(switch3, switch2, 10019, 10119, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 15) {
                this.checkLink(switch3, switch2, 10019, 10119, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 5) {
                this.checkLink(switch3, switch2, 10020, 10120, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 16) {
                this.checkLink(switch3, switch2, 10020, 10120, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 6) {
                this.checkLink(router4, router3, 3, 8, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 7) {
                this.checkLink(router2, router1, 12, 13, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 8) {
                this.checkLink(router3, router2, 13, 13, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 9) {
                this.checkLink(router3, switch4, 9, 10001, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 10) {
                this.checkLink(router1, switch1, 7, 10101, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 17) {
                this.checkLink(switch5, switch3, 10001, 10023, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 18) {
                this.checkLink(switch5, switch3, 10013, 10024, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            Assert.fail((String)("link ID " + linkid + " was not in the expected range " + start + "-" + (start + 18)));
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testNetwork17216LldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseBridgeDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        Integer switch1id = switch1.getId();
        Integer switch2id = switch2.getId();
        Integer switch3id = switch3.getId();
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3id.intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)6L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int startid = this.getStartPoint(links);
        for (DataLinkInterface link : links) {
            Integer linkid = link.getId();
            if (linkid == startid) {
                this.checkLink(switch2, switch1, 10101, 10109, link);
                continue;
            }
            if (linkid == startid + 1) {
                this.checkLink(switch2, switch1, 10102, 10110, link);
                continue;
            }
            if (linkid == startid + 2) {
                this.checkLink(switch2, switch1, 10103, 10111, link);
                continue;
            }
            if (linkid == startid + 3) {
                this.checkLink(switch2, switch1, 10104, 10112, link);
                continue;
            }
            if (linkid == startid + 4) {
                this.checkLink(switch3, switch2, 10019, 10119, link);
                continue;
            }
            if (linkid == startid + 5) {
                this.checkLink(switch3, switch2, 10020, 10120, link);
                continue;
            }
            Assert.fail((String)("link ID " + linkid + " was not in the expected range " + startid + "-" + (startid + 5)));
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt")})
    public void testNetwork17216Switch4Router4CdpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch4());
        this.m_nodeDao.save((Object)this.builder.getRouter3());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setUseLldpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode router3 = this.m_nodeDao.findByForeignId("linkd", "Router3");
        Integer switch4id = switch4.getId();
        Integer router3id = router3.getId();
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router3id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4id.intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router3id.intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)2L, (long)nodes.size());
        for (LinkableNode node : nodes) {
            Assert.assertEquals((long)1L, (long)node.getCdpInterfaces().size());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)1L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            this.checkLink(router3, switch4, 9, 10001, datalinkinterface);
        }
    }
}

