/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.HibernateEventWriter;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms1055NetworkBuilder;

public class Nms1055Test
extends LinkdTestBuilder {
    Nms1055NetworkBuilder builder = new Nms1055NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt"), @JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt"), @JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt"), @JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt"), @JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testNetwork1055Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getPenrose());
        this.m_nodeDao.save((Object)this.builder.getDelaware());
        this.m_nodeDao.save((Object)this.builder.getPhoenix());
        this.m_nodeDao.save((Object)this.builder.getAustin());
        this.m_nodeDao.save((Object)this.builder.getSanjose());
        this.m_nodeDao.save((Object)this.builder.getRiovista());
        this.m_nodeDao.flush();
        HibernateEventWriter queryManager = (HibernateEventWriter)this.m_linkd.getQueryManager();
        Assert.assertEquals((long)517L, (long)queryManager.getFromSysnameIfAlias("delaware", "test").getIfIndex().intValue());
        Assert.assertEquals((long)517L, (long)queryManager.getFromSysnameIfName("delaware", "ge-0/0/1").getIfIndex().intValue());
        Assert.assertEquals((long)585L, (long)queryManager.getFromSysnameMacAddress("delaware", "0022830951f5").getIfIndex().intValue());
        Assert.assertEquals((long)13L, (long)queryManager.getFromSysnameIpAddress("delaware", InetAddressUtils.addr((String)"10.155.69.17")).getIfIndex().intValue());
        Assert.assertEquals((long)574L, (long)queryManager.getFromSysnameIfAlias("delaware", "<To_Penrose>").getIfIndex().intValue());
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        OnmsNode phoenix = this.m_nodeDao.findByForeignId("linkd", "phoenix-mx80");
        OnmsNode austin = this.m_nodeDao.findByForeignId("linkd", "Austin");
        OnmsNode sanjose = this.m_nodeDao.findByForeignId("linkd", "sanjose-mx240");
        OnmsNode riovista = this.m_nodeDao.findByForeignId("linkd", "Riovista-ce");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(riovista.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(riovista.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)22L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(penrose, phoenix, 644, 564, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(penrose, delaware, 535, 598, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(phoenix, austin, 565, 554, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 5) {
                this.checkLink(delaware, penrose, 598, 535, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 6) {
                this.checkLink(phoenix, penrose, 564, 644, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 7) {
                this.checkLink(austin, phoenix, 554, 565, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 8) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 9) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.ospf, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 10) {
                this.checkLink(penrose, riovista, 515, 584, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 11) {
                this.checkLink(penrose, delaware, 2693, 658, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 12) {
                this.checkLink(delaware, riovista, 540, 503, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 13) {
                this.checkLink(delaware, penrose, 574, 510, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 14) {
                this.checkLink(phoenix, penrose, 509, 511, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 15) {
                this.checkLink(delaware, penrose, 522, 525, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 16) {
                this.checkLink(riovista, penrose, 584, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 17) {
                this.checkLink(austin, delaware, 509, 575, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 18) {
                this.checkLink(riovista, delaware, 503, 540, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 19) {
                this.checkLink(sanjose, phoenix, 516, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 20) {
                this.checkLink(austin, phoenix, 508, 508, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 21) {
                this.checkLink(sanjose, austin, 517, 515, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.lldp, (Object)datalinkinterface.getProtocol());
                continue;
            }
            this.checkLink(penrose, penrose, -1, -1, datalinkinterface);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testNetwork1055StpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getPenrose());
        this.m_nodeDao.save((Object)this.builder.getDelaware());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(true);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)1L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt"), @JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt"), @JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt"), @JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt"), @JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt"), @JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testNetwork1055OspfLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getPenrose());
        this.m_nodeDao.save((Object)this.builder.getDelaware());
        this.m_nodeDao.save((Object)this.builder.getPhoenix());
        this.m_nodeDao.save((Object)this.builder.getAustin());
        this.m_nodeDao.save((Object)this.builder.getSanjose());
        this.m_nodeDao.save((Object)this.builder.getRiovista());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(true);
        example1.setUseIsisDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        this.m_linkdConfig.update();
        OnmsNode penrose = this.m_nodeDao.findByForeignId("linkd", "penrose-mx480");
        OnmsNode delaware = this.m_nodeDao.findByForeignId("linkd", "delaware");
        OnmsNode phoenix = this.m_nodeDao.findByForeignId("linkd", "phoenix-mx80");
        OnmsNode austin = this.m_nodeDao.findByForeignId("linkd", "Austin");
        OnmsNode sanjose = this.m_nodeDao.findByForeignId("linkd", "sanjose-mx240");
        OnmsNode riovista = this.m_nodeDao.findByForeignId("linkd", "Riovista-ce");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(riovista.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(penrose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(delaware.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(phoenix.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(austin.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(sanjose.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(riovista.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)5L, (long)this.m_dataLinkInterfaceDao.countAll());
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface datalinkinterface : links) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(delaware, penrose, 598, 535, datalinkinterface);
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(phoenix, penrose, 564, 644, datalinkinterface);
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(austin, phoenix, 554, 565, datalinkinterface);
                continue;
            }
            if (linkid == start + 3) {
                this.checkLink(sanjose, phoenix, 564, 566, datalinkinterface);
                continue;
            }
            if (linkid == start + 4) {
                this.checkLink(sanjose, austin, 8562, 586, datalinkinterface);
                continue;
            }
            this.checkLink(penrose, penrose, -1, -1, datalinkinterface);
        }
    }
}

