/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Filter;
import org.opennms.netmgt.config.linkd.IncludeRange;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms102NetworkBuilder;

public class Nms102Test
extends LinkdTestBuilder {
    Nms102NetworkBuilder builder = new Nms102NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:linkd/nms102/mikrotik-192.168.0.1-walk.txt"), @JUnitSnmpAgent(host="192.168.0.14", port=161, resource="classpath:linkd/nms102/samsung-192.168.0.14-walk.txt"), @JUnitSnmpAgent(host="192.168.0.16", port=161, resource="classpath:linkd/nms102/mac-192.168.0.16-walk.txt"), @JUnitSnmpAgent(host="192.168.0.17", port=161, resource="classpath:linkd/nms102/mac-192.168.0.17-walk.txt")})
    public void testWifiLinksWithExclusiveConf() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMac1());
        this.m_nodeDao.save((Object)this.builder.getMac2());
        this.m_nodeDao.save((Object)this.builder.getMikrotik());
        this.m_nodeDao.save((Object)this.builder.getSamsung());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mobile", "192.168.0.13"));
        this.m_nodeDao.flush();
        OnmsNode mac1 = this.m_nodeDao.findByForeignId("linkd", "mac1");
        OnmsNode mac2 = this.m_nodeDao.findByForeignId("linkd", "mac2");
        OnmsNode samsung = this.m_nodeDao.findByForeignId("linkd", "samsung");
        OnmsNode mikrotik = this.m_nodeDao.findByForeignId("linkd", "mikrotik");
        OnmsNode mobile = this.m_nodeDao.findByForeignId("linkd", "mobile");
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(mobile.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 4 data links", (long)4L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:linkd/nms102/mikrotik-192.168.0.1-walk.txt"), @JUnitSnmpAgent(host="192.168.0.14", port=161, resource="classpath:linkd/nms102/samsung-192.168.0.14-walk.txt"), @JUnitSnmpAgent(host="192.168.0.16", port=161, resource="classpath:linkd/nms102/mac-192.168.0.16-walk.txt"), @JUnitSnmpAgent(host="192.168.0.17", port=161, resource="classpath:linkd/nms102/mac-192.168.0.17-walk.txt")})
    public void testWifiLinksWithDefaultConf() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMac1());
        this.m_nodeDao.save((Object)this.builder.getMac2());
        this.m_nodeDao.save((Object)this.builder.getMikrotik());
        this.m_nodeDao.save((Object)this.builder.getSamsung());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mobile", "192.168.0.13"));
        this.m_nodeDao.flush();
        OnmsNode mac1 = this.m_nodeDao.findByForeignId("linkd", "mac1");
        OnmsNode mac2 = this.m_nodeDao.findByForeignId("linkd", "mac2");
        OnmsNode samsung = this.m_nodeDao.findByForeignId("linkd", "samsung");
        OnmsNode mikrotik = this.m_nodeDao.findByForeignId("linkd", "mikrotik");
        OnmsNode mobile = this.m_nodeDao.findByForeignId("linkd", "mobile");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(mobile.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 4 data links", (long)4L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:linkd/nms102/mikrotik-192.168.0.1-walk.txt"), @JUnitSnmpAgent(host="192.168.0.14", port=161, resource="classpath:linkd/nms102/samsung-192.168.0.14-walk.txt"), @JUnitSnmpAgent(host="192.168.0.16", port=161, resource="classpath:linkd/nms102/mac-192.168.0.16-walk.txt"), @JUnitSnmpAgent(host="192.168.0.17", port=161, resource="classpath:linkd/nms102/mac-192.168.0.17-walk.txt")})
    public void testLinksWithIpRoute() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMac1());
        this.m_nodeDao.save((Object)this.builder.getMac2());
        this.m_nodeDao.save((Object)this.builder.getMikrotik());
        this.m_nodeDao.save((Object)this.builder.getSamsung());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mobile", "192.168.0.13"));
        this.m_nodeDao.flush();
        OnmsNode mac1 = this.m_nodeDao.findByForeignId("linkd", "mac1");
        OnmsNode mac2 = this.m_nodeDao.findByForeignId("linkd", "mac2");
        OnmsNode samsung = this.m_nodeDao.findByForeignId("linkd", "samsung");
        OnmsNode mikrotik = this.m_nodeDao.findByForeignId("linkd", "mikrotik");
        OnmsNode mobile = this.m_nodeDao.findByForeignId("linkd", "mobile");
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIpRouteDiscovery(true);
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(mobile.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 7 data links", (long)7L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:linkd/nms102/mikrotik-192.168.0.1-walk.txt"), @JUnitSnmpAgent(host="192.168.0.14", port=161, resource="classpath:linkd/nms102/samsung-192.168.0.14-walk.txt"), @JUnitSnmpAgent(host="192.168.0.16", port=161, resource="classpath:linkd/nms102/mac-192.168.0.16-walk.txt"), @JUnitSnmpAgent(host="192.168.0.17", port=161, resource="classpath:linkd/nms102/mac-192.168.0.17-walk.txt")})
    public void testLinksTwoPackage() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getMac1());
        this.m_nodeDao.save((Object)this.builder.getMac2());
        this.m_nodeDao.save((Object)this.builder.getMikrotik());
        this.m_nodeDao.save((Object)this.builder.getSamsung());
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("mobile", "192.168.0.13"));
        this.m_nodeDao.flush();
        OnmsNode mac1 = this.m_nodeDao.findByForeignId("linkd", "mac1");
        OnmsNode mac2 = this.m_nodeDao.findByForeignId("linkd", "mac2");
        OnmsNode samsung = this.m_nodeDao.findByForeignId("linkd", "samsung");
        OnmsNode mikrotik = this.m_nodeDao.findByForeignId("linkd", "mikrotik");
        OnmsNode mobile = this.m_nodeDao.findByForeignId("linkd", "mobile");
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseIpRouteDiscovery(true);
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        example1.setUseWifiDiscovery(false);
        Package example2 = new Package();
        example2.setName("example2");
        Filter filter = new Filter();
        filter.setContent("IPADDR != '0.0.0.0'");
        example2.setFilter(filter);
        IncludeRange range = new IncludeRange();
        range.setBegin("1.1.1.1");
        range.setEnd("255.255.255.255");
        example2.addIncludeRange(range);
        example2.setUseBridgeDiscovery(false);
        example2.setSaveStpInterfaceTable(false);
        example2.setSaveStpNodeTable(false);
        example2.setUseIpRouteDiscovery(false);
        example2.setSaveRouteTable(false);
        example2.setEnableVlanDiscovery(false);
        example2.setUseOspfDiscovery(false);
        example2.setUseLldpDiscovery(false);
        example2.setUseIsisDiscovery(false);
        example2.setUseCdpDiscovery(false);
        example2.setUseIpRouteDiscovery(false);
        example2.setUseWifiDiscovery(true);
        this.m_linkdConfig.getConfiguration().addPackage(example2);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(mobile.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samsung.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mikrotik.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 3 data links", (long)3L, (long)ifaces.size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example2"));
        List ifacesAll = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifacesAll) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 7 data links", (long)7L, (long)ifacesAll.size());
    }
}

