/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.CdpInterface;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.model.topology.RouterInterface;
import org.opennms.netmgt.nb.Nms101NetworkBuilder;

public class Nms101Test
extends LinkdTestBuilder {
    Nms101NetworkBuilder builder = new Nms101NetworkBuilder();

    @Before
    public void setUpForceDisvoeryOnEthernet() {
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setForceIpRouteDiscoveryOnEthernet(true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.5.1", port=161, resource="classpath:linkd/nms101/cisco1700b.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/nms101/cisco1700.properties")})
    public void testSimpleFakeConnection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCisco1700());
        this.m_nodeDao.save((Object)this.builder.getCisco1700b());
        this.m_nodeDao.save((Object)this.builder.getExampleCom());
        this.m_nodeDao.flush();
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco1700b = this.m_nodeDao.findByForeignId("linkd", "cisco1700b");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700b.getId().intValue()));
        for (LinkableNode node : this.m_linkd.getLinkableNodesOnPackage("example1")) {
            int nodeid = node.getNodeId();
            this.printNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeid)));
            for (RouterInterface route : node.getRouteInterfaces()) {
                this.printRouteInterface(nodeid, route);
            }
            for (CdpInterface cdp : node.getCdpInterfaces()) {
                this.printCdpInterface(nodeid, cdp);
            }
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data link", (long)1L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties")})
    public void testsimpleLinkCisco7200aCisco7200b() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCisco7200a());
        this.m_nodeDao.save((Object)this.builder.getCisco7200b());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            if (link.getProtocol() == DataLinkInterface.DiscoveryProtocol.iproute) {
                this.checkLink(cisco7200a, cisco7200b, 2, 4, link);
                continue;
            }
            if (link.getProtocol() != DataLinkInterface.DiscoveryProtocol.cdp) continue;
            this.checkLink(cisco7200b, cisco7200a, 4, 2, link);
        }
        Assert.assertEquals((String)"we should have found 2 data links", (long)2L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms101/laptop.properties")})
    public void testsimpleLinkCisco7200alaptop() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCisco7200a());
        this.m_nodeDao.save((Object)this.builder.getLaptop());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data links", (long)1L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms101/cisco3700.properties"), @JUnitSnmpAgent(host="10.1.6.2", port=161, resource="classpath:linkd/nms101/cisco3600.properties")})
    public void testsimpleLinkCisco3600aCisco3700() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCisco3700());
        this.m_nodeDao.save((Object)this.builder.getCisco3600());
        this.m_nodeDao.flush();
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        OnmsNode cisco3700 = this.m_nodeDao.findByForeignId("linkd", "cisco3700");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            if (link.getProtocol() == DataLinkInterface.DiscoveryProtocol.iproute) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                continue;
            }
            if (link.getProtocol() != DataLinkInterface.DiscoveryProtocol.cdp) continue;
            this.checkLink(cisco3600, cisco3700, 1, 3, link);
        }
        Assert.assertEquals((String)"we should have found 2 data links", (long)2L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms101/laptop.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/nms101/cisco3700.properties"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/nms101/cisco2691.properties"), @JUnitSnmpAgent(host="10.1.5.2", port=161, resource="classpath:linkd/nms101/cisco1700.properties"), @JUnitSnmpAgent(host="10.1.6.2", port=161, resource="classpath:linkd/nms101/cisco3600.properties")})
    public void testCiscoNetwork() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getExampleCom());
        this.m_nodeDao.save((Object)this.builder.getLaptop());
        this.m_nodeDao.save((Object)this.builder.getCisco7200a());
        this.m_nodeDao.save((Object)this.builder.getCisco7200b());
        this.m_nodeDao.save((Object)this.builder.getCisco3700());
        this.m_nodeDao.save((Object)this.builder.getCisco2691());
        this.m_nodeDao.save((Object)this.builder.getCisco1700());
        this.m_nodeDao.save((Object)this.builder.getCisco3600());
        this.m_nodeDao.flush();
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        OnmsNode cisco3700 = this.m_nodeDao.findByForeignId("linkd", "cisco3700");
        OnmsNode cisco2691 = this.m_nodeDao.findByForeignId("linkd", "cisco2691");
        OnmsNode cisco1700 = this.m_nodeDao.findByForeignId("linkd", "cisco1700");
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco2691.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco1700.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco3600.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List links = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(links);
        for (DataLinkInterface link : links) {
            int id = link.getId();
            if (id == start) {
                this.checkLink(laptop, cisco7200a, 10, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 1) {
                this.checkLink(cisco7200a, cisco7200b, 2, 4, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 10) {
                this.checkLink(cisco7200b, cisco7200a, 4, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 2) {
                this.checkLink(cisco7200b, cisco2691, 1, 4, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 8) {
                this.checkLink(cisco2691, cisco7200b, 4, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 3) {
                this.checkLink(cisco7200b, cisco3700, 2, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 9) {
                this.checkLink(cisco3700, cisco7200b, 1, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 4) {
                this.checkLink(cisco1700, cisco2691, 2, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 7) {
                this.checkLink(cisco1700, cisco2691, 2, 2, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 6) {
                this.checkLink(cisco3600, cisco2691, 2, 1, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 5) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.iproute, (Object)link.getProtocol());
                continue;
            }
            if (id == start + 11) {
                this.checkLink(cisco3600, cisco3700, 1, 3, link);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.cdp, (Object)link.getProtocol());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)true);
        }
        Assert.assertEquals((String)"we should have found 12 data links", (long)12L, (long)links.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.1", port=161, resource="classpath:linkd/nms101/cisco7200a.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms101/cisco7200b.properties")})
    public void testsimpleCdpLinkCisco7200aCisco7200b() throws Exception {
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setUseIpRouteDiscovery(false);
            pkg.setUseOspfDiscovery(false);
            pkg.setUseLldpDiscovery(false);
            pkg.setUseBridgeDiscovery(false);
            pkg.setSaveRouteTable(false);
            pkg.setSaveStpNodeTable(false);
            pkg.setSaveStpInterfaceTable(false);
            pkg.setEnableVlanDiscovery(false);
            pkg.setUseIsisDiscovery(false);
        }
        this.m_nodeDao.save((Object)this.builder.getCisco7200a());
        this.m_nodeDao.save((Object)this.builder.getCisco7200b());
        this.m_nodeDao.flush();
        OnmsNode cisco7200a = this.m_nodeDao.findByForeignId("linkd", "cisco7200ATM.befunk.com");
        OnmsNode cisco7200b = this.m_nodeDao.findByForeignId("linkd", "cisco7200");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200a.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco7200b.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        for (DataLinkInterface link : ifaces) {
            this.printLink(link);
        }
        Assert.assertEquals((String)"we should have found 1 data links", (long)1L, (long)ifaces.size());
    }
}

