/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.HibernateEventWriter;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.nb.Nms0002NetworkBuilder;

public class Nms0002Test
extends LinkdTestBuilder {
    Nms0002NetworkBuilder builder = new Nms0002NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.79.250", port=161, resource="classpath:linkd/nms0002ciscojuniper/r-de-juet-luck-001.txt"), @JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:linkd/nms0002ciscojuniper/s-de-juet-luck-001.txt")})
    public void testNetworkLinksCiscoJuniperLldp() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRluck001());
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(true);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode routerJuniper = this.m_nodeDao.findByForeignId("linkd", "r-de-juet-luck-001");
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        for (LinkableNode linkableNode : this.m_linkd.getLinkableNodesOnPackage("example1")) {
            Assert.assertNotNull((Object)linkableNode.getLldpChassisId());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:linkd/nms0002ciscojuniper/s-de-juet-luck-001.txt")})
    public void testNetworkLinksCiscoJuniperVlan() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setEnableVlanDiscovery(true);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        Assert.assertEquals((long)7L, (long)this.m_vlanDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.79.250", port=161, resource="classpath:linkd/nms0002ciscojuniper/r-de-juet-luck-001.txt"), @JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:linkd/nms0002ciscojuniper/s-de-juet-luck-001.txt")})
    public void testNetworkLinksCiscoJuniperVlan1() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRluck001());
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode routerJuniper = this.m_nodeDao.findByForeignId("linkd", "r-de-juet-luck-001");
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.79.250", port=161, resource="classpath:linkd/nms0002ciscojuniper/r-de-juet-luck-001.txt"), @JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:linkd/nms0002ciscojuniper/s-de-juet-luck-001.vlan100.txt")})
    public void testNetworkLinksCiscoJuniperVlan100() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRluck001());
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode routerJuniper = this.m_nodeDao.findByForeignId("linkd", "r-de-juet-luck-001");
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)2L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.79.250", port=161, resource="classpath:linkd/nms0002ciscojuniper/r-de-juet-luck-001.txt"), @JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:linkd/nms0002ciscojuniper/s-de-juet-luck-001.vlan950.txt")})
    public void testNetworkLinksCiscoJuniperVlan950() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRluck001());
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode routerJuniper = this.m_nodeDao.findByForeignId("linkd", "r-de-juet-luck-001");
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)2L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.140.252.57", port=161, resource="classpath:linkd/nms0002UkRoFakeLink/r-ro-suce-pict-001.txt"), @JUnitSnmpAgent(host="10.239.9.22", port=161, resource="classpath:linkd/nms0002UkRoFakeLink/r-uk-nott-newt-103.txt")})
    public void testCdpFakeLinkRoUk() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRPict001());
        this.m_nodeDao.save((Object)this.builder.getRNewt103());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setUseCdpDiscovery(true);
        example1.setUseBridgeDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        OnmsNode routerRo = this.m_nodeDao.findByForeignId("linkd", "r-ro-suce-pict-001");
        OnmsNode routerUk = this.m_nodeDao.findByForeignId("linkd", "r-uk-nott-newt-103");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerRo.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerUk.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerRo.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerUk.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.167.254.40", port=161, resource="classpath:linkd/nms0002ciscoalcatel2/r-de-essn-brue-001.txt"), @JUnitSnmpAgent(host="10.165.62.91", port=161, resource="classpath:linkd/nms0002ciscoalcatel2/s-de-essn-brue-081.txt"), @JUnitSnmpAgent(host="10.165.62.131", port=161, resource="classpath:linkd/nms0002ciscoalcatel2/s-de-essn-brue-121.txt"), @JUnitSnmpAgent(host="10.165.62.152", port=161, resource="classpath:linkd/nms0002ciscoalcatel2/s-de-essn-brue-142.txt"), @JUnitSnmpAgent(host="10.165.62.175", port=161, resource="classpath:linkd/nms0002ciscoalcatel2/s-de-essn-brue-165.txt")})
    public void testCiscoAlcatelEssnBrueLldp() {
        this.m_nodeDao.save((Object)this.builder.getRDeEssnBrue());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue081());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue121());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue142());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue165());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseIsisDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(true);
        example1.setUseCdpDiscovery(false);
        example1.setUseBridgeDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveStpNodeTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        HibernateEventWriter queryManager = (HibernateEventWriter)this.m_linkd.getQueryManager();
        Assert.assertEquals((long)107L, (long)queryManager.getFromSysnameIfName("r-de-essn-brue-001", "Gi1/3/11").getIfIndex().intValue());
        Assert.assertEquals((long)260L, (long)queryManager.getFromSysnameIfName("r-de-essn-brue-001", "Gi2/3/11").getIfIndex().intValue());
        Assert.assertEquals((long)1025L, (long)queryManager.getFromSysnameIfIndex("s-de-essn-brue-165", Integer.valueOf(1025)).getIfIndex().intValue());
        Assert.assertEquals((long)2025L, (long)queryManager.getFromSysnameIfName("s-de-essn-brue-165", "2/25").getIfIndex().intValue());
        OnmsNode routerCisco = this.m_nodeDao.findByForeignId("linkd", "r-de-essn-brue-001");
        OnmsNode swicthAlu081 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-081");
        OnmsNode swicthAlu121 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-121");
        OnmsNode swicthAlu142 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-142");
        OnmsNode swicthAlu165 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-165");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu081.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu121.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu142.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu165.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu081.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu121.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu142.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu165.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            this.printLink(link);
        }
        Assert.assertEquals((long)6L, (long)this.m_dataLinkInterfaceDao.countAll());
    }
}

