/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/applicationContext-soa.xml", "classpath:META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:META-INF/opennms/applicationContext-eventDaemon.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class EventdSpringTest
implements InitializingBean {
    @Autowired
    Eventd m_daemon;
    @Autowired
    EventConfDao m_eventConfDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    public void testDaemon() throws Exception {
        this.m_daemon.onStart();
        this.m_daemon.onStop();
    }

    @Test
    public void testEventConfSeverities() throws Exception {
        List<String> validSeverities = Arrays.asList("Critical", "Major", "Minor", "Warning", "Normal", "Cleared", "Indeterminate");
        for (String uei : this.m_eventConfDao.getEventUEIs()) {
            for (Event event : this.m_eventConfDao.getEvents(uei)) {
                if (validSeverities.contains(event.getSeverity())) continue;
                Assert.fail((String)String.format("Invalid severity found on event: %s: %s", uei, event.getSeverity()));
            }
        }
    }
}

