/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class EventUtilTest {
    private final MockNetwork m_network = new MockNetwork();
    private MockService m_svc;
    private Event m_svcLostEvent;
    private Event m_nodeDownEvent;
    private Event m_bgpBkTnEvent;

    @Before
    public void setUp() throws Exception {
        this.m_network.createStandardNetwork();
        this.m_svc = this.m_network.getService(1, "192.168.1.1", "SMTP");
        this.m_svcLostEvent = MockEventUtil.createNodeLostServiceEvent((String)"Test", (MockService)this.m_svc);
        this.m_nodeDownEvent = MockEventUtil.createNodeDownEvent((String)"Text", (MockNode)this.m_network.getNode(1));
        this.m_bgpBkTnEvent = MockEventUtil.createBgpBkTnEvent((String)"Test", (MockNode)this.m_network.getNode(1), (String)"128.64.32.16", (int)2);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetValueAsString() {
        Value v = new Value();
        v.setContent(String.valueOf(Base64.encodeBase64((byte[])new String("abcd").getBytes())));
        v.setEncoding("base64");
        Assert.assertEquals((Object)"0x61626364", (Object)EventConstants.getValueAsString((Value)v));
    }

    @Test
    public void testEscape() {
        Assert.assertEquals((Object)"m%onkeys%47rock", (Object)EventUtil.escape((String)"m%onkeys/rock", (char)'/'));
    }

    @Test
    public void testGetValueOfParm() {
        String testString = EventUtil.getValueOfParm((String)"uei", (Event)this.m_svcLostEvent);
        Assert.assertEquals((Object)"uei.opennms.org/nodes/nodeLostService", (Object)testString);
        this.m_svcLostEvent.setSeverity(OnmsSeverity.MINOR.getLabel());
        testString = EventUtil.getValueOfParm((String)"severity", (Event)this.m_svcLostEvent);
        Assert.assertEquals((Object)"Minor", (Object)testString);
        Event event = MockEventUtil.createNodeLostServiceEvent((String)"Test", (MockService)this.m_svc, (String)"noReasonAtAll");
        Assert.assertEquals((Object)"noReasonAtAll", (Object)EventUtil.getNamedParmValue((String)"parm[eventReason]", (Event)event));
    }

    @Test
    public void testExpandParms() {
        String testString = "%uei%:%dpname%:%nodeid%:%interface%:%service%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_svcLostEvent);
        Assert.assertEquals((Object)"uei.opennms.org/nodes/nodeLostService::1:192.168.1.1:SMTP", (Object)newString);
    }

    @Test
    public void testExpandParmNames() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:.1.3.6.1.2.1.15.3.1.7.128.64.32.16", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNamePositive() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.1]%.%parm[name-#1.3]%.%parm[name-#1.5]%.%parm[name-#1.7]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:1.6.2.15", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNameNegative() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-4]%.%parm[name-#1.-3]%.%parm[name-#1.-2]%.%parm[name-#1.-1]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:128.64.32.16", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNameRangePositive() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.1:4]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:1.3.6.1", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNameRangePositiveToEnd() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.5:]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:2.1.15.3.1.7.128.64.32.16", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNameRangeNegative() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-4:2]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:128.64", (Object)newString);
    }

    @Test
    public void testSplitAndExtractParmNameRangeNegativeToEnd() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-5:]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        Assert.assertEquals((Object)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:7.128.64.32.16", (Object)newString);
    }

    @Test
    public void testExpandTticketId() {
        String testString = "%tticketid%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_nodeDownEvent);
        Assert.assertEquals((Object)"", (Object)newString);
        Tticket ticket = new Tticket();
        ticket.setContent("777");
        ticket.setState("1");
        this.m_nodeDownEvent.setTticket(ticket);
        newString = EventUtil.expandParms((String)testString, (Event)this.m_nodeDownEvent);
        Assert.assertEquals((Object)"777", (Object)newString);
    }
}

