/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdTestBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class Nms17216EnTest
extends EnLinkdTestBuilder {
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testNetwork17216LldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(true);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        List topologyA = this.m_lldpLinkDao.findAll();
        Nms17216EnTest.printLldpTopology(topologyA);
        Assert.assertEquals((long)4L, (long)topologyA.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms17216EnTest.printLldpElement(node.getLldpElement());
        }
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        List topologyB = this.m_lldpLinkDao.findAll();
        Nms17216EnTest.printLldpTopology(topologyB);
        Assert.assertEquals((long)10L, (long)topologyB.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms17216EnTest.printLldpElement(node.getLldpElement());
        }
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        List topologyC = this.m_lldpLinkDao.findAll();
        Nms17216EnTest.printLldpTopology(topologyC);
        Assert.assertEquals((long)12L, (long)topologyC.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms17216EnTest.printLldpElement(node.getLldpElement());
        }
    }
}

