/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdTestBuilder;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms0001NetworkBuilder;

public class Nms0001EnTest
extends EnLinkdTestBuilder {
    Nms0001NetworkBuilder builder = new Nms0001NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsIsLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getFroh());
        this.m_nodeDao.save((Object)this.builder.getOedipus());
        this.m_nodeDao.save((Object)this.builder.getSiegFrie());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkdConfig.useIsisDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        OnmsNode froh = this.m_nodeDao.findByForeignId("linkd", "froh");
        OnmsNode oedipus = this.m_nodeDao.findByForeignId("linkd", "oedipus");
        OnmsNode siegfrie = this.m_nodeDao.findByForeignId("linkd", "siegfrie");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(froh.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(oedipus.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(siegfrie.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(froh.getId().intValue()));
        Assert.assertEquals((long)2L, (long)this.m_isisLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(oedipus.getId().intValue()));
        Assert.assertEquals((long)4L, (long)this.m_isisLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(siegfrie.getId().intValue()));
        Assert.assertEquals((long)6L, (long)this.m_isisLinkDao.countAll());
        List links = this.m_isisLinkDao.getLinksForTopology();
        Assert.assertEquals((long)3L, (long)links.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getIsisElement());
            System.err.println(node.getIsisElement());
        }
        for (IsIsLink link : this.m_isisLinkDao.findAll()) {
            System.err.println(link);
        }
    }
}

