/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.config.EventTranslatorConfigFactory;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventWriter;
import org.opennms.netmgt.translator.EventTranslator;

public class EventTranslatorConfigFactoryTest
extends OpenNMSTestCase {
    private EventTranslator m_translator;
    private MockEventIpcManager m_eventMgr;
    private String m_passiveStatusConfiguration = this.getStandardConfig();
    private EventTranslatorConfigFactory m_config;
    private EventAnticipator m_anticipator;
    private OutageAnticipator m_outageAnticipator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.createAnticipators();
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter((EventWriter)m_db);
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_eventMgr.addEventListener((EventListener)this.m_outageAnticipator);
        this.m_eventMgr.setSynchronous(true);
        ByteArrayInputStream rdr = new ByteArrayInputStream(this.m_passiveStatusConfiguration.getBytes("UTF-8"));
        this.m_config = new EventTranslatorConfigFactory((InputStream)rdr, (DataSource)m_db);
        EventTranslatorConfigFactory.setInstance((EventTranslatorConfig)this.m_config);
        this.m_translator = EventTranslator.getInstance();
        this.m_translator.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_translator.setConfig(EventTranslatorConfigFactory.getInstance());
        this.m_translator.setDataSource((DataSource)m_db);
        this.m_translator.init();
        this.m_translator.start();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Override
    @Test
    public void testDoNothing() {
    }

    private void createAnticipators() {
        this.m_anticipator = new EventAnticipator();
        this.m_outageAnticipator = new OutageAnticipator(m_db);
    }

    private String getStandardConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<event-translator-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/translator-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationTest\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D'\" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</event-translator-configuration>\n";
    }
}

