/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.support.AbstractCollectionSet;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.mock.MockTransactionTemplate;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.support.TransactionTemplate;

public class CollectdIntegrationTest
extends TestCase {
    private static final String TEST_KEY_PARM_NAME = "key";
    private static Map<String, CollectdIntegrationTest> m_tests = new HashMap<String, CollectdIntegrationTest>();
    private EventIpcManager m_eventIpcManager;
    private Collectd m_collectd;
    private EasyMockUtils m_mockUtils;
    private CollectdConfigFactory m_collectdConfigFactory;
    private CollectdConfiguration m_collectdConfiguration;
    private String m_key;
    private MockServiceCollector m_serviceCollector;
    private IpInterfaceDao m_ifaceDao;
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;

    protected void setUp() throws Exception {
        this.m_eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_mockUtils = new EasyMockUtils();
        this.m_filterDao = (FilterDao)this.m_mockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        PollOutagesConfigFactory factory = new PollOutagesConfigFactory((Resource)resource);
        factory.afterPropertiesSet();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)factory);
        File homeDir = resource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        resource = new ClassPathResource("/test-thresholds.xml");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(resource.getInputStream()));
        this.m_key = this.getName() + System.nanoTime();
        m_tests.put(this.m_key, this);
        Collector collector = new Collector();
        collector.setService("SNMP");
        collector.setClassName(MockServiceCollector.class.getName());
        Parameter param = new Parameter();
        param.setKey(TEST_KEY_PARM_NAME);
        param.setValue(this.m_key);
        collector.addParameter(param);
        this.m_collectdConfigFactory = (CollectdConfigFactory)this.m_mockUtils.createMock(CollectdConfigFactory.class);
        this.m_collectdConfiguration = (CollectdConfiguration)this.m_mockUtils.createMock(CollectdConfiguration.class);
        EasyMock.expect((Object)this.m_collectdConfigFactory.getCollectdConfig()).andReturn((Object)this.m_collectdConfiguration).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getCollectors()).andReturn(Collections.singletonList(collector)).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getThreads()).andReturn((Object)1).anyTimes();
        this.m_ifaceDao = (IpInterfaceDao)this.m_mockUtils.createMock(IpInterfaceDao.class);
        this.m_nodeDao = (NodeDao)this.m_mockUtils.createMock(NodeDao.class);
        this.m_collectd = new Collectd(){

            protected void handleInsufficientInfo(InsufficientInformationException e) {
                Assert.fail((String)("Invalid event received: " + e.getMessage()));
            }
        };
        OnmsServiceType snmp = new OnmsServiceType("SNMP");
        NetworkBuilder netBuilder = new NetworkBuilder("localhost", "127.0.0.1");
        NetworkBuilder.NodeBuilder nodeBuilder = netBuilder.addNode("node1").setId(Integer.valueOf(1));
        NetworkBuilder.InterfaceBuilder ifaceBlder = netBuilder.addInterface("192.168.1.1").setId(2).setIsSnmpPrimary("P");
        ifaceBlder.addSnmpInterface(1);
        OnmsMonitoredService svc = netBuilder.addService(snmp);
        List initialIfs = Collections.emptyList();
        EasyMock.expect((Object)this.m_ifaceDao.findByServiceType(snmp.getName())).andReturn(initialIfs).anyTimes();
        this.m_filterDao.flushActiveIpAddressListCache();
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)nodeBuilder.getNode()).anyTimes();
        this.createGetPackagesExpectation(svc);
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)Integer.valueOf(2))).andReturn((Object)ifaceBlder.getInterface()).anyTimes();
        this.m_mockUtils.replayAll();
        MockTransactionTemplate transTemplate = new MockTransactionTemplate();
        transTemplate.afterPropertiesSet();
        this.m_collectd.setCollectdConfigFactory(this.m_collectdConfigFactory);
        this.m_collectd.setEventIpcManager(this.m_eventIpcManager);
        this.m_collectd.setTransactionTemplate((TransactionTemplate)transTemplate);
        this.m_collectd.setIpInterfaceDao(this.m_ifaceDao);
        this.m_collectd.setNodeDao(this.m_nodeDao);
        this.m_collectd.setFilterDao(this.m_filterDao);
        this.m_collectd.afterPropertiesSet();
    }

    public static void setServiceCollectorInTest(String testKey, MockServiceCollector collector) {
        CollectdIntegrationTest test = m_tests.get(testKey);
        CollectdIntegrationTest.assertNotNull((Object)((Object)test));
        test.setServiceCollector(collector);
    }

    private void setServiceCollector(MockServiceCollector collector) {
        this.m_serviceCollector = collector;
    }

    protected void tearDown() throws Exception {
        m_tests.remove(this.m_key);
    }

    public void testIt() throws InterruptedException {
        this.m_collectd.start();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "Test");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        bldr.setService("SNMP");
        this.m_collectd.onEvent(bldr.getEvent());
        Thread.sleep(2000L);
        CollectdIntegrationTest.assertNotNull((Object)this.m_serviceCollector);
        CollectdIntegrationTest.assertEquals((Object)1, (Object)this.m_serviceCollector.getCollectCount());
        this.m_mockUtils.verifyAll();
    }

    private void createGetPackagesExpectation(OnmsMonitoredService svc) {
        String rule = "ipaddr = '" + InetAddressUtils.str((InetAddress)svc.getIpAddress()) + "'";
        Package pkg = new Package();
        pkg.setName("testPackage");
        Filter filter = new Filter();
        filter.setContent(rule);
        pkg.setFilter(filter);
        Service collector = new Service();
        collector.setName("SNMP");
        collector.setStatus("on");
        collector.setInterval(Long.valueOf(3000L));
        Parameter parm = new Parameter();
        parm.setKey(TEST_KEY_PARM_NAME);
        parm.setValue(this.m_key);
        collector.setParameters(Collections.singletonList(parm));
        pkg.addService(collector);
        EasyMock.expect((Object)this.m_collectdConfiguration.getPackages()).andReturn(Collections.singletonList(pkg));
        EasyMock.expect((Object)this.m_collectdConfigFactory.interfaceInPackage((OnmsIpInterface)EasyMock.anyObject(OnmsIpInterface.class), (Package)EasyMock.eq((Object)pkg))).andReturn((Object)true);
    }

    public static class MockServiceCollector
    implements ServiceCollector {
        int m_collectCount = 0;

        public MockServiceCollector() {
            System.err.println("Created a MockServiceCollector");
        }

        public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
            ++this.m_collectCount;
            AbstractCollectionSet collectionSetResult = new AbstractCollectionSet(){
                private Date m_timestamp = new Date();

                public int getStatus() {
                    return 1;
                }

                public void visit(CollectionSetVisitor visitor) {
                    visitor.visitCollectionSet((CollectionSet)this);
                    visitor.completeCollectionSet((CollectionSet)this);
                }

                public Date getCollectionTimestamp() {
                    return this.m_timestamp;
                }
            };
            return collectionSetResult;
        }

        public Object getCollectCount() {
            return this.m_collectCount;
        }

        public void initialize(Map<String, String> parameters) {
        }

        public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
            String testKey = (String)parameters.get(CollectdIntegrationTest.TEST_KEY_PARM_NAME);
            Assert.assertNotNull((Object)testKey);
            CollectdIntegrationTest.setServiceCollectorInTest(testKey, this);
        }

        public void release() {
            throw new UnsupportedOperationException("MockServiceCollector.release() is not yet implemented");
        }

        public void release(CollectionAgent agent) {
            throw new UnsupportedOperationException("MockServiceCollector.release() is not yet implemented");
        }

        public RrdRepository getRrdRepository(String collectionName) {
            RrdRepository repo = new RrdRepository();
            repo.setRrdBaseDir(new File("/usr/local/opennms/share/rrd/snmp/"));
            repo.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:8928"));
            repo.setStep(300);
            repo.setHeartBeat(600);
            return repo;
        }
    }
}

