/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.protocols.jmx.connectors.Jsr160ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jsr160ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr160ConnectionFactory.class);

    public static Jsr160ConnectionWrapper getMBeanServerConnection(Map<String, ?> propertiesMap, InetAddress address) {
        Jsr160ConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        LOG.debug("JMX: {} - service:{}//{}:{}{}", new Object[]{factory, protocol, InetAddressUtils.str((InetAddress)address), port, urlPath});
        if (factory == null || factory.equals("STANDARD")) {
            try {
                url = new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.str((InetAddress)address) + ":" + port + urlPath);
                JMXConnector connector = JMXConnectorFactory.connect(url);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                LOG.warn("Unable to get MBeanServerConnection: {}", url);
            }
        } else if (factory.equals("PASSWORD-CLEAR")) {
            try {
                String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
                String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
                url = new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.str((InetAddress)address) + ":" + port + urlPath);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SecurityException x) {
                    LOG.error("Security exception: bad credentials");
                    throw x;
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                LOG.error("Unable to get MBeanServerConnection: {}", url, (Object)e);
            }
        }
        return connectionWrapper;
    }
}

