/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyslogReceiver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiver.class);
    private static final int SOCKET_TIMEOUT = 500;
    private volatile boolean m_stop = false;
    private final DatagramSocket m_dgSock;
    private Thread m_context;
    private final String m_matchPattern;
    private final int m_hostGroup;
    private final int m_messageGroup;
    private final String m_discardUei;
    private final UeiList m_UeiList;
    private final HideMessage m_HideMessages;
    private final List<ExecutorService> m_executors = new ArrayList<ExecutorService>();

    SyslogReceiver(DatagramSocket sock, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this.m_dgSock = sock;
        this.m_matchPattern = matchPattern;
        this.m_hostGroup = hostGroup;
        this.m_messageGroup = messageGroup;
        this.m_discardUei = discardUei;
        this.m_UeiList = ueiList;
        this.m_HideMessages = hideMessages;
        this.m_executors.add(new ThreadPoolExecutor(1, Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE, false)));
        this.m_executors.add(new ThreadPoolExecutor(1, Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE, false)));
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        for (ExecutorService service : this.m_executors) {
            service.shutdown();
        }
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)"syslogd");
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        int length = 65535;
        byte[] buffer = new byte[65535];
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting receive buffer size to {}", (Object)65535);
            this.m_dgSock.setReceiveBufferSize(65535);
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)65535, (Object)e);
        }
        boolean ioInterrupted = false;
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                LOG.debug("Thread context interrupted");
                break;
            }
            try {
                if (!ioInterrupted) {
                    LOG.debug("Waiting on a datagram to arrive");
                }
                DatagramPacket pkt = new DatagramPacket(buffer, 65535);
                this.m_dgSock.receive(pkt);
                WaterfallExecutor.waterfall(this.m_executors, (Callable)((Object)new SyslogConnection(pkt, this.m_matchPattern, this.m_hostGroup, this.m_messageGroup, this.m_UeiList, this.m_HideMessages, this.m_discardUei)));
                ioInterrupted = false;
            }
            catch (SocketTimeoutException e) {
                ioInterrupted = true;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (ExecutionException e) {
                LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                break;
            }
            catch (InterruptedException e) {
                LOG.error("Task interrupted in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                break;
            }
            catch (IOException e) {
                LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                break;
            }
        }
        LOG.debug("Thread context exiting");
    }

    protected void setLogPrefix(String prefix) {
    }
}

