/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LegacyScheduler
implements Runnable,
PausableFiber,
Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyScheduler.class);
    private Map<Long, PeekableFifoQueue<ReadyRunnable>> m_queues;
    private int m_scheduled;
    private ExecutorService m_runner;
    private int m_status = 0;
    private Thread m_worker;
    private long m_numTasksExecuted = 0L;

    public LegacyScheduler(String parent, int maxSize) {
        this.m_runner = Executors.newFixedThreadPool(maxSize, (ThreadFactory)new LogPreservingThreadFactory(parent, maxSize, false));
        this.m_queues = new ConcurrentSkipListMap<Long, PeekableFifoQueue<ReadyRunnable>>();
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public LegacyScheduler(String parent, int maxSize, float lowMark, float hiMark) {
        this(parent, maxSize);
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        LOG.debug("schedule: Adding ready runnable {} at interval {}", (Object)runnable, (Object)interval);
        Long key = interval;
        if (!this.m_queues.containsKey(key)) {
            LOG.debug("schedule: interval queue did not exist, a new one has been created");
            this.m_queues.put(key, new PeekableFifoQueue());
        }
        try {
            this.m_queues.get(key).add(runnable);
            if (this.m_scheduled++ == 0) {
                LOG.debug("schedule: queue element added, calling notify all since none were scheduled");
                this.notifyAll();
            } else {
                LOG.debug("schedule: queue element added, notification not performed");
            }
        }
        catch (InterruptedException e) {
            LOG.info("schedule: failed to add new ready runnable instance {} to scheduler", (Object)runnable, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            @Override
            public boolean isReady() {
                return LegacyScheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            @Override
            public void run() {
                runnable.run();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - LegacyScheduler.this.getCurrentTime()) + "ms)";
            }
        };
        this.schedule(timeKeeper, interval);
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized void start() {
        Assert.state((this.m_worker == null ? 1 : 0) != 0, (String)"The fiber has already run or is running");
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        LOG.info("start: scheduler started");
    }

    @Override
    public synchronized void stop() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.shutdown();
        LOG.info("stop: scheduler stopped");
    }

    @Override
    public synchronized void pause() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        Assert.state((this.m_status != 4 && this.m_status != 3 ? 1 : 0) != 0, (String)"The fiber is not running or a stop is pending");
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    @Override
    public synchronized void resume() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        Assert.state((this.m_status != 4 && this.m_status != 3 ? 1 : 0) != 0, (String)"The fiber is not running or a stop is pending");
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    @Override
    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.toString();
    }

    public int getScheduled() {
        return this.m_scheduled;
    }

    public ExecutorService getRunner() {
        return this.m_runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LegacyScheduler legacyScheduler = this;
        synchronized (legacyScheduler) {
            this.m_status = 2;
        }
        LOG.debug("run: scheduler running");
        while (true) {
            legacyScheduler = this;
            synchronized (legacyScheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    LOG.debug("run: status = {}, time to exit", (Object)this.m_status);
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    if (this.m_status == 5) {
                        LOG.debug("run: pausing.");
                    }
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    LOG.debug("run: resuming.");
                    this.m_status = 2;
                }
                if (this.m_scheduled == 0) {
                    try {
                        LOG.debug("run: no ready runnables scheduled, waiting...");
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            Object object = this.m_queues;
            synchronized (object) {
                for (Map.Entry<Long, PeekableFifoQueue<ReadyRunnable>> entry : this.m_queues.entrySet()) {
                    PeekableFifoQueue<ReadyRunnable> in = entry.getValue();
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = in.peek();
                            if (readyRun == null || !readyRun.isReady()) continue;
                            LOG.debug("run: found ready runnable {}", (Object)readyRun);
                            in.remove();
                            this.m_runner.execute(readyRun);
                            ++runned;
                            ++this.m_numTasksExecuted;
                            if (!(this.m_runner instanceof ThreadPoolExecutor)) continue;
                            ThreadPoolExecutor e = (ThreadPoolExecutor)this.m_runner;
                            String ratio = String.format("%.3f", e.getTaskCount() > 0L ? new Double(e.getCompletedTaskCount()) / new Double(e.getTaskCount()) : 0.0);
                            LOG.debug("thread pool statistics: activeCount={}, taskCount={}, completedTaskCount={}, completedRatio={}, poolSize={}", new Object[]{e.getActiveCount(), e.getTaskCount(), e.getCompletedTaskCount(), ratio, e.getPoolSize()});
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (RejectedExecutionException e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    } while (readyRun != null && readyRun.isReady() && --maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        LOG.debug("run: scheduler exiting, state = STOPPED");
        LegacyScheduler legacyScheduler2 = this;
        synchronized (legacyScheduler2) {
            this.m_status = 4;
        }
    }

    @Override
    public long getNumTasksExecuted() {
        return this.m_numTasksExecuted;
    }

    public static final class PeekableFifoQueue<T>
    extends FifoQueueImpl<T> {
        public T peek() throws InterruptedException {
            return (T)this.m_delegate.peek();
        }
    }
}

