/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

public class RTCNodeSvcTime {
    private long m_svcLostTime;
    private long m_svcRegainedTime;

    public RTCNodeSvcTime() {
        this.m_svcLostTime = -1L;
        this.m_svcRegainedTime = -1L;
    }

    public RTCNodeSvcTime(long lostt) {
        this.m_svcLostTime = lostt;
        this.m_svcRegainedTime = -1L;
    }

    public RTCNodeSvcTime(long lostt, long regainedt) {
        this.m_svcLostTime = lostt;
        this.m_svcRegainedTime = regainedt <= 0L ? -1L : regainedt;
    }

    public void setLostTime(long t) {
        this.m_svcLostTime = t;
    }

    public void setRegainedTime(long t) {
        this.m_svcRegainedTime = t <= 0L ? -1L : t;
    }

    public long getLostTime() {
        return this.m_svcLostTime;
    }

    public long getRegainedTime() {
        return this.m_svcRegainedTime;
    }

    public boolean hasExpired(long startOfRollingWindow) {
        if (this.m_svcRegainedTime == -1L) {
            return false;
        }
        return this.m_svcLostTime < startOfRollingWindow && this.m_svcRegainedTime < startOfRollingWindow;
    }

    public long getDownTime(long curTime, long rollingWindow) {
        long downTime = 0L;
        if (curTime < this.m_svcLostTime) {
            return downTime;
        }
        long startTime = curTime - rollingWindow;
        if (this.m_svcRegainedTime == -1L) {
            downTime = this.m_svcLostTime < startTime ? rollingWindow : curTime - this.m_svcLostTime;
        } else if (this.m_svcLostTime >= startTime) {
            downTime = this.m_svcRegainedTime - this.m_svcLostTime;
        } else if (this.m_svcRegainedTime > startTime) {
            downTime = this.m_svcRegainedTime - startTime;
        }
        return downTime;
    }
}

