/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.net.InetAddress;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataUpdater
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DataUpdater.class);
    private Event m_event;

    private void handleNodeGainedService(long nodeid, InetAddress ip, String svcName) {
        if (nodeid == -1L || ip == null || svcName == null) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeGainedService(nodeid, ip, svcName);
        LOG.debug("{} added {}: {}: {} to data store", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
    }

    private void handleNodeLostService(long nodeid, InetAddress ip, String svcName, long eventTime) {
        if (nodeid == -1L || ip == null || svcName == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc/eventtime: {}/{}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName, eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeLostService(nodeid, ip, svcName, eventTime);
        LOG.debug("Added nodeLostService to nodeid: {} ip: {} svcName: {}", new Object[]{svcName, nodeid, InetAddressUtils.str((InetAddress)ip)});
    }

    private void handleInterfaceDown(long nodeid, InetAddress ip, long eventTime) {
        if (nodeid == -1L || ip == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/eventtime: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.interfaceDown(nodeid, ip, eventTime);
        LOG.debug("Recorded interfaceDown for nodeid: {} ip: {}", (Object)InetAddressUtils.str((InetAddress)ip), (Object)nodeid);
    }

    private void handleNodeDown(long nodeid, long eventTime) {
        if (nodeid == -1L || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/eventtime: {}/{}", new Object[]{this.m_event.getUei(), nodeid, eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeDown(nodeid, eventTime);
        LOG.debug("Recorded nodeDown for nodeid: {}", (Object)nodeid);
    }

    private void handleNodeUp(long nodeid, long eventTime) {
        if (nodeid == -1L || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/eventtime: {}/{}", new Object[]{this.m_event.getUei(), nodeid, eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeUp(nodeid, eventTime);
        LOG.debug("Recorded nodeUp for nodeid: {}", (Object)nodeid);
    }

    private void handleInterfaceUp(long nodeid, InetAddress ip, long eventTime) {
        if (nodeid == -1L || ip == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/eventtime: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.interfaceUp(nodeid, ip, eventTime);
        LOG.debug("Recorded interfaceUp for nodeid: {} ip: {}", (Object)InetAddressUtils.str((InetAddress)ip), (Object)nodeid);
    }

    private void handleNodeRegainedService(long nodeid, InetAddress ip, String svcName, long eventTime) {
        if (nodeid == -1L || ip == null || svcName == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc/eventtime: {}/{}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName, eventTime});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeRegainedService(nodeid, ip, svcName, eventTime);
        LOG.debug("Added nodeRegainedService to nodeid: {} ip: {} svcName: {}", new Object[]{svcName, nodeid, InetAddressUtils.str((InetAddress)ip)});
    }

    private void handleServiceDeleted(long nodeid, InetAddress ip, String svcName) {
        if (nodeid == -1L || ip == null || svcName == null) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.serviceDeleted(nodeid, ip, svcName);
        LOG.debug("{} deleted {}: {}: {} from data store", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
    }

    private void handleInterfaceReparented(InetAddress ip, List<Parm> list) {
        if (ip == null || list == null) {
            LOG.warn("{} ignored - info incomplete - ip/parms: {}/{}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), list});
            return;
        }
        long oldNodeId = -1L;
        long newNodeId = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : list) {
            String temp;
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                temp = parmContent;
                try {
                    oldNodeId = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Parameter {} cannot be non-numeric", (Object)"oldNodeID", (Object)nfe);
                    oldNodeId = -1L;
                }
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            temp = parmContent;
            try {
                newNodeId = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Parameter {} cannot be non-numeric", (Object)"newNodeID", (Object)nfe);
                newNodeId = -1L;
            }
        }
        if (oldNodeId == -1L || newNodeId == -1L) {
            LOG.warn("{} did not have all required information for {} Values contained old nodeid: {} new nodeid: {}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), oldNodeId, newNodeId});
        } else {
            DataManager dataMgr = RTCManager.getDataManager();
            dataMgr.interfaceReparented(ip, oldNodeId, newNodeId);
            LOG.debug("{} reparented ip: {} from {} to {}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), oldNodeId, newNodeId});
        }
    }

    private void handleRtcSubscribe(List<Parm> list) {
        if (list == null) {
            LOG.warn("{} ignored - info incomplete (null event parms)", (Object)this.m_event.getUei());
            return;
        }
        String url = null;
        String clabel = null;
        String user = null;
        String passwd = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : list) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("url")) {
                url = parmContent;
                continue;
            }
            if (parmName.equals("catlabel")) {
                clabel = parmContent;
                continue;
            }
            if (parmName.equals("user")) {
                user = parmContent;
                continue;
            }
            if (!parmName.equals("passwd")) continue;
            passwd = parmContent;
        }
        if (url == null || clabel == null || user == null || passwd == null) {
            LOG.warn("{} did not have all required information. Values contained url: {} catlabel: {} user: {} passwd: {}", new Object[]{this.m_event.getUei(), url, clabel, user, passwd});
        } else {
            RTCManager.getInstance().getDataSender().subscribe(url, clabel, user, passwd);
            LOG.debug("{} subscribed {}: {}: {}", new Object[]{this.m_event.getUei(), url, clabel, user});
        }
    }

    private void handleRtcUnsubscribe(List<Parm> list) {
        if (list == null) {
            LOG.warn("{} ignored - info incomplete (null event parms)", (Object)this.m_event.getUei());
            return;
        }
        String url = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : list) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("url")) continue;
            url = parmContent;
        }
        if (url == null) {
            LOG.warn("{} did not have required information.  Value of url: {}", (Object)this.m_event.getUei(), url);
        } else {
            RTCManager.getInstance().getDataSender().unsubscribe(url);
            LOG.debug("{} unsubscribed {}", (Object)this.m_event.getUei(), url);
        }
    }

    private void handleAssetInfoChangedEvent(long nodeid) {
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.assetInfoChanged(nodeid);
        LOG.debug("{} asset info changed for node {}", (Object)this.m_event.getUei(), (Object)nodeid);
    }

    private void handleNodeCategoryMembershipChanged(long nodeid) {
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeCategoryMembershipChanged(nodeid);
        LOG.debug("{} surveillance category membership changed for node {}", (Object)this.m_event.getUei(), (Object)nodeid);
    }

    private void processEvent() {
        if (this.m_event == null) {
            LOG.debug("Event is null, nothing to process");
            return;
        }
        String eventUEI = this.m_event.getUei();
        if (eventUEI == null) {
            LOG.debug("Event received with null UEI, ignoring event");
            return;
        }
        long nodeid = -1L;
        if (this.m_event.hasNodeid()) {
            nodeid = this.m_event.getNodeid();
        }
        InetAddress ip = this.m_event.getInterfaceAddress();
        String svcName = this.m_event.getService();
        long eventTime = -1L;
        String eventTimeStr = this.m_event.getTime();
        try {
            Date date = EventConstants.parseToDate((String)eventTimeStr);
            eventTime = date.getTime();
        }
        catch (ParseException pe) {
            LOG.warn("Failed to convert time {} to java.util.Date, Setting current time instead", (Object)eventTime, (Object)pe);
            eventTime = new Date().getTime();
        }
        LOG.debug("Event UEI: {}\tnodeid: {}\tip: {}\tsvcName: {}\teventTime: {}", new Object[]{eventTimeStr, eventUEI, nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
        if (eventUEI.equals("uei.opennms.org/nodes/nodeGainedService")) {
            this.handleNodeGainedService(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeLostService")) {
            this.handleNodeLostService(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceDown")) {
            this.handleInterfaceDown(nodeid, ip, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeDown")) {
            this.handleNodeDown(nodeid, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeUp")) {
            this.handleNodeUp(nodeid, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceUp")) {
            this.handleInterfaceUp(nodeid, ip, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeRegainedService")) {
            this.handleNodeRegainedService(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceDeleted")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceUnmanaged")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceReparented")) {
            this.handleInterfaceReparented(ip, this.m_event.getParmCollection());
        } else if (eventUEI.equals("uei.opennms.org/internal/rtc/subscribe")) {
            this.handleRtcSubscribe(this.m_event.getParmCollection());
        } else if (eventUEI.equals("uei.opennms.org/internal/rtc/unsubscribe")) {
            this.handleRtcUnsubscribe(this.m_event.getParmCollection());
        } else if (eventUEI.equals("uei.opennms.org/nodes/assetInfoChanged")) {
            this.handleAssetInfoChangedEvent(nodeid);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            this.handleNodeCategoryMembershipChanged(nodeid);
        } else {
            LOG.debug("Event subscribed for not handled?!: {}", (Object)eventUEI);
        }
        RTCManager.getInstance().incrementCounter();
    }

    public DataUpdater(Event event) {
        this.m_event = event;
    }

    @Override
    public void run() {
        try {
            this.processEvent();
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception processing event", t);
        }
    }
}

