/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.IOUtils;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.HttpUtils;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.rtc.datablock.HttpPostInfo;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.utils.EuiLevelMapper;
import org.opennms.netmgt.rtc.utils.PipedMarshaller;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataSender
implements Fiber {
    private static final Logger LOG = LoggerFactory.getLogger(DataSender.class);
    private final Map<String, RTCCategory> m_categories;
    private final Map<String, Set<HttpPostInfo>> m_catUrlMap;
    private final ExecutorService m_dsrPool;
    private final EuiLevelMapper m_euiMapper;
    private final int POST_ERROR_LIMIT;
    private int m_status;

    private int setCurrentThreadPriority(int priority) {
        Thread currentThread = Thread.currentThread();
        int oldPriority = currentThread.getPriority();
        try {
            currentThread.setPriority(priority);
        }
        catch (Throwable t) {
            LOG.debug("Error setting thread priority: ", t);
        }
        return oldPriority;
    }

    public DataSender(Map<String, RTCCategory> categories, int numSenders) {
        this.m_categories = categories;
        this.m_catUrlMap = new HashMap<String, Set<HttpPostInfo>>();
        this.m_dsrPool = Executors.newFixedThreadPool(numSenders, (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), numSenders, false));
        this.m_euiMapper = new EuiLevelMapper();
        this.POST_ERROR_LIMIT = RTCConfigFactory.getInstance().getErrorsBeforeUrlUnsubscribe();
    }

    public synchronized void start() {
        this.m_status = 2;
    }

    public synchronized void stop() {
        this.m_status = 3;
        LOG.info("DataSender - shutting down the data sender pool");
        try {
            this.m_dsrPool.shutdown();
        }
        catch (Throwable t) {
            LOG.error("Error shutting down data sender pool", t);
        }
        this.m_status = 4;
        LOG.info("DataSender shutdown complete");
    }

    public String getName() {
        return "OpenNMS.RTC.DataSender";
    }

    public int getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void subscribe(String url, String catlabel, String user, String passwd) {
        HttpPostInfo postInfo;
        RTCCategory cat = this.m_categories.get(catlabel);
        if (cat == null) {
            LOG.warn("RTC: No information available for category: {}", (Object)catlabel);
            return;
        }
        try {
            postInfo = new HttpPostInfo(url, catlabel, user, passwd);
        }
        catch (MalformedURLException mue) {
            LOG.warn("ERROR subscribing: Invalid URL '{}' - Data WILL NOT be SENT to the specified url", (Object)url);
            return;
        }
        Set<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
        if (urlList == null) {
            urlList = new HashSet<HttpPostInfo>();
            this.m_catUrlMap.put(catlabel, urlList);
        }
        if (!urlList.add(postInfo)) {
            LOG.debug("Already subscribed to URL: {}\tcatlabel: {}\tuser: {} - IGNORING LATEST subscribe event", new Object[]{url, catlabel, user});
        } else {
            LOG.debug("Subscribed to URL: {}\tcatlabel: {}\tuser:{}", new Object[]{url, catlabel, user});
        }
        Reader inr = null;
        InputStream inp = null;
        try {
            int bytesRead;
            LOG.debug("DataSender: posting data to: {}", (Object)url);
            int oldPriority = this.setCurrentThreadPriority(10);
            EuiLevel euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
            inr = new PipedMarshaller(euidata).getReader();
            inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)user, (String)passwd, (int)8192);
            byte[] tmp = new byte[1024];
            while ((bytesRead = inp.read(tmp)) != -1) {
                if (!LOG.isDebugEnabled() || bytesRead <= 0) continue;
                LOG.debug("DataSender: post response: {}", (Object)new String(tmp, 0, bytesRead));
            }
            this.setCurrentThreadPriority(oldPriority);
            LOG.debug("DataSender: posted data for category: {}", (Object)catlabel);
        }
        catch (Throwable t) {
            try {
                LOG.warn("DataSender:  Unable to send category '{}' to URL '{}'", new Object[]{catlabel, url, t});
                this.setCurrentThreadPriority(5);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inp);
                IOUtils.closeQuietly(inr);
                throw throwable;
            }
            IOUtils.closeQuietly(inp);
            IOUtils.closeQuietly((Reader)inr);
        }
        IOUtils.closeQuietly((InputStream)inp);
        IOUtils.closeQuietly((Reader)inr);
    }

    public synchronized void unsubscribe(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            LOG.warn("ERROR unsubscribing: Invalid URL: {}", (Object)urlStr);
            return;
        }
        for (String key : this.m_catUrlMap.keySet()) {
            Set<HttpPostInfo> value = this.m_catUrlMap.get(key);
            if (value == null) continue;
            Iterator<HttpPostInfo> postSet = value.iterator();
            while (postSet.hasNext()) {
                HttpPostInfo postInfo = postSet.next();
                if (!url.toExternalForm().equals(postInfo.getURL().toExternalForm())) continue;
                postSet.remove();
            }
        }
        LOG.debug("Unsubscribed URL: {}", (Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendData() {
        LOG.debug("In DataSender sendData()");
        for (RTCCategory cat : this.m_categories.values()) {
            int oldPriority;
            block10: {
                EuiLevel euidata;
                String catlabel = cat.getLabel();
                LOG.debug("DataSender:sendData(): Category '{}'", (Object)catlabel);
                Set<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
                if (urlList == null || urlList.size() <= 0) {
                    LOG.debug("DataSender: category '{}' has no listeners", (Object)catlabel);
                    continue;
                }
                LOG.debug("DataSender: category '{}' has listeners - converting to xml...", (Object)catlabel);
                oldPriority = this.setCurrentThreadPriority(10);
                try {
                    euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
                }
                catch (Throwable t) {
                    LOG.warn("DataSender: unable to convert data to xml for category: '{}'", (Object)catlabel, (Object)t);
                    this.setCurrentThreadPriority(5);
                    continue;
                }
                if (urlList == null || urlList.size() <= 0) break block10;
                Iterator<HttpPostInfo> urlIter = urlList.iterator();
                while (urlIter.hasNext()) {
                    HttpPostInfo postInfo = urlIter.next();
                    Reader inr = null;
                    InputStream inp = null;
                    try {
                        int bytesRead;
                        inr = new PipedMarshaller(euidata).getReader();
                        LOG.debug("DataSender: posting data to: {}", (Object)postInfo.getURLString());
                        inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)postInfo.getUser(), (String)postInfo.getPassword(), (int)8192);
                        LOG.debug("DataSender: posted data for category: {}", (Object)catlabel);
                        byte[] tmp = new byte[1024];
                        while ((bytesRead = inp.read(tmp)) != -1) {
                            if (!LOG.isDebugEnabled() || bytesRead <= 0) continue;
                            LOG.debug("DataSender: post response: {}", (Object)new String(tmp, 0, bytesRead));
                        }
                        postInfo.clearErrors();
                    }
                    catch (Throwable t) {
                        try {
                            LOG.warn("DataSender: unable to send data for category: {} due to {}: {}", new Object[]{catlabel, t.getClass().getName(), t.getMessage(), t});
                            postInfo.incrementErrors();
                            this.setCurrentThreadPriority(5);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inp);
                            IOUtils.closeQuietly((Reader)inr);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)inp);
                        IOUtils.closeQuietly((Reader)inr);
                    }
                    IOUtils.closeQuietly((InputStream)inp);
                    IOUtils.closeQuietly((Reader)inr);
                    if (this.POST_ERROR_LIMIT <= 0 || postInfo.getErrors() < this.POST_ERROR_LIMIT) continue;
                    urlIter.remove();
                    LOG.warn("URL {} UNSUBSCRIBED due to reaching error limit {}", (Object)postInfo.getURLString(), (Object)postInfo.getErrors());
                }
            }
            this.setCurrentThreadPriority(oldPriority);
        }
    }

    public synchronized void notifyToSend() {
        try {
            this.m_dsrPool.execute(new SendRequest());
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Unable to queue datasender to the dsConsumer queue", (Throwable)e);
        }
    }

    private class SendRequest
    implements Runnable {
        private SendRequest() {
        }

        @Override
        public void run() {
            DataSender.this.sendData();
        }
    }
}

