/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.Base64;
import org.opennms.core.utils.DefaultSocketWrapper;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class HttpMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(HttpMonitor.class);
    private static final Pattern HEADER_PATTERN = Pattern.compile("header[0-9]+$");
    private static final int[] DEFAULT_PORTS = new int[]{80, 8080, 8888};
    private static final int DEFAULT_RETRY = 0;
    private static final String DEFAULT_URL = "/";
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String PARAMETER_VERBOSE = "verbose";
    public static final String PARAMETER_USER_AGENT = "user-agent";
    public static final String PARAMETER_BASIC_AUTHENTICATION = "basic-authentication";
    public static final String PARAMETER_USER = "user";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_RESOLVE_IP = "resolve-ip";
    public static final String PARAMETER_NODE_LABEL_HOST_NAME = "nodelabel-host-name";
    public static final String PARAMETER_HOST_NAME = "host-name";
    public static final String PARAMETER_RESPONSE_TEXT = "response-text";
    public static final String PARAMETER_RESPONSE = "response";
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_PORT = "port";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String nodeLabel = svc.getNodeLabel();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        int currentPort = -1;
        HttpMonitorClient httpClient = new HttpMonitorClient(nodeLabel, (NetworkInterface<InetAddress>)iface, new TreeMap<String, Object>(parameters));
        for (int portIndex = 0; portIndex < this.determinePorts(httpClient.getParameters()).length && httpClient.getPollStatus() != 1; ++portIndex) {
            currentPort = this.determinePorts(httpClient.getParameters())[portIndex];
            httpClient.setTimeoutTracker(new TimeoutTracker(parameters, 0, 3000));
            LOG.debug("Port = {}, Address = {}, {}", new Object[]{currentPort, iface.getAddress(), httpClient.getTimeoutTracker()});
            httpClient.setCurrentPort(currentPort);
            httpClient.getTimeoutTracker().reset();
            while (httpClient.getTimeoutTracker().shouldRetry() && httpClient.getPollStatus() != 1) {
                try {
                    httpClient.getTimeoutTracker().startAttempt();
                    httpClient.connect();
                    LOG.debug("HttpMonitor: connected to host: {} on port: {}", iface.getAddress(), (Object)currentPort);
                    httpClient.sendHttpCommand();
                    if (!httpClient.isEndOfStream()) {
                        httpClient.setResponseTime(httpClient.getTimeoutTracker().elapsedTimeInMillis());
                        this.logResponseTimes(httpClient.getResponseTime(), httpClient.getCurrentLine());
                        if (httpClient.getPollStatus() == 1 && StringUtils.isNotBlank((String)httpClient.getResponseText())) {
                            httpClient.setPollStatus(2);
                            httpClient.readLinedMatching();
                            if (!httpClient.isEndOfStream()) {
                                httpClient.read();
                                if (!httpClient.isResponseTextFound()) {
                                    String message = "Matching text: [" + httpClient.getResponseText() + "] not found in body of HTTP response";
                                    LOG.debug(message);
                                    httpClient.setReason("Matching text: [" + httpClient.getResponseText() + "] not found in body of HTTP response");
                                }
                            }
                        }
                    }
                }
                catch (NoRouteToHostException e) {
                    LOG.warn("checkStatus: No route to host exception for address {}", iface.getAddress(), (Object)e);
                    portIndex = this.determinePorts(httpClient.getParameters()).length;
                    httpClient.setReason("No route to host exception");
                }
                catch (SocketTimeoutException e) {
                    LOG.info("checkStatus: HTTP socket connection timed out with {}", (Object)httpClient.getTimeoutTracker().toString());
                    httpClient.setReason("HTTP connection timeout");
                }
                catch (InterruptedIOException e) {
                    LOG.info(String.format("checkStatus: HTTP connection interrupted after %d bytes transferred with %s", e.bytesTransferred, httpClient.getTimeoutTracker().toString()), (Throwable)e);
                    httpClient.setReason(String.format("HTTP connection interrupted, %d bytes transferred", e.bytesTransferred));
                }
                catch (ConnectException e) {
                    LOG.warn("Connection exception for {}:{}", new Object[]{iface.getAddress(), this.determinePorts(httpClient.getParameters())[portIndex], e});
                    httpClient.setReason("HTTP connection exception on port: " + this.determinePorts(httpClient.getParameters())[portIndex] + ": " + e.getMessage());
                }
                catch (IOException e) {
                    LOG.warn("IOException while polling address {}", iface.getAddress(), (Object)e);
                    httpClient.setReason("IOException while polling address: " + iface.getAddress() + ": " + e.getMessage());
                }
                catch (Throwable e) {
                    LOG.warn("Unexpected exception while polling address {}", iface.getAddress(), (Object)e);
                    httpClient.setReason("Unexpected exception while polling address: " + iface.getAddress() + ": " + e.getMessage());
                }
                finally {
                    httpClient.closeConnection();
                }
                httpClient.getTimeoutTracker().nextAttempt();
            }
        }
        return httpClient.determinePollStatusResponse();
    }

    private void logResponseTimes(Double responseTime, String line) {
        LOG.debug("poll: response= {}", (Object)line);
        LOG.debug("poll: responseTime= {}ms", (Object)responseTime);
    }

    protected SocketWrapper getSocketWrapper() {
        return new DefaultSocketWrapper();
    }

    private static boolean determineVerbosity(Map<String, Object> parameters) {
        String verbose = ParameterMap.getKeyedString(parameters, (String)PARAMETER_VERBOSE, null);
        return verbose != null && verbose.equalsIgnoreCase("true");
    }

    private static String determineUserAgent(Map<String, Object> parameters) {
        String agent = ParameterMap.getKeyedString(parameters, (String)PARAMETER_USER_AGENT, null);
        if (HttpMonitor.isBlank(agent)) {
            return "OpenNMS HttpMonitor";
        }
        return agent;
    }

    static String determineBasicAuthentication(Map<String, Object> parameters) {
        String credentials = ParameterMap.getKeyedString(parameters, (String)PARAMETER_BASIC_AUTHENTICATION, null);
        if (HttpMonitor.isNotBlank(credentials)) {
            credentials = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        } else {
            String user = ParameterMap.getKeyedString(parameters, (String)PARAMETER_USER, null);
            if (HttpMonitor.isBlank(user)) {
                credentials = null;
            } else {
                String passwd = ParameterMap.getKeyedString(parameters, (String)PARAMETER_PASSWORD, (String)"");
                credentials = new String(Base64.encodeBase64((byte[])(user + ":" + passwd).getBytes()));
            }
        }
        return credentials;
    }

    private static String determineHttpHeader(Map<String, Object> parameters, String key) {
        return ParameterMap.getKeyedString(parameters, (String)key, null);
    }

    private static String determineResponseText(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)PARAMETER_RESPONSE_TEXT, null);
    }

    private static String determineResponse(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)PARAMETER_RESPONSE, (String)HttpMonitor.determineDefaultResponseRange(HttpMonitor.determineUrl(parameters)));
    }

    private static String determineUrl(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)PARAMETER_URL, (String)DEFAULT_URL);
    }

    protected int[] determinePorts(Map<String, Object> parameters) {
        return ParameterMap.getKeyedIntegerArray(parameters, (String)PARAMETER_PORT, (int[])DEFAULT_PORTS);
    }

    private static String determineDefaultResponseRange(String url) {
        if (url == null || url.equals(DEFAULT_URL)) {
            return "100-499";
        }
        return "100-399";
    }

    private static boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((String)str);
    }

    private static boolean isBlank(String str) {
        return StringUtils.isBlank((String)str);
    }

    final class HttpMonitorClient {
        private double m_responseTime;
        final NetworkInterface<InetAddress> m_iface;
        final Map<String, Object> m_parameters;
        String m_httpCmd;
        Socket m_httpSocket;
        private BufferedReader m_lineRdr;
        private String m_currentLine;
        private int m_serviceStatus;
        private String m_reason;
        private final StringBuffer m_html = new StringBuffer();
        private int m_serverResponseCode;
        private TimeoutTracker m_timeoutTracker;
        private int m_currentPort;
        private String m_responseText;
        private boolean m_responseTextFound = false;
        private final String m_nodeLabel;
        private boolean m_headerFinished = false;

        HttpMonitorClient(String nodeLabel, NetworkInterface<InetAddress> iface, TreeMap<String, Object> parameters) {
            this.m_nodeLabel = nodeLabel;
            this.m_iface = iface;
            this.m_parameters = parameters;
            this.buildCommand();
            this.m_serviceStatus = 2;
            this.m_responseText = HttpMonitor.determineResponseText(parameters);
        }

        public void read() throws IOException {
            int nullCount = 0;
            while (nullCount < 2) {
                this.readLinedMatching();
                if (!this.isEndOfStream()) continue;
                ++nullCount;
            }
        }

        public int getCurrentPort() {
            return this.m_currentPort;
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public boolean isResponseTextFound() {
            return this.m_responseTextFound;
        }

        public void setResponseTextFound(boolean found) {
            this.m_responseTextFound = found;
        }

        private String determineVirtualHost(NetworkInterface<InetAddress> iface, Map<String, Object> parameters) {
            boolean res = ParameterMap.getKeyedBoolean(parameters, (String)HttpMonitor.PARAMETER_RESOLVE_IP, (boolean)false);
            boolean useNodeLabel = ParameterMap.getKeyedBoolean(parameters, (String)HttpMonitor.PARAMETER_NODE_LABEL_HOST_NAME, (boolean)false);
            String virtualHost = ParameterMap.getKeyedString(parameters, (String)HttpMonitor.PARAMETER_HOST_NAME, null);
            if (HttpMonitor.isBlank(virtualHost)) {
                if (res) {
                    return ((InetAddress)iface.getAddress()).getCanonicalHostName();
                }
                if (useNodeLabel) {
                    return this.m_nodeLabel;
                }
                InetAddress addr = (InetAddress)iface.getAddress();
                String host = InetAddressUtils.str((InetAddress)((InetAddress)iface.getAddress()));
                if (addr instanceof Inet6Address) {
                    return "[" + host + "]";
                }
                return host;
            }
            return virtualHost;
        }

        public boolean checkCurrentLineMatchesResponseText() {
            if (!this.m_headerFinished && StringUtils.isEmpty((String)this.m_currentLine)) {
                this.m_headerFinished = true;
            }
            if (!this.m_headerFinished) {
                return false;
            }
            this.m_responseTextFound = this.m_responseText.charAt(0) == '~' && !this.m_responseTextFound ? this.m_currentLine.matches(this.m_responseText.substring(1)) : this.m_currentLine.indexOf(this.m_responseText) != -1;
            return this.m_responseTextFound;
        }

        public String getResponseText() {
            return this.m_responseText;
        }

        public void setResponseText(String responseText) {
            this.m_responseText = responseText;
        }

        public void setCurrentPort(int currentPort) {
            this.m_currentPort = currentPort;
        }

        public TimeoutTracker getTimeoutTracker() {
            return this.m_timeoutTracker;
        }

        public void setTimeoutTracker(TimeoutTracker tracker) {
            this.m_timeoutTracker = tracker;
        }

        public Double getResponseTime() {
            return this.m_responseTime;
        }

        public void setResponseTime(double elapsedTimeInMillis) {
            this.m_responseTime = elapsedTimeInMillis;
        }

        private void connect() throws IOException, SocketException {
            this.m_httpSocket = new Socket();
            this.m_httpSocket.connect(new InetSocketAddress((InetAddress)this.m_iface.getAddress(), this.m_currentPort), this.m_timeoutTracker.getConnectionTimeout());
            this.m_serviceStatus = 3;
            this.m_httpSocket.setSoTimeout(this.m_timeoutTracker.getSoTimeout());
            this.m_httpSocket = HttpMonitor.this.getSocketWrapper().wrapSocket(this.m_httpSocket);
        }

        public void closeConnection() {
            try {
                if (this.m_httpSocket != null) {
                    this.m_httpSocket.close();
                    this.m_httpSocket = null;
                }
            }
            catch (IOException e) {
                e.fillInStackTrace();
                LOG.warn("Error closing socket connection", (Throwable)e);
            }
        }

        public int getPollStatus() {
            return this.m_serviceStatus;
        }

        public void setPollStatus(int serviceStatus) {
            this.m_serviceStatus = serviceStatus;
        }

        public String getCurrentLine() {
            return this.m_currentLine;
        }

        public int getServerResponse() {
            return this.m_serverResponseCode;
        }

        private void determineServerInitialResponse() {
            int serverResponseValue = -1;
            if (this.m_currentLine != null && this.m_currentLine.startsWith("HTTP/")) {
                serverResponseValue = this.parseHttpResponse();
                if (IPLike.matchNumericListOrRange((String)String.valueOf(serverResponseValue), (String)HttpMonitor.determineResponse(this.m_parameters))) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("determineServerResponse: valid server response: " + serverResponseValue + " found.");
                    }
                    this.m_serviceStatus = 1;
                } else {
                    this.m_serviceStatus = 2;
                    StringBuffer sb = new StringBuffer();
                    sb.append("HTTP response value: ");
                    sb.append(serverResponseValue);
                    sb.append(". Expecting: ");
                    sb.append(HttpMonitor.determineResponse(this.m_parameters));
                    sb.append(".");
                    this.m_reason = sb.toString();
                }
            }
            this.m_serverResponseCode = serverResponseValue;
        }

        private int parseHttpResponse() {
            int serverResponse;
            block4: {
                StringTokenizer t = new StringTokenizer(this.m_currentLine);
                if (t.hasMoreTokens()) {
                    t.nextToken();
                }
                serverResponse = -1;
                if (t.hasMoreTokens()) {
                    try {
                        serverResponse = Integer.parseInt(t.nextToken());
                    }
                    catch (NumberFormatException nfE) {
                        if (!LOG.isInfoEnabled()) break block4;
                        LOG.info("Error converting response code from host = {}, response = {}", this.m_iface.getAddress(), (Object)this.m_currentLine);
                    }
                }
            }
            return serverResponse;
        }

        public boolean isEndOfStream() {
            return this.m_currentLine == null;
        }

        public String readLine() throws IOException {
            this.m_currentLine = this.m_lineRdr.readLine();
            if (HttpMonitor.determineVerbosity(this.m_parameters) && LOG.isDebugEnabled()) {
                LOG.debug("\t<<: {}", (Object)this.m_currentLine);
            }
            this.m_html.append(this.m_currentLine);
            return this.m_currentLine;
        }

        public String readLinedMatching() throws IOException {
            this.readLine();
            if (this.m_responseText != null && this.m_currentLine != null && !this.m_responseTextFound && this.checkCurrentLineMatchesResponseText()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response-text: " + this.m_responseText + ": found.");
                }
                this.m_serviceStatus = 1;
            }
            return this.m_currentLine;
        }

        public void sendHttpCommand() throws IOException {
            if (HttpMonitor.determineVerbosity(this.m_parameters) && LOG.isDebugEnabled()) {
                LOG.debug("Sending HTTP command: {}", (Object)this.m_httpCmd);
            }
            this.m_httpSocket.getOutputStream().write(this.m_httpCmd.getBytes());
            this.m_lineRdr = new BufferedReader(new InputStreamReader(this.m_httpSocket.getInputStream()));
            this.readLine();
            if (HttpMonitor.determineVerbosity(this.m_parameters)) {
                LOG.debug("Server response: {}", (Object)this.m_currentLine);
            }
            this.determineServerInitialResponse();
            this.m_headerFinished = false;
        }

        private void buildCommand() {
            StringBuilder sb = new StringBuilder();
            sb.append("GET ").append(HttpMonitor.determineUrl(this.m_parameters)).append(" HTTP/1.1\r\n");
            sb.append("Connection: CLOSE \r\n");
            sb.append("Host: ").append(this.determineVirtualHost(this.m_iface, this.m_parameters)).append("\r\n");
            sb.append("User-Agent: ").append(HttpMonitor.determineUserAgent(this.m_parameters)).append("\r\n");
            if (HttpMonitor.determineBasicAuthentication(this.m_parameters) != null) {
                sb.append("Authorization: Basic ").append(HttpMonitor.determineBasicAuthentication(this.m_parameters)).append("\r\n");
            }
            for (String parmKey : this.m_parameters.keySet()) {
                if (!HEADER_PATTERN.matcher(parmKey).matches()) continue;
                sb.append(HttpMonitor.determineHttpHeader(this.m_parameters, parmKey)).append("\r\n");
            }
            sb.append("\r\n");
            String cmd = sb.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkStatus: cmd:\n", (Object)cmd);
            }
            this.m_httpCmd = cmd;
        }

        public void setReason(String reason) {
            this.m_reason = reason;
        }

        public String getReason() {
            return this.m_reason;
        }

        public Socket getHttpSocket() {
            return this.m_httpSocket;
        }

        public void setHttpSocket(Socket httpSocket) {
            this.m_httpSocket = httpSocket;
        }

        protected PollStatus determinePollStatusResponse() {
            if (this.getPollStatus() == 2) {
                StringBuffer testedPorts = new StringBuffer();
                for (int i = 0; i < HttpMonitor.this.determinePorts(this.getParameters()).length; ++i) {
                    if (i == 0) {
                        testedPorts.append(HttpMonitor.this.determinePorts(this.getParameters())[0]);
                        continue;
                    }
                    testedPorts.append(',').append(HttpMonitor.this.determinePorts(this.getParameters())[i]);
                }
                this.getParameters().put("qualifier", testedPorts.toString());
                this.setReason(this.getReason() + "/Ports: " + testedPorts.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("checkStatus: Reason: \"" + this.getReason() + "\"");
                }
                return PollStatus.unavailable((String)this.getReason());
            }
            if (this.getPollStatus() == 1) {
                this.getParameters().put("qualifier", Integer.toString(this.getCurrentPort()));
                return PollStatus.available((Double)this.getResponseTime());
            }
            return PollStatus.get((int)this.getPollStatus(), (String)this.getReason());
        }
    }
}

