/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpStore;

public abstract class IpRouteCollectorEntry
extends SnmpStore {
    public static final int IP_ROUTE_ACTIVE_STATUS = 1;
    public static final String IP_ROUTE_DEST = "ipRouteDest";
    public static final String IP_ROUTE_IFINDEX = "ipRouteIfIndex";
    public static final String IP_ROUTE_METRIC1 = "ipRouteMetric1";
    public static final String IP_ROUTE_METRIC2 = "ipRouteMetric2";
    public static final String IP_ROUTE_METRIC3 = "ipRouteMetric3";
    public static final String IP_ROUTE_METRIC4 = "ipRouteMetric4";
    public static final String IP_ROUTE_NXTHOP = "ipRouteNextHop";
    public static final String IP_ROUTE_TYPE = "ipRouteType";
    public static final String IP_ROUTE_PROTO = "ipRouteProto";
    public static final String IP_ROUTE_AGE = "ipRouteAge";
    public static final String IP_ROUTE_MASK = "ipRouteMask";
    public static final String IP_ROUTE_METRIC5 = "ipRouteMetric5";
    public static final String IP_ROUTE_INFO = "ipRouteInfo";
    public static final String IP_ROUTE_STATUS = "ipRouteStatus";

    protected IpRouteCollectorEntry(NamedSnmpVar[] list) {
        super(list);
    }

    public InetAddress getIpRouteDest() {
        return this.getIPAddress(IP_ROUTE_DEST);
    }

    public Integer getIpRouteIfIndex() {
        return this.getInt32(IP_ROUTE_IFINDEX);
    }

    public Integer getIpRouteMetric1() {
        return this.getInt32(IP_ROUTE_METRIC1);
    }

    public Integer getIpRouteMetric2() {
        return this.getInt32(IP_ROUTE_METRIC2);
    }

    public Integer getIpRouteMetric3() {
        return this.getInt32(IP_ROUTE_METRIC3);
    }

    public Integer getIpRouteMetric4() {
        return this.getInt32(IP_ROUTE_METRIC4);
    }

    public InetAddress getIpRouteNextHop() {
        return this.getIPAddress(IP_ROUTE_NXTHOP);
    }

    public Integer getIpRouteType() {
        return this.getInt32(IP_ROUTE_TYPE);
    }

    public Integer getIpRouteProto() {
        return this.getInt32(IP_ROUTE_PROTO);
    }

    public Integer getIpRouteAge() {
        return this.getInt32(IP_ROUTE_AGE);
    }

    public InetAddress getIpRouteMask() {
        return this.getIPAddress(IP_ROUTE_MASK);
    }

    public Integer getIpRouteMetric5() {
        return this.getInt32(IP_ROUTE_METRIC5);
    }

    public String getIpRouteInfo() {
        return this.getObjectID(IP_ROUTE_INFO);
    }

    public Integer getIpRouteStatus() {
        return this.getInt32(IP_ROUTE_STATUS);
    }

    public OnmsIpRouteInterface getOnmsIpRouteInterface(OnmsIpRouteInterface ipRouteInterface) {
        if (this.getIpRouteDest() == null || this.getIpRouteIfIndex() == null || this.getIpRouteMask() == null || this.getIpRouteNextHop() == null) {
            return null;
        }
        ipRouteInterface.setRouteDest(InetAddressUtils.str((InetAddress)this.getIpRouteDest()));
        ipRouteInterface.setRouteIfIndex(this.getIpRouteIfIndex());
        ipRouteInterface.setRouteMask(InetAddressUtils.str((InetAddress)this.getIpRouteMask()));
        ipRouteInterface.setRouteMetric1(this.getIpRouteMetric1());
        ipRouteInterface.setRouteMetric2(this.getIpRouteMetric2());
        ipRouteInterface.setRouteMetric3(this.getIpRouteMetric3());
        ipRouteInterface.setRouteMetric4(this.getIpRouteMetric4());
        ipRouteInterface.setRouteMetric5(this.getIpRouteMetric5());
        ipRouteInterface.setRouteNextHop(InetAddressUtils.str((InetAddress)this.getIpRouteNextHop()));
        ipRouteInterface.setRouteProto(this.getIpRouteProto());
        ipRouteInterface.setRouteType(OnmsIpRouteInterface.RouteType.get((Integer)this.getIpRouteType()));
        return ipRouteInterface;
    }
}

