/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CdpGlobalGroup
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CdpGlobalGroup.class);
    public static final String CDP_GLOBAL_DEVICEID = "cdpGlobalDeviceId";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalDeviceId", ".1.3.6.1.4.1.9.9.23.1.3.4")};
    private SnmpStore m_store;
    private InetAddress m_address;

    public CdpGlobalGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    public String getCdpDeviceId() {
        return this.m_store.getDisplayString(CDP_GLOBAL_DEVICEID);
    }
}

