/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.CdpGlobalGroup;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTable;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTable;
import org.opennms.netmgt.linkd.snmp.IsIsSystemObjectGroup;
import org.opennms.netmgt.linkd.snmp.IsisCircTable;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTable;
import org.opennms.netmgt.linkd.snmp.LldpLocTable;
import org.opennms.netmgt.linkd.snmp.LldpLocalGroup;
import org.opennms.netmgt.linkd.snmp.LldpRemTable;
import org.opennms.netmgt.linkd.snmp.MtxrWlRtabTable;
import org.opennms.netmgt.linkd.snmp.OspfGeneralGroup;
import org.opennms.netmgt.linkd.snmp.OspfNbrTable;
import org.opennms.netmgt.linkd.snmp.SnmpTable;
import org.opennms.netmgt.linkd.snmp.VlanTable;
import org.opennms.netmgt.linkd.snmp.VlanTableBasic;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpCollection
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollection.class);
    private SnmpAgentConfig m_agentConfig;
    private final int m_nodeid;
    private final InetAddress m_address;
    private String m_vlanClass = null;
    private String m_ipRouteClass = null;
    private boolean m_collectVlan = false;
    private boolean m_collectIpRoute = false;
    private boolean m_collectStp = false;
    private boolean m_collectBridge = false;
    private boolean m_collectIpNetToMedia = false;
    private boolean m_collectWifi = false;
    private boolean m_collectCdp = false;
    private boolean m_collectLldp = false;
    private boolean m_collectOspf = false;
    private boolean m_collectIsIs = false;
    public MtxrWlRtabTable m_mtxrWlRtabTable;
    public LldpLocalGroup m_lldpLocalGroup;
    public LldpLocTable m_lldpLocTable;
    public LldpRemTable m_lldpRemTable;
    public OspfGeneralGroup m_ospfGeneralGroup;
    public OspfNbrTable m_ospfNbrTable;
    public IsIsSystemObjectGroup m_isisSystemObjectGroup;
    public IsisISAdjTable m_isisISAdjTable;
    public IsisCircTable m_isisCircTable;
    public IpNetToMediaTable m_ipNetToMedia;
    public SnmpTable<SnmpStore> m_ipRoute;
    public CdpGlobalGroup m_cdpGlobalGroup;
    public CdpCacheTable m_cdpCache;
    public CdpInterfaceTable m_cdpInterface;
    public SnmpTable<SnmpStore> m_vlanTable;
    public final Map<OnmsVlan, SnmpVlanCollection> m_snmpVlanCollection = new HashMap<OnmsVlan, SnmpVlanCollection>();
    private Scheduler m_scheduler;
    private long poll_interval = 1800000L;
    private long initial_sleep_time = 600000L;
    private boolean suspendCollection = false;
    private boolean runned = false;
    private String packageName;
    private final Linkd m_linkd;

    public SnmpAgentConfig getAgentConfig() {
        return this.m_agentConfig;
    }

    public void setAgentConfig(SnmpAgentConfig agentConfig) {
        this.m_agentConfig = agentConfig;
    }

    public SnmpCollection(Linkd linkd, int nodeid, SnmpAgentConfig config) {
        this.m_linkd = linkd;
        this.m_agentConfig = config;
        this.m_nodeid = nodeid;
        this.m_address = this.m_agentConfig.getEffectiveAddress();
    }

    boolean hasMtxrWlRtabTable() {
        return this.m_mtxrWlRtabTable != null && !this.m_mtxrWlRtabTable.failed() && !this.m_mtxrWlRtabTable.isEmpty();
    }

    MtxrWlRtabTable getMtxrWlRtabTable() {
        return this.m_mtxrWlRtabTable;
    }

    boolean hasIsIsSysObjectGroup() {
        return this.m_isisSystemObjectGroup != null && !this.m_isisSystemObjectGroup.failed() && this.m_isisSystemObjectGroup.getIsisSysId() != null;
    }

    IsIsSystemObjectGroup getIsIsSystemObjectGroup() {
        return this.m_isisSystemObjectGroup;
    }

    boolean hasOspfGeneralGroup() {
        return this.m_ospfGeneralGroup != null && !this.m_ospfGeneralGroup.failed() && this.m_ospfGeneralGroup.getOspfRouterId() != null;
    }

    boolean hasIsisCircTable() {
        return this.m_isisCircTable != null && !this.m_isisCircTable.failed() && !this.m_isisCircTable.isEmpty();
    }

    IsisCircTable getIsisCircTable() {
        return this.m_isisCircTable;
    }

    boolean hasIsisISAdjTable() {
        return this.m_isisISAdjTable != null && !this.m_isisISAdjTable.failed() && !this.m_isisISAdjTable.isEmpty();
    }

    IsisISAdjTable getIsisISAdjTable() {
        return this.m_isisISAdjTable;
    }

    OspfGeneralGroup getOspfGeneralGroup() {
        return this.m_ospfGeneralGroup;
    }

    public boolean hasOspfNbrTable() {
        return this.m_ospfNbrTable != null && !this.m_ospfNbrTable.failed() && !this.m_ospfNbrTable.isEmpty();
    }

    OspfNbrTable getOspfNbrTable() {
        return this.m_ospfNbrTable;
    }

    boolean hasLldpLocalGroup() {
        return this.m_lldpLocalGroup != null && !this.m_lldpLocalGroup.failed() && this.m_lldpLocalGroup.getLldpLocChassisid() != null;
    }

    LldpLocalGroup getLldpLocalGroup() {
        return this.m_lldpLocalGroup;
    }

    boolean hasLldpRemTable() {
        return this.m_lldpRemTable != null && !this.m_lldpRemTable.failed() && !this.m_lldpRemTable.isEmpty();
    }

    LldpRemTable getLldpRemTable() {
        return this.m_lldpRemTable;
    }

    boolean hasLldpLocTable() {
        return this.m_lldpLocTable != null && !this.m_lldpLocTable.failed() && !this.m_lldpLocTable.isEmpty();
    }

    LldpLocTable getLldpLocTable() {
        return this.m_lldpLocTable;
    }

    boolean hasIpNetToMediaTable() {
        return this.m_ipNetToMedia != null && !this.m_ipNetToMedia.failed() && !this.m_ipNetToMedia.isEmpty();
    }

    IpNetToMediaTable getIpNetToMediaTable() {
        return this.m_ipNetToMedia;
    }

    boolean hasRouteTable() {
        return this.m_ipRoute != null && !this.m_ipRoute.failed() && !this.m_ipRoute.isEmpty();
    }

    SnmpTable<SnmpStore> getIpRouteTable() {
        return this.m_ipRoute;
    }

    boolean hasCdpGlobalGroup() {
        return this.m_cdpGlobalGroup != null && !this.m_cdpGlobalGroup.failed() && this.m_cdpGlobalGroup.getCdpDeviceId() != null;
    }

    CdpGlobalGroup getCdpGlobalGroup() {
        return this.m_cdpGlobalGroup;
    }

    boolean hasCdpCacheTable() {
        return this.m_cdpCache != null && !this.m_cdpCache.failed() && !this.m_cdpCache.isEmpty();
    }

    CdpCacheTable getCdpCacheTable() {
        return this.m_cdpCache;
    }

    boolean hasCdpInterfaceTable() {
        return this.m_cdpInterface != null && !this.m_cdpInterface.failed() && !this.m_cdpInterface.isEmpty();
    }

    CdpInterfaceTable getCdpInterfaceTable() {
        return this.m_cdpInterface;
    }

    boolean hasVlanTable() {
        return this.m_vlanTable != null && !this.m_vlanTable.failed() && !this.m_vlanTable.isEmpty();
    }

    SnmpTable<SnmpStore> getVlanTable() {
        return this.m_vlanTable;
    }

    Map<OnmsVlan, SnmpVlanCollection> getSnmpVlanCollections() {
        return this.m_snmpVlanCollection;
    }

    private void sendSuspendedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoverySuspended", "Linkd"));
    }

    private void sendStartedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryStarted", "Linkd"));
    }

    private void sendCompletedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryCompleted", "Linkd"));
    }

    private void sendEvent(EventBuilder builder) {
        builder.setNodeid((long)this.m_nodeid);
        builder.setInterface(this.m_address);
        builder.addParam("runnable", "snmpCollection/" + this.getPackageName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }

    @Override
    public void run() {
        this.runned = true;
        if (this.suspendCollection) {
            this.sendSuspendedEvent();
            LOG.debug("run: address: {} Suspended!", (Object)InetAddressUtils.str((InetAddress)this.m_address));
        } else {
            this.sendStartedEvent();
            this.runCollection();
            this.sendCompletedEvent();
        }
    }

    private void runCollection() {
        String hostAddress = InetAddressUtils.str((InetAddress)this.m_address);
        this.m_ipNetToMedia = new IpNetToMediaTable(this.m_address);
        this.m_cdpGlobalGroup = new CdpGlobalGroup(this.m_address);
        this.m_cdpCache = new CdpCacheTable(this.m_address);
        this.m_cdpInterface = new CdpInterfaceTable(this.m_address);
        this.m_lldpLocalGroup = new LldpLocalGroup(this.m_address);
        this.m_lldpRemTable = new LldpRemTable(this.m_address);
        this.m_lldpLocTable = new LldpLocTable(this.m_address);
        this.m_ospfGeneralGroup = new OspfGeneralGroup(this.m_address);
        this.m_ospfNbrTable = new OspfNbrTable(this.m_address);
        this.m_isisSystemObjectGroup = new IsIsSystemObjectGroup(this.m_address);
        this.m_isisCircTable = new IsisCircTable(this.m_address);
        this.m_isisISAdjTable = new IsisISAdjTable(this.m_address);
        this.m_mtxrWlRtabTable = new MtxrWlRtabTable(this.m_address);
        if (this.m_collectIpRoute) {
            this.m_ipRoute = this.createClass(this.m_ipRouteClass, this.m_address);
        }
        if (this.m_collectVlan) {
            this.m_vlanTable = this.createClass(this.m_vlanClass, this.m_address);
        }
        LOG.debug("run: address {} package {}: collecting on agent: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_agentConfig});
        LOG.info("run: address {} package {}: collectIpNetToMedia: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectIpNetToMedia});
        LOG.info("run: address {} package {}: collectOspf: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectOspf});
        LOG.info("run: address {} package {}: collectIsIs: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectIsIs});
        LOG.info("run: address {} package {}: collectLldp: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectLldp});
        LOG.info("run: address {} package {}: collectIpRoute: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectIpRoute});
        LOG.info("run: address {} package {}: collectCdp: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectCdp});
        LOG.info("run: address {} package {}: collectVlan: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectVlan});
        LOG.info("run: address {} package {}: collectWifi: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectWifi});
        SnmpWalker walker = null;
        TrackerBuilder bldr = new TrackerBuilder();
        if (this.m_collectIpNetToMedia) {
            bldr.add("ipNetToMediaTable", new CollectionTracker[]{this.m_ipNetToMedia});
        }
        if (this.m_collectOspf) {
            bldr.add("ospfGeneralGroup/ospfNbrTable", new CollectionTracker[]{this.m_ospfGeneralGroup, this.m_ospfNbrTable});
        }
        if (this.m_collectIsIs) {
            bldr.add("isisSystemObjectGroup/isisCircTable/isisISAdjTable", new CollectionTracker[]{this.m_isisSystemObjectGroup, this.m_isisCircTable, this.m_isisISAdjTable});
        }
        if (this.m_collectLldp) {
            bldr.add("lldpLocalGroup/lldpLocTable/lldpRemTable", new CollectionTracker[]{this.m_lldpLocalGroup, this.m_lldpLocTable, this.m_lldpRemTable});
        }
        if (this.m_collectIpRoute && this.m_ipRoute != null) {
            bldr.add("ipRouteTable", new CollectionTracker[]{this.m_ipRoute});
        }
        if (this.m_collectCdp) {
            bldr.add("cdpGlobalGroup/cdpInterface/cdpCacheTable", new CollectionTracker[]{this.m_cdpGlobalGroup, this.m_cdpInterface, this.m_cdpCache});
        }
        if (this.m_collectVlan && this.m_vlanTable != null) {
            bldr.add("vlanTable", new CollectionTracker[]{this.m_vlanTable});
        }
        if (this.m_collectWifi && this.m_mtxrWlRtabTable != null) {
            bldr.add("mtxrWlRtabTable", new CollectionTracker[]{this.m_mtxrWlRtabTable});
        }
        LOG.debug("run: package {}: Collecting {} from {}", new Object[]{this.getPackageName(), bldr.getMessage(), InetAddressUtils.str((InetAddress)this.m_agentConfig.getEffectiveAddress())});
        if (!bldr.isEmpty()) {
            walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agentConfig, (String)bldr.getMessage(), (CollectionTracker[])bldr.getTrackers());
            walker.start();
            try {
                walker.waitFor();
            }
            catch (InterruptedException e) {
                LOG.error("run: collection interrupted, exiting", (Throwable)e);
                return;
            }
        }
        if (this.m_collectOspf && !this.hasOspfGeneralGroup()) {
            LOG.info("run: failed to collect ospfGeneralGroup for {}", (Object)hostAddress);
        }
        if (this.m_collectOspf && !this.hasOspfNbrTable()) {
            LOG.info("run: failed to collect ospfNbrTable for {}", (Object)hostAddress);
        }
        if (this.m_collectIsIs && !this.hasIsIsSysObjectGroup()) {
            LOG.info("run: failed to collect IsIsSysObjectGroup for {}", (Object)hostAddress);
        }
        if (this.m_collectIsIs && !this.hasIsisCircTable()) {
            LOG.info("run: failed to collect IsisCircTable for {}", (Object)hostAddress);
        }
        if (this.m_collectIsIs && !this.hasIsisISAdjTable()) {
            LOG.info("run: failed to collect IsisIsAdjTable for {}", (Object)hostAddress);
        }
        if (this.m_collectLldp && !this.hasLldpLocalGroup()) {
            LOG.info("run: failed to collect lldpLocalGroup for {}", (Object)hostAddress);
        }
        if (this.m_collectLldp && !this.hasLldpLocTable()) {
            LOG.info("run: failed to collect lldpLocTable for {}", (Object)hostAddress);
        }
        if (this.m_collectLldp && !this.hasLldpRemTable()) {
            LOG.info("run: failed to collect lldpRemTable for {}", (Object)hostAddress);
        }
        if (this.m_collectIpNetToMedia && !this.hasIpNetToMediaTable()) {
            LOG.info("run: failed to collect ipNetToMediaTable for {}", (Object)hostAddress);
        }
        if (this.m_collectIpRoute && this.m_ipRoute != null && !this.hasRouteTable()) {
            LOG.info("run: failed to collect ipRouteTable for {}", (Object)hostAddress);
        }
        if (this.m_collectCdp && !this.hasCdpGlobalGroup()) {
            LOG.info("run: failed to collect cdpGlobalGroup for {}", (Object)hostAddress);
        }
        if (this.m_collectCdp && !this.hasCdpInterfaceTable()) {
            LOG.info("run: failed to collect cdpInterfaceTable for []", (Object)hostAddress);
        }
        if (this.m_collectCdp && !this.hasCdpCacheTable()) {
            LOG.info("run: failed to collect cdpCacheTable for []", (Object)hostAddress);
        }
        if (this.m_collectVlan && this.m_vlanTable != null && !this.hasVlanTable()) {
            LOG.info("run: failed to collect VLAN for {}", (Object)hostAddress);
        }
        if (this.m_collectWifi && this.m_mtxrWlRtabTable != null && !this.hasMtxrWlRtabTable()) {
            LOG.info("run: failed to collect Wifi for {}", (Object)hostAddress);
        }
        if (this.hasVlanTable()) {
            VlanTableBasic basicvlans = (VlanTableBasic)this.m_vlanTable;
            LOG.debug("run: start snmp collection for {} VLAN entries", (Object)basicvlans.size());
            for (OnmsVlan vlan : basicvlans.getVlansForSnmpCollection()) {
                String community = this.m_agentConfig.getReadCommunity();
                Integer vlanindex = vlan.getVlanId();
                LOG.debug("run: peer community: {} with VLAN {}", (Object)community, (Object)vlanindex);
                if (vlanindex != 1) {
                    this.m_agentConfig.setReadCommunity(community + "@" + vlanindex);
                }
                this.runAndSaveSnmpVlanCollection(vlan);
                this.m_agentConfig.setReadCommunity(community);
            }
        } else {
            this.runAndSaveSnmpVlanCollection(new OnmsVlan(1, "default", VlanTable.DEFAULT_VLAN_STATUS));
        }
        LOG.debug("run: saving collection into database for {}", (Object)InetAddressUtils.str((InetAddress)this.m_agentConfig.getEffectiveAddress()));
        this.m_linkd.updateNodeSnmpCollection(this);
        this.m_ipNetToMedia = null;
        this.m_ipRoute = null;
        this.m_cdpGlobalGroup = null;
        this.m_cdpCache = null;
        this.m_cdpInterface = null;
        this.m_vlanTable = null;
        this.m_lldpLocalGroup = null;
        this.m_lldpLocTable = null;
        this.m_lldpRemTable = null;
        this.m_ospfGeneralGroup = null;
        this.m_ospfNbrTable = null;
        this.m_isisSystemObjectGroup = null;
        this.m_isisCircTable = null;
        this.m_isisISAdjTable = null;
        this.m_mtxrWlRtabTable = null;
        this.m_snmpVlanCollection.clear();
    }

    private SnmpTable<SnmpStore> createClass(String className, InetAddress address) {
        SnmpTable vlanTable = null;
        Class<?> getter = null;
        try {
            getter = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("run: {} class not found", (Object)className, (Object)e);
        }
        Class[] classes = new Class[]{InetAddress.class};
        Constructor<?> constr = null;
        try {
            constr = getter.getConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("run: {} class has no such method", (Object)className, (Object)e);
        }
        catch (SecurityException s) {
            LOG.warn("run: {} class security violation", (Object)className, (Object)s);
        }
        Object[] argum = new Object[]{address};
        try {
            vlanTable = (SnmpTable)constr.newInstance(argum);
        }
        catch (Throwable e) {
            LOG.warn("run: unable to instantiate class {}", (Object)className, (Object)e);
        }
        return vlanTable;
    }

    private void runAndSaveSnmpVlanCollection(OnmsVlan vlan) {
        LOG.info("runAndSaveSnmpVlanCollection: address {} package {}: collectStp: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectStp});
        LOG.info("runAndSaveSnmpVlanCollection: address {} package {}: collectBridge: {}", new Object[]{InetAddressUtils.str((InetAddress)this.m_address), this.getPackageName(), this.m_collectBridge});
        SnmpVlanCollection snmpvlancollection = new SnmpVlanCollection(this.m_agentConfig, this.m_collectStp, this.m_collectBridge);
        snmpvlancollection.setPackageName(this.getPackageName());
        snmpvlancollection.run();
        if (snmpvlancollection.failed()) {
            LOG.debug("runAndSaveSnmpVlanCollection: no bridge info found for {}", (Object)this.m_agentConfig);
        } else {
            LOG.debug("runAndSaveSnmpVlanCollection: adding bridge info to snmpcollection, VLAN = {}, SnmpVlanCollection = {}", (Object)vlan, (Object)snmpvlancollection);
            this.m_snmpVlanCollection.put(vlan, snmpvlancollection);
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    public long getPollInterval() {
        return this.poll_interval;
    }

    public void setPollInterval(long interval) {
        this.poll_interval = interval;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.schedule(this.poll_interval, this);
        } else {
            this.m_scheduler.schedule(this.initial_sleep_time, this);
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.setAgentConfig(this.m_linkd.getSnmpAgentConfig(this.m_address));
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.initial_sleep_time);
        }
    }

    public String getIpRouteClass() {
        return this.m_ipRouteClass;
    }

    public void setIpRouteClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_ipRouteClass = className;
        this.m_collectIpRoute = true;
    }

    public String getVlanClass() {
        return this.m_vlanClass;
    }

    public void setVlanClass(String className) {
        if (className == null || className.equals("")) {
            return;
        }
        this.m_vlanClass = className;
        this.m_collectVlan = true;
    }

    public InetAddress getTarget() {
        return this.m_address;
    }

    public boolean collectVlanTable() {
        return this.m_collectVlan;
    }

    public String getReadCommunity() {
        return this.m_agentConfig.getReadCommunity();
    }

    public SnmpAgentConfig getPeer() {
        return this.m_agentConfig;
    }

    public int getPort() {
        return this.m_agentConfig.getPort();
    }

    public boolean equals(Object run) {
        if (run instanceof SnmpCollection) {
            SnmpCollection c = (SnmpCollection)run;
            if (this.getPackageName().equals(c.getPackageName()) && c.getTarget().equals(this.m_address)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable SnmpCollection ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName() + " initial=" + this.getInitialSleepTime() + " interval=" + this.getPollInterval() + " collectBridge=" + this.getCollectBridge() + " collectStpNode=" + this.getCollectStp() + " collectCdp=" + this.getCollectCdp() + " collectIpnetToMedia=" + this.getCollectIpNetToMedia() + " collectIpRoute=" + this.getCollectIpRoute() + " collectLldp=" + this.getCollectLldp() + " collectOspf=" + this.getCollectOspf() + " collectIsis=" + this.getCollectIsIs() + " collectWifi=" + this.getCollectWifi();
    }

    public boolean getCollectLldp() {
        return this.m_collectLldp;
    }

    public void collectLldp(boolean collectLldpTable) {
        this.m_collectLldp = collectLldpTable;
    }

    public boolean getCollectBridge() {
        return this.m_collectBridge;
    }

    public void collectIpNetToMedia(boolean collectIpNetToMedia) {
        this.m_collectIpNetToMedia = collectIpNetToMedia;
    }

    public boolean getCollectIpNetToMedia() {
        return this.m_collectIpNetToMedia;
    }

    public void collectBridge(boolean bridgeForwardingTable) {
        this.m_collectBridge = bridgeForwardingTable;
    }

    public boolean getCollectCdp() {
        return this.m_collectCdp;
    }

    public void collectCdp(boolean cdpTable) {
        this.m_collectCdp = cdpTable;
    }

    public boolean getCollectIpRoute() {
        return this.m_collectIpRoute;
    }

    public void collectIpRoute(boolean ipRouteTable) {
        this.m_collectIpRoute = ipRouteTable;
    }

    public boolean getCollectStp() {
        return this.m_collectStp;
    }

    public void collectStp(boolean stpNode) {
        this.m_collectStp = stpNode;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void collectOspf(boolean collectOspfTable) {
        this.m_collectOspf = collectOspfTable;
    }

    public boolean getCollectOspf() {
        return this.m_collectOspf;
    }

    public void collectIsIs(boolean collectIsIs) {
        this.m_collectIsIs = collectIsIs;
    }

    public boolean getCollectIsIs() {
        return this.m_collectIsIs;
    }

    public void collectWifi(boolean collectWifi) {
        this.m_collectWifi = collectWifi;
    }

    public boolean getCollectWifi() {
        return this.m_collectWifi;
    }

    private class TrackerBuilder {
        private final CollectionTracker[] OF_TRACKERS = new CollectionTracker[0];
        private String m_msg = null;
        private List<CollectionTracker> m_trackerList = new ArrayList<CollectionTracker>();

        private TrackerBuilder() {
        }

        public void add(String label, CollectionTracker ... trackers) {
            this.m_msg = this.m_msg == null ? label : this.m_msg + "/" + label;
            this.m_trackerList.addAll(Arrays.asList(trackers));
        }

        public String getMessage() {
            return this.m_msg;
        }

        public CollectionTracker[] getTrackers() {
            return this.m_trackerList.toArray(this.OF_TRACKERS);
        }

        public boolean isEmpty() {
            return this.m_trackerList.isEmpty();
        }
    }
}

