/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.IsisISAdjInterface;
import org.opennms.netmgt.linkd.LinkableSnmpNode;
import org.opennms.netmgt.linkd.LldpRemInterface;
import org.opennms.netmgt.linkd.OspfNbrInterface;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.springframework.util.Assert;

public class LinkableNode {
    private final LinkableSnmpNode m_snmpnode;
    private final String m_packageName;
    private String m_cdpDeviceId;
    private String m_lldpSysname;
    private String m_lldpChassisId;
    private Integer m_lldpChassisIdSubtype;
    private InetAddress m_ospfRouterId;
    private String m_isisSysId;
    private List<CdpInterface> m_cdpinterfaces = new ArrayList<CdpInterface>();
    private List<LldpRemInterface> m_lldpreminterfaces = new ArrayList<LldpRemInterface>();
    private boolean m_hascdpinterfaces = false;
    private List<RouterInterface> m_routeinterfaces = new ArrayList<RouterInterface>();
    private List<OspfNbrInterface> m_ospfinterfaces = new ArrayList<OspfNbrInterface>();
    private List<IsisISAdjInterface> m_isisinterfaces = new ArrayList<IsisISAdjInterface>();
    private boolean m_hasrouteinterfaces = false;
    private boolean m_isBridgeNode = false;
    private List<Integer> m_backBoneBridgePorts = new ArrayList<Integer>();
    private List<String> m_bridgeIdentifiers = new ArrayList<String>();
    private Map<Integer, List<OnmsStpInterface>> m_bridgeStpInterfaces = new HashMap<Integer, List<OnmsStpInterface>>();
    private Map<Integer, String> m_vlanBridgeIdentifiers = new HashMap<Integer, String>();
    private Map<Integer, Set<String>> m_portMacs = new HashMap<Integer, Set<String>>();
    private Map<String, Integer> m_macsVlan = new HashMap<String, Integer>();
    private Map<Integer, String> m_vlanStpRoot = new HashMap<Integer, String>();
    private Map<Integer, Integer> m_bridgePortIfindex = new HashMap<Integer, Integer>();
    private Map<Integer, Set<String>> m_wifiIfIndexMac = new HashMap<Integer, Set<String>>();

    public String getIsisSysId() {
        return this.m_isisSysId;
    }

    public void setIsisSysId(String isisSysId) {
        this.m_isisSysId = isisSysId;
    }

    public String getCdpDeviceId() {
        return this.m_cdpDeviceId;
    }

    public void setCdpDeviceId(String cdpDeviceId) {
        this.m_cdpDeviceId = cdpDeviceId;
    }

    public InetAddress getOspfRouterId() {
        return this.m_ospfRouterId;
    }

    public void setOspfRouterId(InetAddress ospfRouterId) {
        this.m_ospfRouterId = ospfRouterId;
    }

    public void setLldpSysname(String lldpSysname) {
        this.m_lldpSysname = lldpSysname;
    }

    public void setLldpChassisId(String lldpChassisId) {
        this.m_lldpChassisId = lldpChassisId;
    }

    public void setLldpChassisIdSubtype(Integer lldpChassisIdSubtype) {
        this.m_lldpChassisIdSubtype = lldpChassisIdSubtype;
    }

    public String getLldpSysname() {
        return this.m_lldpSysname;
    }

    public String getLldpChassisId() {
        return this.m_lldpChassisId;
    }

    public Integer getLldpChassisIdSubtype() {
        return this.m_lldpChassisIdSubtype;
    }

    public LinkableNode(LinkableSnmpNode snmpnode, String packageName) {
        this.m_snmpnode = snmpnode;
        this.m_packageName = packageName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public LinkableSnmpNode getLinkableSnmpNode() {
        return this.m_snmpnode;
    }

    public List<LldpRemInterface> getLldpRemInterfaces() {
        return this.m_lldpreminterfaces;
    }

    public void setLldpRemInterfaces(List<LldpRemInterface> lldpreminterfaces) {
        this.m_lldpreminterfaces = lldpreminterfaces;
    }

    public List<OspfNbrInterface> getOspfinterfaces() {
        return this.m_ospfinterfaces;
    }

    public void setOspfinterfaces(List<OspfNbrInterface> ospfinterfaces) {
        this.m_ospfinterfaces = ospfinterfaces;
    }

    public List<IsisISAdjInterface> getIsisInterfaces() {
        return this.m_isisinterfaces;
    }

    public void setIsisInterfaces(List<IsisISAdjInterface> isisinterfaces) {
        this.m_isisinterfaces = isisinterfaces;
    }

    public List<CdpInterface> getCdpInterfaces() {
        return this.m_cdpinterfaces;
    }

    public void setCdpInterfaces(List<CdpInterface> cdpinterfaces) {
        if (cdpinterfaces == null || cdpinterfaces.isEmpty()) {
            return;
        }
        this.m_hascdpinterfaces = true;
        this.m_cdpinterfaces = cdpinterfaces;
    }

    public boolean hasCdpInterfaces() {
        return this.m_hascdpinterfaces;
    }

    public List<RouterInterface> getRouteInterfaces() {
        return this.m_routeinterfaces;
    }

    public void setRouteInterfaces(List<RouterInterface> routeinterfaces) {
        if (routeinterfaces == null || routeinterfaces.isEmpty()) {
            return;
        }
        this.m_hasrouteinterfaces = true;
        this.m_routeinterfaces = routeinterfaces;
    }

    public boolean hasRouteInterfaces() {
        return this.m_hasrouteinterfaces;
    }

    public boolean isBridgeNode() {
        return this.m_isBridgeNode;
    }

    public List<Integer> getBackBoneBridgePorts() {
        return this.m_backBoneBridgePorts;
    }

    public void setBackBoneBridgePorts(List<Integer> backBoneBridgePorts) {
        this.m_backBoneBridgePorts = backBoneBridgePorts;
    }

    public boolean isBackBoneBridgePort(int bridgeport) {
        return this.m_backBoneBridgePorts.contains(bridgeport);
    }

    public void addBackBoneBridgePorts(int bridgeport) {
        if (this.m_backBoneBridgePorts.contains(bridgeport)) {
            return;
        }
        this.m_backBoneBridgePorts.add(bridgeport);
    }

    public List<String> getBridgeIdentifiers() {
        return this.m_bridgeIdentifiers;
    }

    public void setBridgeIdentifiers(List<String> bridgeIdentifiers) {
        if (bridgeIdentifiers == null || bridgeIdentifiers.isEmpty()) {
            return;
        }
        this.m_bridgeIdentifiers = bridgeIdentifiers;
        this.m_isBridgeNode = true;
    }

    public void addBridgeIdentifier(String bridge, Integer vlan) {
        this.m_vlanBridgeIdentifiers.put(vlan, bridge);
        this.addBridgeIdentifier(bridge);
    }

    public boolean isBridgeIdentifier(String bridge) {
        return this.m_bridgeIdentifiers.contains(bridge);
    }

    public void addBridgeIdentifier(String bridge) {
        if (this.m_bridgeIdentifiers.contains(bridge)) {
            return;
        }
        this.m_bridgeIdentifiers.add(bridge);
        this.m_isBridgeNode = true;
    }

    public String getBridgeIdentifier(Integer vlan) {
        return this.m_vlanBridgeIdentifiers.get(vlan);
    }

    public void addWifiMacAddress(Integer ifindex, String macAddress) {
        Set<String> macs = new HashSet<String>();
        if (this.m_wifiIfIndexMac.containsKey(ifindex)) {
            macs = this.m_wifiIfIndexMac.get(ifindex);
        }
        macs.add(macAddress);
        this.m_wifiIfIndexMac.put(ifindex, macs);
    }

    public Map<Integer, Set<String>> getWifiMacIfIndexMap() {
        return this.m_wifiIfIndexMac;
    }

    public void addMacAddress(int bridgeport, String macAddress, Integer vlan) {
        Set<String> macs = new HashSet<String>();
        if (this.m_portMacs.containsKey(bridgeport)) {
            macs = this.m_portMacs.get(bridgeport);
        }
        macs.add(macAddress);
        this.m_portMacs.put(bridgeport, macs);
        this.m_macsVlan.put(macAddress, vlan);
    }

    public boolean hasMacAddress(String macAddress) {
        for (Set<String> macs : this.m_portMacs.values()) {
            if (!macs.contains(macAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMacAddresses() {
        return !this.m_portMacs.isEmpty();
    }

    public Integer getVlan(String macAddress) {
        return this.m_macsVlan.get(macAddress);
    }

    public Set<String> getMacAddressesOnBridgePort(int bridgeport) {
        return this.m_portMacs.get(bridgeport);
    }

    public boolean hasMacAddressesOnBridgePort(int bridgeport) {
        return this.m_portMacs.containsKey(bridgeport) && this.m_portMacs.get(bridgeport) != null;
    }

    public List<Integer> getBridgePortsFromMac(String macAddress) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Integer intePort : this.m_portMacs.keySet()) {
            if (!this.m_portMacs.get(intePort).contains(macAddress)) continue;
            ports.add(intePort);
        }
        return ports;
    }

    public int getIfindex(int bridgeport) {
        if (this.m_bridgePortIfindex.containsKey(bridgeport)) {
            return this.m_bridgePortIfindex.get(bridgeport);
        }
        return -1;
    }

    public int getBridgePort(int ifindex) {
        for (Integer curBridgePort : this.m_bridgePortIfindex.keySet()) {
            Integer curIfIndex = this.m_bridgePortIfindex.get(curBridgePort);
            if (curIfIndex != ifindex) continue;
            return curBridgePort;
        }
        return -1;
    }

    void setIfIndexBridgePort(Integer ifindex, Integer bridgeport) {
        Assert.notNull((Object)ifindex);
        Assert.notNull((Object)bridgeport);
        this.m_bridgePortIfindex.put(bridgeport, ifindex);
    }

    public Map<Integer, Set<String>> getPortMacs() {
        return this.m_portMacs;
    }

    public void setPortMacs(Map<Integer, Set<String>> portMacs) {
        this.m_portMacs = portMacs;
    }

    public void setVlanStpRoot(Integer vlan, String stproot) {
        if (stproot != null) {
            this.m_vlanStpRoot.put(vlan, stproot);
        }
    }

    public boolean hasStpRoot(Integer vlan) {
        return this.m_vlanStpRoot.containsKey(vlan);
    }

    public String getStpRoot(Integer vlan) {
        if (this.m_vlanStpRoot.containsKey(vlan)) {
            return this.m_vlanStpRoot.get(vlan);
        }
        return null;
    }

    public Map<Integer, List<OnmsStpInterface>> getStpInterfaces() {
        return this.m_bridgeStpInterfaces;
    }

    public void setStpInterfaces(Map<Integer, List<OnmsStpInterface>> stpInterfaces) {
        this.m_bridgeStpInterfaces = stpInterfaces;
    }

    public void addStpInterface(OnmsStpInterface stpIface) {
        Integer vlanindex = stpIface.getVlan() == null ? 0 : stpIface.getVlan();
        List<OnmsStpInterface> stpifs = new ArrayList<OnmsStpInterface>();
        if (this.m_bridgeStpInterfaces.containsKey(vlanindex)) {
            stpifs = this.m_bridgeStpInterfaces.get(vlanindex);
        }
        stpifs.add(stpIface);
        this.m_bridgeStpInterfaces.put(vlanindex, stpifs);
    }

    public int getNodeId() {
        return this.getLinkableSnmpNode().getNodeId();
    }

    public InetAddress getSnmpPrimaryIpAddr() {
        return this.getLinkableSnmpNode().getSnmpPrimaryIpAddr();
    }

    public String getSysoid() {
        return this.getLinkableSnmpNode().getSysoid();
    }
}

