/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.IsisISAdjInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.LldpRemInterface;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.OspfNbrInterface;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryLink
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryLink.class);
    private String packageName;
    private List<NodeToNodeLink> m_links = new ArrayList<NodeToNodeLink>();
    private Map<Integer, LinkableNode> m_bridgeNodes = new HashMap<Integer, LinkableNode>();
    private List<LinkableNode> m_routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_lldpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_ospfNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_isisNodes = new ArrayList<LinkableNode>();
    private Map<String, LinkableNode> m_cdpNodes = new HashMap<String, LinkableNode>();
    private List<LinkableNode> m_wifiNodes = new ArrayList<LinkableNode>();
    private List<String> m_macsParsed = new ArrayList<String>();
    private List<String> macsExcluded = new ArrayList<String>();
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean discoveryUsingLldp = true;
    private boolean discoveryUsingOspf = true;
    private boolean discoveryUsingIsis = true;
    private boolean discoveryUsingWifi = true;
    private boolean suspendCollection = false;
    private boolean runned = false;
    private Scheduler m_scheduler;
    private long m_interval = 1800000L;
    private long discovery_delay = 300000L;
    private long m_initial_sleep_time = 600000L;
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    private void sendSuspendedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoverySuspended", "Linkd"));
    }

    private void sendStartedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoveryStarted", "Linkd"));
    }

    private void sendCompletedEvent() {
        this.sendEvent(new EventBuilder("uei.opennms.org/internal/linkd/linkDiscoveryCompleted", "Linkd"));
    }

    private void sendEvent(EventBuilder builder) {
        builder.addParam("runnable", "discoveryLink/" + this.getPackageName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }

    @Override
    public void run() {
        this.runned = true;
        if (this.suspendCollection) {
            this.sendSuspendedEvent();
            LOG.warn("run: linkd collections are suspended!");
        } else {
            this.sendStartedEvent();
            this.discoverLinks();
            this.sendCompletedEvent();
        }
    }

    private void discoverLinks() {
        Collection<LinkableNode> linkableNodes = this.m_linkd.getLinkableNodesOnPackage(this.getPackageName());
        LOG.info("run: Found {} LinkableNodes  on package \"{}\"", (Object)linkableNodes.size(), (Object)this.getPackageName());
        LOG.info("run: discoveryUsingBridge={} on package \"{}\"", (Object)this.discoveryUsingBridge, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingCdp={} on package \"{}\"", (Object)this.discoveryUsingCdp, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingRoutes={} on package \"{}\"", (Object)this.discoveryUsingRoutes, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingLldp={} on package \"{}\"", (Object)this.discoveryUsingLldp, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingOspf={} on package \"{}\"", (Object)this.discoveryUsingOspf, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingIsis={} on package \"{}\"", (Object)this.discoveryUsingIsis, (Object)this.getPackageName());
        LOG.info("run: discoveryUsingWifi={} on package \"{}\"", (Object)this.discoveryUsingWifi, (Object)this.getPackageName());
        for (LinkableNode linkableNode : linkableNodes) {
            LOG.debug("run: Iterating on LinkableNode's found node with nodeid/sysoid/ipaddress {}/{}/{}", new Object[]{linkableNode.getNodeId(), linkableNode.getSysoid(), InetAddressUtils.str((InetAddress)linkableNode.getSnmpPrimaryIpAddr())});
            if (this.discoveryUsingOspf && linkableNode.getOspfRouterId() != null && linkableNode.getOspfinterfaces() != null) {
                LOG.debug("run: adding to ospf node list: node with nodeid/ospfrouterid/#ospfinterface {}/{}/#{}", new Object[]{linkableNode.getNodeId(), InetAddressUtils.str((InetAddress)linkableNode.getOspfRouterId()), linkableNode.getOspfinterfaces().size()});
                this.m_ospfNodes.add(linkableNode);
            }
            if (this.discoveryUsingIsis && linkableNode.getIsisSysId() != null) {
                LOG.debug("run: adding to isis node list: node with nodeid/isisSysId/#isisinterface {}/{}/#{}", new Object[]{linkableNode.getNodeId(), linkableNode.getIsisSysId(), linkableNode.getIsisInterfaces().size()});
                this.m_isisNodes.add(linkableNode);
            }
            if (this.discoveryUsingLldp && linkableNode.getLldpChassisId() != null && linkableNode.getLldpChassisIdSubtype() != null) {
                LOG.debug("run: adding to lldp node list: node with nodeid/sysname/chassisid {}/{}/{}", new Object[]{linkableNode.getNodeId(), linkableNode.getLldpSysname(), linkableNode.getLldpChassisId()});
                this.m_lldpNodes.add(linkableNode);
            }
            if (this.discoveryUsingBridge && linkableNode.isBridgeNode()) {
                LOG.debug("run: adding to bridge node list: node with nodeid/bridgeidentifier {}/{}", (Object)linkableNode.getNodeId(), (Object)linkableNode.getBridgeIdentifiers().get(0));
                this.m_bridgeNodes.put(linkableNode.getNodeId(), linkableNode);
            }
            if (this.discoveryUsingCdp && linkableNode.hasCdpInterfaces()) {
                LOG.debug("run: adding to CDP node list: node with nodeid/#cdpinterfaces {}/#{}", (Object)linkableNode.getNodeId(), (Object)linkableNode.getCdpInterfaces().size());
                this.m_cdpNodes.put(linkableNode.getCdpDeviceId(), linkableNode);
            }
            if (this.discoveryUsingRoutes && linkableNode.hasRouteInterfaces()) {
                LOG.debug("run: adding to router node list: node with nodeid/#iprouteinterface {}/#{}", (Object)linkableNode.getNodeId(), (Object)linkableNode.getRouteInterfaces().size());
                this.m_routerNodes.add(linkableNode);
            }
            if (!this.discoveryUsingWifi || linkableNode.getWifiMacIfIndexMap().isEmpty()) continue;
            LOG.debug("run: adding to wifi node list: node with nodeid/#wificonnection {}/#{}", (Object)linkableNode.getNodeId(), (Object)linkableNode.getWifiMacIfIndexMap().size());
            this.m_wifiNodes.add(linkableNode);
        }
        if (this.discoveryUsingBridge || this.discoveryUsingWifi) {
            this.populateMacToAtInterface();
        }
        this.getLinksFromRouteTable();
        this.getLinksFromOspf();
        this.getLinksFromIsis();
        this.getLinksFromWifi();
        this.getLinksFromLldp();
        this.getBackBoneLinksFromBridges();
        this.getLinksFromBridges();
        this.getLinksFromCdp();
        this.m_bridgeNodes.clear();
        this.m_routerNodes.clear();
        this.m_cdpNodes.clear();
        this.m_macsParsed.clear();
        this.macsExcluded.clear();
        this.m_lldpNodes.clear();
        this.m_ospfNodes.clear();
        this.m_isisNodes.clear();
        this.m_wifiNodes.clear();
        this.getLinkd().clearPackageSavedData(this.getPackageName());
        this.m_linkd.updateDiscoveryLinkCollection(this);
        this.m_links.clear();
        this.runned = true;
    }

    protected void populateMacToAtInterface() {
        LOG.debug("populateMacToAtInterface: using atNodes to populate macToAtinterface");
        Set<String> macAddresses = this.getLinkd().getMacAddressesOnPackage(this.getPackageName());
        if (macAddresses == null || macAddresses.isEmpty()) {
            return;
        }
        for (String macAddress : macAddresses) {
            List<AtInterface> atInterfaces = this.getLinkd().getAtInterfaces(this.getPackageName(), macAddress);
            LOG.debug("populateMacToAtInterface: MAC {} now has atinterface reference: {}", (Object)macAddress, (Object)atInterfaces.size());
            for (AtInterface at : atInterfaces) {
                int nodeid = at.getNodeid();
                LOG.debug("populateMacToAtInterface: Parsing AtInterface nodeid/ipaddr/macaddr: {}/{}/{}", new Object[]{nodeid, at.getIpAddress(), macAddress});
                if (macAddress.indexOf("00000c07ac") != 0 && macAddress.indexOf("00000c9ff") != 0) continue;
                LOG.debug("populateMacToAtInterface: AtInterface {} is Cisco HSRP address! Not adding to discoverable atinterface.", (Object)macAddress);
                this.macsExcluded.add(macAddress);
            }
        }
        LOG.debug("populateMacToAtInterface: end populateMacToAtinterface");
    }

    private void getLinksFromWifi() {
        for (LinkableNode curNode : this.m_wifiNodes) {
            int curNodeId = curNode.getNodeId();
            LOG.info("getLinksFromWifi: parsing wifi node with ID {} and {} wifi interfaces ", (Object)curNodeId, (Object)curNode.getWifiMacIfIndexMap().size());
            for (Map.Entry<Integer, Set<String>> wifi : curNode.getWifiMacIfIndexMap().entrySet()) {
                LOG.debug("getLinksFromWifi: parsing wifi node with ID {} wifi interface {} macs {} ", new Object[]{curNodeId, wifi.getKey(), wifi.getValue()});
                this.addLinks(wifi.getValue(), curNodeId, wifi.getKey(), DataLinkInterface.DiscoveryProtocol.wifi);
            }
        }
    }

    private void getLinksFromBridges() {
        if (this.m_bridgeNodes.size() > 0) {
            LOG.info("getLinksFromBridges: trying to find links using MAC Address Forwarding Table");
        }
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            int curNodeId = curNode.getNodeId();
            LOG.info("getLinksFromBridges: parsing bridge node with ID {}", (Object)curNodeId);
            for (Integer curBridgePort : curNode.getPortMacs().keySet()) {
                Set<String> macs;
                List<LinkableNode> bridgesOnPort;
                LOG.debug("getLinksFromBridges: parsing bridge port {} with MAC address {}", (Object)curBridgePort, (Object)curNode.getMacAddressesOnBridgePort(curBridgePort).toString());
                if (curNode.isBackBoneBridgePort(curBridgePort)) {
                    LOG.debug("getLinksFromBridges: Port {} is a backbone bridge port. Skipping.", (Object)curBridgePort);
                    continue;
                }
                int curIfIndex = curNode.getIfindex(curBridgePort);
                if (curIfIndex == -1) {
                    LOG.warn("getLinksFromBridges: got invalid ifIndex on bridge port {}", (Object)curBridgePort);
                }
                if ((bridgesOnPort = this.getBridgesFromMacs(macs = curNode.getMacAddressesOnBridgePort(curBridgePort))).isEmpty()) {
                    LOG.debug("getLinksFromBridges: no bridges macs found on port {}. Saving MACs.", (Object)curBridgePort);
                    this.addLinks(macs, curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
                    continue;
                }
                LOG.debug("getLinksFromBridges: bridges macs found on port {}. Searching nearest.", (Object)curBridgePort);
                for (LinkableNode endNode : bridgesOnPort) {
                    int endNodeid = endNode.getNodeId();
                    if (curNodeId == endNodeid) {
                        LOG.debug("getLinksFromBridges: curnode and target node are the same. Skipping.");
                        continue;
                    }
                    int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                    if (endBridgePort == -1) {
                        LOG.warn("getLinksFromBridges: no valid port found on bridge nodeid {} for node bridge identifiers nodeid {}. Skipping.", (Object)endNodeid, (Object)curNodeId);
                        continue;
                    }
                    boolean isTargetNode = this.isNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort);
                    if (!isTargetNode) continue;
                    int endIfindex = endNode.getIfindex(endBridgePort);
                    if (endIfindex == -1) {
                        LOG.warn("getLinksFromBridges: got invalid ifindex on designated bridge port {}", (Object)endBridgePort);
                        continue;
                    }
                    LOG.debug("getLinksFromBridges: backbone port found for node {}. Adding backbone bridge port {}", (Object)curNodeId, (Object)curBridgePort);
                    curNode.addBackBoneBridgePorts(curBridgePort);
                    this.m_bridgeNodes.put(curNodeId, curNode);
                    LOG.debug("getLinksFromBridges: backbone port found for node {}. Adding to backbone bridge port {}", (Object)endNodeid, (Object)endBridgePort);
                    endNode.addBackBoneBridgePorts(endBridgePort);
                    this.m_bridgeNodes.put(endNodeid, endNode);
                    this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
                    NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
                    lk.setNodeparentid(endNodeid);
                    lk.setParentifindex(endIfindex);
                    LOG.info("getLinksFromBridges: saving bridge link: {}", (Object)lk.toString());
                    this.addNodetoNodeLink(lk);
                }
            }
            LOG.info("getLinksFromBridges: done parsing bridge node with ID {}", (Object)curNodeId);
        }
        if (this.m_bridgeNodes.size() > 0) {
            LOG.info("getLinksFromBridges: done finding links using MAC Address Forwarding Table");
        }
    }

    private void getBackBoneLinksFromBridges() {
        if (this.m_bridgeNodes != null && this.m_bridgeNodes.size() > 0) {
            LOG.info("getBackBoneLinksFromBridges: trying to find backbone ethernet links among bridge nodes using Spanning Tree Protocol");
        }
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            int curNodeId = curNode.getNodeId();
            InetAddress cupIpAddr = curNode.getSnmpPrimaryIpAddr();
            LOG.info("getBackBoneLinksFromBridges: parsing bridge nodeid {} IP address {} with {} VLANs", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
            for (Map.Entry<Integer, List<OnmsStpInterface>> me : curNode.getStpInterfaces().entrySet()) {
                Integer vlan = me.getKey();
                String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                LOG.debug("getBackBoneLinksFromBridges: found bridge identifier {}", (Object)curBaseBridgeAddress);
                String designatedRoot = null;
                if (!curNode.hasStpRoot(vlan)) {
                    LOG.debug("getBackBoneLinksFromBridges: stp designated root bridge identifier not found. Skipping {}", (Object)curBaseBridgeAddress);
                    continue;
                }
                designatedRoot = curNode.getStpRoot(vlan);
                if (designatedRoot == null || designatedRoot.equals("0000000000000000")) {
                    LOG.warn("getBackBoneLinksFromBridges: stp designated root is invalid, skipping: {}", (Object)designatedRoot);
                    continue;
                }
                if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                    LOG.debug("getBackBoneLinksFromBridges: stp designated root is the bridge itself. Skipping.");
                    continue;
                }
                LOG.debug("getBackBoneLinksFromBridges: stp designated root is another bridge. {} Parsing stp interfaces", (Object)designatedRoot);
                for (OnmsStpInterface stpIface : me.getValue()) {
                    int stpbridgeport = stpIface.getBridgePort();
                    if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                        LOG.debug("getBackBoneLinksFromBridges: bridge port {} already found. Skipping.", (Object)stpbridgeport);
                        continue;
                    }
                    String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                    String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                    LOG.debug("getBackBoneLinksFromBridges: parsing bridge port {} with stp designated bridge {} and stp designated port {}", new Object[]{stpbridgeport, stpPortDesignatedBridge, stpPortDesignatedPort});
                    if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                        LOG.warn("getBackBoneLinksFromBridges: designated bridge is invalid, skipping: {}", (Object)stpPortDesignatedBridge);
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                        LOG.debug("getBackBoneLinksFromBridges: designated bridge for port {} is bridge itself, skipping", (Object)stpbridgeport);
                        continue;
                    }
                    if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                        LOG.warn("getBackBoneLinksFromBridges: designated port is invalid: {}. skipping", (Object)stpPortDesignatedPort);
                        continue;
                    }
                    int designatedbridgeport = 0x1FFF & Integer.parseInt(stpPortDesignatedPort, 16);
                    LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                    if (designatedNode == null) {
                        LOG.debug("getBackBoneLinksFromBridges: no nodeid found for stp bridge address {}. Nothing to save.", (Object)stpPortDesignatedBridge);
                        continue;
                    }
                    int designatednodeid = designatedNode.getNodeId();
                    LOG.debug("getBackBoneLinksFromBridges: found designated nodeid {}", (Object)designatednodeid);
                    if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) continue;
                    int curIfIndex = curNode.getIfindex(stpbridgeport);
                    if (curIfIndex == -1) {
                        LOG.warn("getBackBoneLinksFromBridges: got invalid ifindex on node: {}", (Object)curNode.toString());
                        continue;
                    }
                    int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                    if (designatedifindex == -1) {
                        LOG.warn("getBackBoneLinksFromBridges: got invalid ifindex on designated node: {}", (Object)designatedNode.toString());
                        continue;
                    }
                    LOG.debug("getBackBoneLinksFromBridges: backbone bridge port {} found for node {}", (Object)stpbridgeport, (Object)curNodeId);
                    curNode.addBackBoneBridgePorts(stpbridgeport);
                    this.m_bridgeNodes.put(curNodeId, curNode);
                    LOG.debug("getBackBoneLinksFromBridges: backbone bridge port {} found for node {}", (Object)designatedbridgeport, (Object)designatednodeid);
                    designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                    this.m_bridgeNodes.put(designatednodeid, designatedNode);
                    LOG.debug("getBackBoneLinksFromBridges: adding links on backbone found link");
                    this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
                    NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex, DataLinkInterface.DiscoveryProtocol.bridge);
                    lk.setNodeparentid(designatednodeid);
                    lk.setParentifindex(designatedifindex);
                    LOG.info("getBackBoneLinksFromBridges: saving stp bridge link: {}", (Object)lk.toString());
                    this.addNodetoNodeLink(lk);
                }
            }
            LOG.info("getBackBoneLinksFromBridges: done parsing bridge with nodeid {} and ip address {} with {} VLANs", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
        }
        if (this.m_bridgeNodes.size() > 0) {
            LOG.info("getBackBoneLinksFromBridges: done finding backbone ethernet links among bridge nodes using Spanning Tree Protocol");
        }
    }

    private void getLinksFromRouteTable() {
        if (this.m_routerNodes.size() > 0) {
            LOG.info("getLinksFromRouteTable: finding non-ethernet links on Router nodes");
        }
        for (LinkableNode curNode : this.m_routerNodes) {
            int curNodeId = curNode.getNodeId();
            InetAddress curIpAddr = curNode.getSnmpPrimaryIpAddr();
            LOG.info("getLinksFromRouteTable: parsing router node with ID {} IP address {} and {} router interfaces", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
            for (RouterInterface routeIface : curNode.getRouteInterfaces()) {
                LOG.debug("getLinksFromRouteTable: parsing RouterInterface: {}", (Object)routeIface.toString());
                NodeToNodeLink lk = new NodeToNodeLink(curNodeId, routeIface.getIfindex(), DataLinkInterface.DiscoveryProtocol.iproute);
                lk.setNodeparentid(routeIface.getNextHopNodeid());
                lk.setParentifindex(routeIface.getNextHopIfindex());
                LOG.info("getLinksFromRouteTable: saving route link: {}", (Object)lk.toString());
                this.addNodetoNodeLink(lk);
            }
            LOG.info("getLinksFromRouteTable: done parsing router node with ID {} IP address {} and {} router interfaces", new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
        }
        if (this.m_routerNodes.size() > 0) {
            LOG.info("getLinksFromRouteTable: done finding non-ethernet links on Router nodes");
        }
    }

    private void getLinksFromCdp() {
        LOG.info("getLinksFromCdp: adding links using Cisco Discovery Protocol");
        LOG.info("getLinksFromCdp: found # {} nodes using Cisco Discovery Protocol", (Object)this.m_cdpNodes.size());
        LOG.info("getLinksFromCdp: founding Cisco Discovery Protocol links between Cdp nodes");
        for (LinkableNode linknode1 : this.m_cdpNodes.values()) {
            LOG.info("getLinksFromCdp: parsing cdp device {} with cdpDeviceId {} using Cisco Discovery Protocol", (Object)linknode1.getNodeId(), (Object)linknode1.getCdpDeviceId());
            for (CdpInterface cdpiface1 : linknode1.getCdpInterfaces()) {
                if (cdpiface1 == null) {
                    LOG.warn("getLinksFromCdp: cdp interface null found on target device node {} for cdpTargetDeviceId {} ", (Object)linknode1.getNodeId());
                    continue;
                }
                LOG.info("getLinksFromCdp: parsing cdpInterface {} ", (Object)cdpiface1);
                if (cdpiface1.getCdpTargetDeviceId() != null) {
                    LinkableNode linknode2 = this.m_cdpNodes.get(cdpiface1.getCdpTargetDeviceId());
                    if (linknode2 == null) {
                        LOG.info("getLinksFromCdp: no cdpdevice found for cdpDeviceId {} ", (Object)cdpiface1.getCdpTargetDeviceId());
                        continue;
                    }
                    if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                    LOG.info("getLinksFromCdp: found node {} for cdpTargetDeviceId {} ", (Object)linknode2.getNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                    for (CdpInterface cdpiface2 : linknode2.getCdpInterfaces()) {
                        if (cdpiface2 == null) {
                            LOG.warn("getLinksFromCdp: cdp interface null found on target device node {} for cdpTargetDeviceId {} ", (Object)linknode2.getNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                            continue;
                        }
                        LOG.info("getLinksFromCdp: parsing target cdpInterface {} ", (Object)cdpiface2);
                        if (cdpiface2.getCdpTargetDeviceId() == null || !cdpiface2.getCdpTargetDeviceId().equals(linknode1.getCdpDeviceId()) || (cdpiface1.getCdpIfName() == null || !cdpiface1.getCdpIfName().equals(cdpiface2.getCdpTargetIfName())) && (cdpiface2.getCdpIfName() == null || !cdpiface2.getCdpIfName().equals(cdpiface1.getCdpTargetIfName()))) continue;
                        NodeToNodeLink cdpLink = new NodeToNodeLink(linknode2.getNodeId(), cdpiface2.getCdpIfIndex(), DataLinkInterface.DiscoveryProtocol.cdp);
                        cdpLink.setNodeparentid(linknode1.getNodeId());
                        cdpLink.setParentifindex(cdpiface1.getCdpIfIndex());
                        this.addNodetoNodeLink(cdpLink);
                    }
                    continue;
                }
                if (cdpiface1.getCdpTargetNodeId() == null) continue;
                LOG.info("getLinksFromCdp: cdpdevice found no snmp target node {} for cdpTargetDeviceId {} ", (Object)cdpiface1.getCdpTargetNodeId(), (Object)cdpiface1.getCdpTargetDeviceId());
                NodeToNodeLink link = new NodeToNodeLink(cdpiface1.getCdpTargetNodeId(), -1, DataLinkInterface.DiscoveryProtocol.cdp);
                link.setNodeparentid(linknode1.getNodeId());
                link.setParentifindex(cdpiface1.getCdpIfIndex());
                this.addNodetoNodeLink(link);
            }
        }
    }

    private void getLinksFromIsis() {
        LOG.info("getLinksFromIsis: adding links using ISO IS-IS Routing Protocol");
        int i = 0;
        for (LinkableNode linknode1 : this.m_isisNodes) {
            for (LinkableNode linknode2 : this.m_isisNodes) {
                if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                for (NodeToNodeLink isisLink : this.getIsisLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(isisLink);
                    ++i;
                }
            }
        }
        LOG.info("getLinksFromIsis: done IS-IS. Found links # {}.", (Object)i);
    }

    private List<NodeToNodeLink> getIsisLink(LinkableNode linknode1, LinkableNode linknode2) {
        LOG.info("getIsisLink: finding IS-IS links between node with id {} and node with id {}.", (Object)linknode1.getNodeId(), (Object)linknode2.getNodeId());
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (IsisISAdjInterface isis1 : linknode1.getIsisInterfaces()) {
            for (IsisISAdjInterface isis2 : linknode2.getIsisInterfaces()) {
                LOG.debug("getIsisLink: first IS-IS element: isisSysId {} isisISAdj {}.", (Object)linknode1.getIsisSysId(), (Object)isis1);
                LOG.debug("getIsisLink: second IS-IS element: isisSysId {} isisISAdj {}.", (Object)linknode2.getIsisSysId(), (Object)isis2);
                if (!isis1.getIsisISAdjNeighSysId().equals(linknode2.getIsisSysId()) || !isis2.getIsisISAdjNeighSysId().equals(linknode1.getIsisSysId()) || isis1.getIsisISAdjIndex().intValue() != isis2.getIsisISAdjIndex().intValue()) continue;
                NodeToNodeLink link = new NodeToNodeLink(linknode1.getNodeId(), isis1.getIsisLocalIfIndex(), DataLinkInterface.DiscoveryProtocol.isis);
                link.setNodeparentid(linknode2.getNodeId());
                link.setParentifindex(isis2.getIsisLocalIfIndex());
                links.add(link);
            }
        }
        return links;
    }

    private void getLinksFromOspf() {
        LOG.info("getLinksFromOspf: adding links using Open Short Path First Protocol");
        int i = 0;
        for (LinkableNode linknode1 : this.m_ospfNodes) {
            for (LinkableNode linknode2 : this.m_ospfNodes) {
                if (linknode1.getNodeId() >= linknode2.getNodeId()) continue;
                for (NodeToNodeLink ospfLink : this.getOspfLink(linknode1, linknode2)) {
                    this.addNodetoNodeLink(ospfLink);
                    ++i;
                }
            }
        }
        LOG.info("getLinksFromOspf: done OSPF. Found links # {}.", (Object)i);
    }

    private List<NodeToNodeLink> getOspfLink(LinkableNode linknode1, LinkableNode linknode2) {
        LOG.info("getLinksFromOspf: finding OSPF links between node with id {} and node with id {}.", (Object)linknode1.getNodeId(), (Object)linknode2.getNodeId());
        ArrayList<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
        for (OspfNbrInterface ospf : linknode1.getOspfinterfaces()) {
            for (OspfNbrInterface ospf2 : linknode2.getOspfinterfaces()) {
                if (!ospf.getOspfNbrRouterId().equals(linknode2.getOspfRouterId()) || ospf.getOspfNbrNodeId() != linknode2.getNodeId() || !ospf2.getOspfNbrRouterId().equals(linknode1.getOspfRouterId()) || ospf2.getOspfNbrNodeId() != linknode1.getNodeId() || !this.getSubnetAddress(ospf).equals(this.getSubnetAddress(ospf2))) continue;
                NodeToNodeLink link = new NodeToNodeLink(ospf.getOspfNbrNodeId(), ospf.getOspfNbrIfIndex(), DataLinkInterface.DiscoveryProtocol.ospf);
                link.setNodeparentid(ospf2.getOspfNbrNodeId());
                link.setParentifindex(ospf2.getOspfNbrIfIndex());
                links.add(link);
            }
        }
        return links;
    }

    protected InetAddress getSubnetAddress(OspfNbrInterface ospfinterface) {
        byte[] ip = ospfinterface.getOspfNbrIpAddr().getAddress();
        byte[] nm = ospfinterface.getOspfNbrNetMask().getAddress();
        try {
            return InetAddress.getByAddress(new byte[]{(byte)(ip[0] & nm[0]), (byte)(ip[1] & nm[1]), (byte)(ip[2] & nm[2]), (byte)(ip[3] & nm[3])});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void getLinksFromLldp() {
        LOG.info("getLinkdFromLldp: adding links using Layer Link Discovery Protocol");
        int i = 0;
        for (LinkableNode linknode1 : this.m_lldpNodes) {
            for (LldpRemInterface lldpremiface : linknode1.getLldpRemInterfaces()) {
                LOG.debug("run: found LLDP interface {}", (Object)lldpremiface.toString());
                NodeToNodeLink link = new NodeToNodeLink(lldpremiface.getLldpRemNodeid(), lldpremiface.getLldpRemIfIndex(), DataLinkInterface.DiscoveryProtocol.lldp);
                link.setNodeparentid(linknode1.getNodeId());
                link.setParentifindex(lldpremiface.getLldpLocIfIndex());
                this.addNodetoNodeLink(link);
                ++i;
            }
        }
        LOG.info("getLinkdFromLldp: done LLDP. Found links # {}.", (Object)i);
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.m_routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        LOG.debug("isNearestBridgeLink: bridge1/port1 {}/{} bridge2/port2 {}/{}", new Object[]{bridge1.getNodeId(), bp1, bridge2.getNodeId(), bp2});
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null || macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            LOG.debug("isNearestBridgeLink: no macs found on at least one bridge port, nearest bridges found. Return true.");
            return true;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            LOG.debug("isNearestBridgeLink: parsing mac address {} on bridge1", (Object)curMacOnBridge1);
            if (bridge2.isBridgeIdentifier(curMacOnBridge1)) {
                LOG.debug("isNearestBridgeLink: mac address {} is bridge identifier on bridge2. Continue", (Object)curMacOnBridge1);
                continue;
            }
            if (bridge1.isBridgeIdentifier(curMacOnBridge1)) {
                LOG.debug("isNearestBridgeLink: mac address {} is bridge identifier on bridge1. Continue", (Object)curMacOnBridge1);
                continue;
            }
            if (!macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            LOG.debug("isNearestBridgeLink: mac address {} is bridge identifier. Other bridge found. Return false", (Object)curMacOnBridge1);
            return false;
        }
        return true;
    }

    private Set<String> getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private List<LinkableNode> getBridgesFromMacs(Set<String> macs) {
        ArrayList<LinkableNode> bridges = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.add(curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            LOG.debug("getBridgePortOnEndBridge: parsing bridge identifier {}", (Object)curBridgeIdentifier);
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                for (Integer p : endBridge.getBridgePortsFromMac(curBridgeIdentifier)) {
                    port = p;
                    if (endBridge.isBackBoneBridgePort(port)) {
                        LOG.debug("getBridgePortOnEndBridge: found backbone bridge port {} .... Skipping.", (Object)port);
                        continue;
                    }
                    if (port == -1) {
                        LOG.debug("getBridgePortOnEndBridge: no port found on bridge nodeid {} for node bridge identifiers nodeid {} . .....Skipping.", (Object)endBridge.getNodeId(), (Object)startBridge.getNodeId());
                        continue;
                    }
                    LOG.debug("getBridgePortOnEndBridge: using MAC address table found bridge port {} on node {}", (Object)port, (Object)endBridge.getNodeId());
                    return port;
                }
                continue;
            }
            LOG.debug("getBridgePortOnEndBridge: bridge identifier not found on node {}", (Object)endBridge.getNodeId());
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.schedule(this.m_interval, this);
        } else {
            this.m_scheduler.schedule(this.discovery_delay + this.m_initial_sleep_time, this);
        }
    }

    public long getInitialSleepTime() {
        return this.m_initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.m_initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryDelay() {
        return this.discovery_delay;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public long getInterval() {
        return this.m_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_delay = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.m_links.toArray(new NodeToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("unschedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.runned) {
            this.m_scheduler.unschedule(this, this.m_interval);
        } else {
            this.m_scheduler.unschedule(this, this.m_initial_sleep_time + this.discovery_delay);
        }
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            LOG.warn("addNodetoNodeLink: node link is null.");
            return;
        }
        for (NodeToNodeLink curNnLink : this.m_links) {
            if (!curNnLink.equals(nnlink)) continue;
            LOG.info("addNodetoNodeLink: link {} exists, not adding", (Object)nnlink.toString());
            return;
        }
        if (nnlink.getNodeId() == nnlink.getNodeparentid()) {
            LOG.info("addNodetoNodeLink: link {} is on the same node, not adding", (Object)nnlink.toString());
            return;
        }
        LOG.debug("addNodetoNodeLink: adding link {}", (Object)nnlink.toString());
        this.m_links.add(nnlink);
    }

    private void addLinks(Set<String> macs, int nodeid, int ifindex, DataLinkInterface.DiscoveryProtocol proto) {
        if (macs == null || macs.isEmpty()) {
            LOG.debug("addLinks: MAC address list on link is empty.");
        } else {
            for (String curMacAddress : macs) {
                if (this.m_macsParsed.contains(curMacAddress)) {
                    LOG.warn("addLinks: MAC address {} just found on other bridge port! Skipping...", (Object)curMacAddress);
                    continue;
                }
                if (this.macsExcluded.contains(curMacAddress)) {
                    LOG.warn("addLinks: MAC address {} is excluded from discovery package! Skipping...", (Object)curMacAddress);
                    continue;
                }
                List<AtInterface> ats = this.m_linkd.getAtInterfaces(this.getPackageName(), curMacAddress);
                if (!ats.isEmpty()) {
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeid(), at.getIfIndex(), proto);
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                }
                this.m_macsParsed.add(curMacAddress);
            }
        }
    }

    public boolean equals(Object r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(((DiscoveryLink)r).getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable DiscoveryLink  package=" + this.getPackageName() + " sleep=" + this.getInitialSleepTime() + " discovery=" + this.getDiscoveryDelay() + " interval=" + this.getInterval() + " discoveryUsingBridge=" + this.discoveryUsingBridge() + " discoveryUsingCdp=" + this.discoveryUsingCdp() + " discoveryUsingRoutes=" + this.discoveryUsingRoutes() + " discoveryUsingLldp=" + this.discoveryUsingLldp() + " discoveryUsingOspf=" + this.discoveryUsingOspf() + " discoveryUsingIsis=" + this.discoveryUsingIsis() + " discoveryUsingWifi=" + this.discoveryUsingWifi();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingOspf() {
        return this.discoveryUsingOspf;
    }

    public void setDiscoveryUsingOspf(boolean discoveryUsingOspf) {
        this.discoveryUsingOspf = discoveryUsingOspf;
    }

    public boolean discoveryUsingIsis() {
        return this.discoveryUsingIsis;
    }

    public void setDiscoveryUsingIsIs(boolean discoveryUsingIsIs) {
        this.discoveryUsingIsis = discoveryUsingIsIs;
    }

    public boolean discoveryUsingLldp() {
        return this.discoveryUsingLldp;
    }

    public void setDiscoveryUsingLldp(boolean discoveryUsingLldp) {
        this.discoveryUsingLldp = discoveryUsingLldp;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingWifi() {
        return this.discoveryUsingWifi;
    }

    public void setDiscoveryUsingWifi(boolean discoveryUsingWifi) {
        this.discoveryUsingWifi = discoveryUsingWifi;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

