/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TcpServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpServer.class);
    static final int TCP_PORT = 5817;
    static final String DEFAULT_IP_ADDRESS = "127.0.0.1";
    private int m_tcpPort;
    private ServerSocket m_tcpSock;
    private volatile boolean m_stop;
    private LinkedList<TcpStreamHandler> m_receivers;
    private Thread m_context;
    private Fiber m_parent;
    private List<EventHandler> m_handlers;
    private String m_logPrefix;
    private int m_recsPerConn;
    private InetAddress m_ipAddress;

    public TcpServer(Fiber parent, List<EventHandler> handlers) throws IOException {
        this(parent, handlers, 5817, InetAddressUtils.addr((String)DEFAULT_IP_ADDRESS));
    }

    public TcpServer(Fiber parent, List<EventHandler> handlers, int port, InetAddress address) throws IOException {
        this.m_parent = parent;
        this.m_tcpPort = port;
        this.m_ipAddress = address;
        this.m_receivers = new LinkedList();
        this.m_stop = false;
        this.m_context = null;
        this.m_handlers = handlers;
        this.m_logPrefix = "eventd";
        this.m_recsPerConn = -1;
        try {
            this.m_tcpSock = new ServerSocket(this.m_tcpPort, 0, this.m_ipAddress);
        }
        catch (IOException e) {
            IOException n = new IOException("Could not create listening TCP socket on " + this.m_ipAddress + ":" + this.m_tcpPort + ": " + e);
            n.initCause(e);
            throw n;
        }
    }

    public void stop() throws InterruptedException {
        LOG.debug("stop method invoked");
        this.m_stop = true;
        if (this.m_context != null) {
            LOG.debug("Interrupting and joining context thread {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined {}", (Object)this.m_context.getName());
            this.m_context = null;
        }
        LOG.debug("Attempting to stop and join all stream handlers");
        LOG.debug("There are {} receivers", (Object)this.m_receivers.size());
        int ndx = 0;
        Iterator i = this.m_receivers.iterator();
        while (i.hasNext()) {
            TcpStreamHandler t = (TcpStreamHandler)i.next();
            if (t.isAlive()) {
                LOG.debug("Calling stop on handler index {}", (Object)ndx);
                t.stop();
                LOG.debug("Stopped handler index {}", (Object)ndx);
            }
            ++ndx;
            i.remove();
        }
        LOG.debug("All TCP Handlers are stopped and removed");
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = this.m_context = Thread.currentThread();
        synchronized (thread) {
            this.m_context.notifyAll();
        }
        Logging.putPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            LOG.debug("Stop flag set on thread startup");
            try {
                if (this.m_tcpSock != null) {
                    this.m_tcpSock.close();
                }
                LOG.debug("The socket has been closed");
            }
            catch (Throwable e) {
                LOG.warn("An exception occured closing the socket", e);
            }
            LOG.debug("Thread exiting");
            return;
        }
        LOG.debug("Server connection processor started on {}:{}", (Object)this.m_ipAddress, (Object)this.m_tcpPort);
        try {
            this.m_tcpSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            if (!this.m_stop) {
                LOG.warn("An I/O exception occured setting the socket timeout", (Throwable)e);
            }
            LOG.debug("Thread exiting due to socket error", (Throwable)e);
            return;
        }
        boolean ioInterrupted = false;
        while (this.m_parent.getStatus() != 4 && this.m_parent.getStatus() != 3 && !this.m_stop) {
            try {
                Thread processor;
                if (!ioInterrupted) {
                    LOG.debug("Waiting for new connection");
                }
                Socket newbie = this.m_tcpSock.accept();
                ioInterrupted = false;
                StringBuffer connection = new StringBuffer(InetAddressUtils.str((InetAddress)newbie.getInetAddress()));
                connection.append(":").append(newbie.getPort());
                LOG.debug("New connection accepted from {}", (Object)connection);
                TcpStreamHandler handler = new TcpStreamHandler(this.m_parent, newbie, this.m_handlers, this.m_recsPerConn);
                Thread thread2 = processor = new Thread((Runnable)handler, this.m_parent.getName() + "[" + connection + "]");
                synchronized (thread2) {
                    processor.start();
                    try {
                        processor.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("The thread was interrupted", (Throwable)e);
                    }
                }
                LOG.debug("A new stream handler thread has been started");
                this.m_receivers.add(handler);
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (IOException e) {
                LOG.error("Server Socket I/O Error", (Throwable)e);
                break;
            }
            Iterator i = this.m_receivers.iterator();
            while (i.hasNext()) {
                TcpStreamHandler t = (TcpStreamHandler)i.next();
                if (t.isAlive()) continue;
                i.remove();
            }
        }
        try {
            LOG.debug("closing the server socket connection");
            this.m_tcpSock.close();
        }
        catch (Throwable t) {
            LOG.error("An I/O Error Occcured Closing the Server Socket", t);
        }
        LOG.debug("TCP Server Shutdown");
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    public void setEventsPerConnection(int number) {
        this.m_recsPerConn = number;
    }
}

