/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.snmp.IpAddrTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddrTable
extends SnmpTable<IpAddrTableEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(IpAddrTable.class);

    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    @Override
    protected IpAddrTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        for (IpAddrTableEntry entry : this) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            InetAddress[] pair = new InetAddress[]{entry.getIpAdEntAddr(), entry.getIpAdEntNetMask()};
            return pair;
        }
        return null;
    }

    public int getIfIndex(InetAddress address) {
        LOG.debug("getIfIndex: num ipAddrTable entries: {}", (Object)this.size());
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr = entry.getIpAdEntAddr();
            if (ifAddr == null || !ifAddr.equals(address)) continue;
            Integer ndx = entry.getIpAdEntIfIndex();
            LOG.debug("getIfIndex: got a match for address {} index: {}", (Object)InetAddressUtils.str((InetAddress)address), (Object)ndx);
            if (ndx == null) continue;
            return ndx;
        }
        LOG.debug("getIfIndex: no matching ipAddrTable entry for {}", (Object)InetAddressUtils.str((InetAddress)address));
        return -1;
    }

    public List<InetAddress> getIpAddresses(int index) {
        if (index == -1) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != index || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }

    public List<InetAddress> getIpAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }
}

