/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.plugins.JDBCPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCStoredProcedurePlugin
extends JDBCPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCStoredProcedurePlugin.class);
    private static final String DEFAULT_STORED_PROCEDURE = "isRunning";

    public JDBCStoredProcedurePlugin() {
        LOG.info("JDBCStoredProcedurePlugin class loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkStatus(Connection con, Map<String, Object> qualifiers) {
        boolean status = false;
        CallableStatement cs = null;
        try {
            String storedProcedure = ParameterMap.getKeyedString(qualifiers, (String)"stored-procedure", (String)DEFAULT_STORED_PROCEDURE);
            String procedureCall = "{ ? = call test." + storedProcedure + "()}";
            cs = con.prepareCall(procedureCall);
            LOG.debug("Calling stored procedure: {}", (Object)procedureCall);
            cs.registerOutParameter(1, -7);
            cs.executeUpdate();
            status = cs.getBoolean(1);
            LOG.debug("Stored procedure returned: {}", (Object)status);
            this.closeStmt(cs);
        }
        catch (SQLException sqlEx) {
            LOG.debug("JDBC stored procedure call not functional: {}", (Object)sqlEx.getSQLState(), (Object)sqlEx);
        }
        finally {
            this.closeStmt(cs);
        }
        return status;
    }
}

