/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DominoIIOPPlugin
extends AbstractTcpPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DominoIIOPPlugin.class);
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String PROTOCOL_NAME = "DominoIIOP";

    public DominoIIOPPlugin() {
        super(PROTOCOL_NAME, 63148, 5000, 0);
    }

    @Override
    protected boolean checkProtocol(Socket socket, ConnectionConfig config) {
        return true;
    }

    @Override
    protected ConnectionConfig createConnectionConfig(InetAddress address, int port) {
        return new DominoConnectionConfig(address, port);
    }

    @Override
    protected void populateConnectionConfig(ConnectionConfig connConfig, Map<String, Object> qualifiers) {
        super.populateConnectionConfig(connConfig, qualifiers);
        DominoConnectionConfig config = (DominoConnectionConfig)connConfig;
        config.setIorPort(this.getKeyedInteger(qualifiers, "ior-port", 80));
    }

    @Override
    protected boolean preconnectCheck(ConnectionConfig tcpConfig) {
        DominoConnectionConfig config = (DominoConnectionConfig)tcpConfig;
        try {
            this.retrieveIORText(InetAddressUtils.str((InetAddress)config.getInetAddress()), config.getIorPort());
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Throwable e) {
            LOG.debug("DominoIIOPMonitor: failed to get the corba IOR from {}", (Object)InetAddressUtils.str((InetAddress)config.getInetAddress()));
            return false;
        }
    }

    private String retrieveIORText(String host, int port) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!IOR.startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + IOR);
        }
        return IOR;
    }

    protected void saveConfig(ConnectionConfig config) {
    }

    public static class DominoConnectionConfig
    extends ConnectionConfig {
        int m_iorPort;

        public DominoConnectionConfig(InetAddress inetAddress, int port) {
            super(inetAddress, port);
        }

        public int getIorPort() {
            return this.m_iorPort;
        }

        public void setIorPort(int iorPort) {
            this.m_iorPort = iorPort;
        }
    }
}

