/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUsagePlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DiskUsagePlugin.class);
    private static final String PROTOCOL_NAME = "DiskUsage";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final int MATCH_TYPE_EXACT = 0;
    private static final int MATCH_TYPE_STARTSWITH = 1;
    private static final int MATCH_TYPE_ENDSWITH = 2;
    private static final int MATCH_TYPE_REGEX = 3;

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            return this.getValue(agentConfig, DEFAULT_OID) != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        return val == null ? null : val.toString();
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int matchType = 0;
        try {
            SnmpObjId hrStorageDescrSnmpObject;
            Map descrResults;
            String disk = ParameterMap.getKeyedString(qualifiers, (String)"disk", null);
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            if (qualifiers != null) {
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if (qualifiers.get("match-type") != null) {
                    String matchTypeStr = ParameterMap.getKeyedString(qualifiers, (String)"match-type", (String)"exact");
                    if (matchTypeStr.equalsIgnoreCase("exact")) {
                        matchType = 0;
                    } else if (matchTypeStr.equalsIgnoreCase("startswith")) {
                        matchType = 1;
                    } else if (matchTypeStr.equalsIgnoreCase("endswith")) {
                        matchType = 2;
                    } else if (matchTypeStr.equalsIgnoreCase("regex")) {
                        matchType = 3;
                    } else {
                        throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
                    }
                }
            }
            if ((descrResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)(hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr)))).size() == 0) {
                return false;
            }
            for (Map.Entry e : descrResults.entrySet()) {
                LOG.debug("capsd: SNMPwalk succeeded, addr={} oid={} instance={} value={}", new Object[]{InetAddressUtils.str((InetAddress)address), hrStorageDescrSnmpObject, e.getKey(), e.getValue()});
                if (!this.isMatch(((SnmpValue)e.getValue()).toString(), disk, matchType)) continue;
                LOG.debug("Found disk '{}' (matching hrStorageDescr was '{}')", (Object)disk, e.getValue());
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private boolean isMatch(String candidate, String target, int matchType) {
        boolean matches = false;
        LOG.debug("isMessage: candidate is '{}', matching against target '{}'", (Object)candidate, (Object)target);
        if (matchType == 0) {
            LOG.debug("Attempting equality match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.equals(target);
        } else if (matchType == 1) {
            LOG.debug("Attempting startsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.startsWith(target);
        } else if (matchType == 2) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.endsWith(target);
        } else if (matchType == 3) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        LOG.debug("isMatch: Match is positive");
        return matches;
    }
}

