/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import jcifs.netbios.NbtAddress;
import org.opennms.netmgt.config.capsd.SmbAuth;

public abstract class SmbUtils {
    public static final int WORKSTATION_SERVICE = 0;
    public static final int MESSENGER_SERVICE_A = 1;
    public static final int MASTER_BROWSER_G = 1;
    public static final int MESSENGER_SERVICE_B = 3;
    public static final int RAS_SERVER_SERVICE = 6;
    public static final int NETDDE_SERVICE = 31;
    public static final int FILE_SERVER_SERVICE = 32;
    public static final int RAS_CLIENT_SERVICE = 33;
    public static final int MS_EXCHANGE_INTERCHANGE = 34;
    public static final int MS_EXCHANGE_STORE = 35;
    public static final int MS_EXCHANGE_DIRECTORY = 36;
    public static final int MODEM_SHARING_SERVER_SERVICE = 48;
    public static final int MODEM_SHARING_CLIENT_SERVICE = 49;
    public static final int SMS_CLIENT_REMOTE_CONTROL = 67;
    public static final int SMS_ADMIN_REMOTE_CONTROL_TOOL = 68;
    public static final int SMS_CLIENTS_REMOTE_CHAT = 69;
    public static final int SMS_CLIENTS_REMOTE_TRANSFER = 70;
    public static final int DEC_PATHWORKS_TCPIP_SERVICE_A = 76;
    public static final int DEC_PATHWORKS_TCPIP_SERVICE_B = 82;
    public static final int MS_EXCHANGE_MTA = 135;
    public static final int MS_EXCHANGE_IMC = 106;
    public static final int NETWORK_MONITOR_AGENT = 190;
    public static final int NETWORK_MONITOR_APPLICATION = 191;
    public static final int MESSENGER_SERVICE = 3;
    public static final int DOMAIN_NAME = 0;
    public static final int DOMAIN_MASTER_BROWSER = 27;
    public static final int DOMAIN_CONTROLLERS = 28;
    public static final int MASTER_BROWSER_U = 29;
    public static final int BROWSER_SERVICE_ELECTIONS = 30;
    public static final int INTERNET_INFORMATION_SERVER_G = 28;
    public static final int INTERNET_INFORMATION_SERVER_U = 0;
    public static final int LOTUS_NOTES_SERVER_SERVICE = 43;
    public static final int LOTUS_NOTES_IRIS_MULTICAST = 47;
    public static final int LOTUS_NOTES_IRIS_NAME_SERVER = 51;
    public static final int DCA_IRMALAN_GATEWAY_SERVER_SERVICE = 32;

    static String getAuthenticationDomainName(NbtAddress[] addresses, String cname) {
        String domain = null;
        if (addresses != null) {
            for (int i = 0; i < addresses.length && domain == null; ++i) {
                NbtAddress addr = addresses[i];
                if (addr.getNameType() != 0 || addr.getHostName().equals(cname) || addr.getHostName().startsWith("IS~")) continue;
                domain = addr.getHostName();
            }
        }
        return domain;
    }

    static String getOsLabel(String nativeOS, NbtAddress[] addresses, boolean isSamba, boolean hasExchange) {
        String osLabel = null;
        if (nativeOS == null) {
            if (isSamba) {
                osLabel = "Linux/UNIX";
            } else if (hasExchange) {
                osLabel = "Windows Server";
            }
        } else if (nativeOS.length() == 0) {
            osLabel = "Windows 95/98";
        } else if (nativeOS.equalsIgnoreCase("Unix")) {
            osLabel = "Linux/UNIX";
        } else if (nativeOS.equalsIgnoreCase("Windows 5.0")) {
            nativeOS = "Windows 2000";
            osLabel = hasExchange || SmbUtils.isNTServer(addresses) ? nativeOS.concat(" Server") : nativeOS;
        } else {
            osLabel = nativeOS.startsWith("Windows NT") ? (hasExchange || SmbUtils.isNTServer(addresses) ? nativeOS.concat(" Server") : nativeOS) : nativeOS;
        }
        return osLabel;
    }

    static boolean isNTServer(NbtAddress[] addresses) {
        boolean isNTServer = false;
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                NbtAddress nbtAddr = addresses[i];
                if (nbtAddr.getNameType() == 28 && !nbtAddr.getHostName().equals("INET~SERVICES")) {
                    isNTServer = true;
                    break;
                }
                if (nbtAddr.getNameType() != 35 && nbtAddr.getNameType() != 36) continue;
                isNTServer = true;
                break;
            }
        }
        return isNTServer;
    }

    static String getSmbURL(SmbAuth smbAuth, String cname) {
        String domainParm = null;
        String useridParm = null;
        String passwordParm = null;
        if (smbAuth != null) {
            useridParm = smbAuth.getUser();
            passwordParm = smbAuth.getPassword();
            if (smbAuth.getType().equalsIgnoreCase("domain")) {
                domainParm = smbAuth.getContent();
            }
        }
        String url = "smb://";
        if (domainParm != null) {
            url = url.concat(domainParm + ";");
        }
        if (useridParm != null) {
            url = url.concat(useridParm);
        }
        if (passwordParm != null) {
            url = url.concat(":" + passwordParm);
        }
        if (useridParm != null) {
            url = url.concat("@");
        }
        url = url.concat(cname);
        return url;
    }
}

