/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class HibernateTrapdIpMgr
implements TrapdIpMgr,
InitializingBean {
    private IpInterfaceDao m_ipInterfaceDao;
    private Map<InetAddress, Integer> m_knownips = new HashMap<InetAddress, Integer>();

    @Override
    @Transactional(readOnly=true)
    public synchronized void dataSourceSync() {
        this.m_knownips = this.m_ipInterfaceDao.getInterfacesForNodes();
    }

    @Override
    public synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return HibernateTrapdIpMgr.longValue(this.m_knownips.get(InetAddressUtils.getInetAddress((String)addr)));
    }

    @Override
    public synchronized long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        boolean add = true;
        if (this.m_knownips.containsKey(InetAddressUtils.getInetAddress((String)addr))) {
            OnmsIpInterface intf = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(new Integer((int)nodeid), addr);
            add = intf != null && intf.isPrimary();
            this.log().info("setNodeId: address found " + intf + ". Should be added? " + add);
        }
        return add ? HibernateTrapdIpMgr.longValue(this.m_knownips.put(InetAddressUtils.getInetAddress((String)addr), new Integer((int)nodeid))) : -1L;
    }

    @Override
    public synchronized long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return HibernateTrapdIpMgr.longValue(this.m_knownips.remove(InetAddressUtils.getInetAddress((String)addr)));
    }

    @Override
    public synchronized void clearKnownIpsMap() {
        this.m_knownips.clear();
    }

    private static long longValue(Integer result) {
        return result == null ? -1L : result.longValue();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_ipInterfaceDao != null ? 1 : 0) != 0, (String)"property ipInterfaceDao must be set");
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

