/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

public class DefaultTicketerServiceLayer
implements TicketerServiceLayer,
InitializingBean {
    private AlarmDao m_alarmDao;
    private Plugin m_ticketerPlugin;
    private EventIpcManager m_eventIpcManager = EventIpcManagerFactory.getIpcManager();
    static final String COMMS_ERROR_UEI = "uei.opennms.org/troubleTicket/communicationError";

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setTicketerPlugin(Plugin ticketerPlugin) {
        this.m_ticketerPlugin = ticketerPlugin;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_alarmDao != null ? 1 : 0) != 0, (String)"alarmDao property must be set");
        Assert.state((this.m_ticketerPlugin != null ? 1 : 0) != 0, (String)"ticketPlugin property must be set");
    }

    @Override
    public void cancelTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        if (alarm == null) {
            throw new ObjectRetrievalFailureException("Unable to locate Alarm with ID: " + alarmId, null);
        }
        try {
            this.setTicketState(ticketId, Ticket.State.CANCELLED);
            alarm.setTTicketState(TroubleTicketState.CANCELLED);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CANCEL_FAILED);
            this.log().error("Unable to cancel ticket for alarm: " + e.getMessage());
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private void setTicketState(String ticketId, Ticket.State state) throws PluginException {
        try {
            Ticket ticket = this.m_ticketerPlugin.get(ticketId);
            ticket.setState(state);
            this.m_ticketerPlugin.saveOrUpdate(ticket);
        }
        catch (PluginException e) {
            this.log().error("Unable to set ticket state");
            throw e;
        }
    }

    @Override
    public void closeTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        try {
            this.setTicketState(ticketId, Ticket.State.CLOSED);
            alarm.setTTicketState(TroubleTicketState.CLOSED);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CLOSE_FAILED);
            this.log().error("Unable to close ticket for alarm: " + e.getMessage());
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    @Override
    public void createTicketForAlarm(int alarmId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Ticket ticket = this.createTicketFromAlarm(alarm);
        try {
            this.m_ticketerPlugin.saveOrUpdate(ticket);
            alarm.setTTicketId(ticket.getId());
            alarm.setTTicketState(TroubleTicketState.OPEN);
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.CREATE_FAILED);
            this.log().error("Unable to create ticket for alarm: " + e.getMessage());
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private Ticket createTicketFromAlarm(OnmsAlarm alarm) {
        Ticket ticket = new Ticket();
        ticket.setSummary(alarm.getLogMsg());
        ticket.setDetails(alarm.getDescription());
        ticket.setId(alarm.getTTicketId());
        return ticket;
    }

    @Override
    public void updateTicketForAlarm(int alarmId, String ticketId) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Ticket ticket = null;
        try {
            ticket = this.m_ticketerPlugin.get(ticketId);
            if (ticket.getState() == Ticket.State.CANCELLED) {
                alarm.setTTicketState(TroubleTicketState.CANCELLED);
            } else if (ticket.getState() == Ticket.State.CLOSED) {
                alarm.setTTicketState(TroubleTicketState.CLOSED);
            } else if (ticket.getState() == Ticket.State.OPEN) {
                alarm.setTTicketState(TroubleTicketState.OPEN);
            } else {
                alarm.setTTicketState(TroubleTicketState.OPEN);
            }
        }
        catch (PluginException e) {
            alarm.setTTicketState(TroubleTicketState.UPDATE_FAILED);
            this.log().error("Unable to update ticket for alarm: " + e.getMessage());
            this.m_eventIpcManager.sendNow(this.createEvent(e.getMessage()));
        }
        this.m_alarmDao.saveOrUpdate((Object)alarm);
    }

    private Event createEvent(String reason) {
        EventBuilder bldr = new EventBuilder(COMMS_ERROR_UEI, "Ticketd");
        bldr.addParam("reason", reason);
        return bldr.getEvent();
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager ipcManager) {
        this.m_eventIpcManager = ipcManager;
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

