/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.poller.Outage;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdingEventProxyFactory;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;

public class ThresholdingSet {
    protected final int m_nodeId;
    protected final String m_hostAddress;
    protected final String m_serviceName;
    protected final RrdRepository m_repository;
    protected ThresholdsDao m_thresholdsDao;
    protected boolean m_initialized = false;
    protected boolean m_hasThresholds = false;
    protected List<ThresholdGroup> m_thresholdGroups = new LinkedList<ThresholdGroup>();
    protected final List<String> m_scheduledOutages = new ArrayList<String>();

    public ThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository) {
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress == null ? null : hostAddress.intern();
        this.m_serviceName = serviceName == null ? null : serviceName.intern();
        this.m_repository = repository;
        this.initThresholdsDao();
        this.initialize();
    }

    protected void initialize() {
        List<String> groupNameList = this.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        this.m_thresholdGroups.clear();
        for (String groupName : groupNameList) {
            try {
                ThresholdGroup thresholdGroup = this.m_thresholdsDao.get(groupName);
                if (thresholdGroup == null) {
                    ThresholdingSet.log().error("initialize: Could not get threshold group with name " + groupName);
                }
                this.m_thresholdGroups.add(thresholdGroup);
                if (!ThresholdingSet.log().isDebugEnabled()) continue;
                ThresholdingSet.log().debug("initialize: Adding threshold group: " + thresholdGroup);
            }
            catch (Throwable e) {
                ThresholdingSet.log().error("initialize: Can't process threshold group " + groupName, e);
            }
        }
        this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        this.updateScheduledOutages();
    }

    public void reinitialize() {
        this.m_initialized = false;
        ThresholdingEventProxyFactory.getFactory().getProxy().removeAllEvents();
        this.initThresholdsDao();
        this.mergeThresholdGroups();
        this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        this.updateScheduledOutages();
        ThresholdingEventProxyFactory.getFactory().getProxy().sendAllEvents();
    }

    protected void mergeThresholdGroups() {
        ThresholdingSet.log().debug("mergeThresholdGroups: begin merging operation");
        List<String> groupNameList = this.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        if (groupNameList.size() != this.m_thresholdGroups.size()) {
            ThresholdingSet.log().debug("mergeThresholdGroups: new group name list differs from current threshold group list");
            Iterator<ThresholdGroup> i = this.m_thresholdGroups.iterator();
            while (i.hasNext()) {
                ThresholdGroup group = i.next();
                if (groupNameList.contains(group.getName())) continue;
                ThresholdingSet.log().info("mergeThresholdGroups: deleting group " + group);
                group.delete();
                i.remove();
            }
        }
        LinkedList<ThresholdGroup> newThresholdGroupList = new LinkedList<ThresholdGroup>();
        for (String groupName : groupNameList) {
            ThresholdGroup thresholdGroup;
            ThresholdGroup foundGroup = null;
            for (ThresholdGroup group : this.m_thresholdGroups) {
                if (!group.getName().equals(groupName)) continue;
                foundGroup = group;
            }
            if (foundGroup == null) {
                thresholdGroup = this.m_thresholdsDao.get(groupName);
                if (thresholdGroup == null) {
                    ThresholdingSet.log().error("mergeThresholdGroups: Could not get threshold group with name " + groupName);
                    continue;
                }
                newThresholdGroupList.add(thresholdGroup);
                if (!ThresholdingSet.log().isDebugEnabled()) continue;
                ThresholdingSet.log().debug("mergeThresholdGroups: Adding threshold group: " + thresholdGroup);
                continue;
            }
            thresholdGroup = this.m_thresholdsDao.merge(foundGroup);
            newThresholdGroupList.add(thresholdGroup);
            if (!ThresholdingSet.log().isDebugEnabled()) continue;
            ThresholdingSet.log().debug("mergeThresholdGroups: Merging threshold group: " + thresholdGroup);
        }
        this.m_thresholdGroups = newThresholdGroupList;
    }

    public boolean hasThresholds() {
        return this.m_hasThresholds;
    }

    public boolean hasThresholds(String resourceTypeName, String attributeName) {
        boolean ok = false;
        for (ThresholdGroup group : this.m_thresholdGroups) {
            Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSet.getEntityMap(group, resourceTypeName);
            if (entityMap == null) continue;
            for (String key : entityMap.keySet()) {
                for (ThresholdEntity thresholdEntity : entityMap.get(key)) {
                    Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                    if (!requiredDatasources.contains(attributeName)) continue;
                    ok = true;
                }
            }
        }
        ThresholdingSet.log().debug("hasThresholds: " + resourceTypeName + "@" + attributeName + "? " + ok);
        return ok;
    }

    public boolean isNodeInOutage() {
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        boolean outageFound = false;
        for (String outageName : this.m_scheduledOutages) {
            if (!outageFactory.isCurTimeInOutage(outageName)) continue;
            ThresholdingSet.log().debug("isNodeInOutage[node=" + this.m_nodeId + "]: current time is on outage using '" + outageName + "'; checking the node with IP " + this.m_hostAddress);
            if (!outageFactory.isNodeIdInOutage((long)this.m_nodeId, outageName) && !outageFactory.isInterfaceInOutage(this.m_hostAddress, outageName)) continue;
            ThresholdingSet.log().debug("isNodeInOutage[node=" + this.m_nodeId + "]: configured outage '" + outageName + "' applies, interface " + this.m_hostAddress + " will be ignored for threshold processing");
            outageFound = true;
            break;
        }
        return outageFound;
    }

    protected List<Event> applyThresholds(CollectionResourceWrapper resourceWrapper, Map<String, CollectionAttribute> attributesMap) {
        LinkedList<Event> eventsList = new LinkedList<Event>();
        if (attributesMap == null || attributesMap.size() == 0) {
            ThresholdingSet.log().debug("applyThresholds: Ignoring resource " + resourceWrapper + " because required attributes map is empty.");
            return eventsList;
        }
        ThresholdingSet.log().debug("applyThresholds: Applying thresholds on " + resourceWrapper + " using " + attributesMap.size() + " attributes.");
        Date date = new Date();
        for (ThresholdGroup group : this.m_thresholdGroups) {
            Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSet.getEntityMap(group, resourceWrapper.getResourceTypeName());
            if (entityMap == null) continue;
            for (String key : entityMap.keySet()) {
                for (ThresholdEntity thresholdEntity : entityMap.get(key)) {
                    if (this.passedThresholdFilters(resourceWrapper, thresholdEntity)) {
                        ThresholdingSet.log().info("applyThresholds: Processing threshold " + key + " : " + thresholdEntity);
                        Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                        HashMap<String, Double> values = new HashMap<String, Double>();
                        boolean valueMissing = false;
                        for (String ds : requiredDatasources) {
                            Double dsValue = resourceWrapper.getAttributeValue(ds);
                            if (dsValue == null) {
                                ThresholdingSet.log().info("applyThresholds: Could not get data source value for '" + ds + "'.  Not evaluating threshold.");
                                valueMissing = true;
                            }
                            values.put(ds, dsValue);
                        }
                        if (valueMissing) continue;
                        ThresholdingSet.log().info("applyThresholds: All values found, evaluating");
                        resourceWrapper.setLabel(thresholdEntity.getDatasourceLabel());
                        List<Event> thresholdEvents = thresholdEntity.evaluateAndCreateEvents(resourceWrapper, values, date);
                        eventsList.addAll(thresholdEvents);
                        continue;
                    }
                    ThresholdingSet.log().info("applyThresholds: Not processing threshold " + key + " : " + thresholdEntity + " because no filters matched");
                }
            }
        }
        return eventsList;
    }

    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        ResourceFilter[] filters = thresholdEntity.getThresholdConfig().getBasethresholddef().getResourceFilter();
        if (filters.length == 0) {
            return true;
        }
        if (ThresholdingSet.log().isDebugEnabled()) {
            ThresholdingSet.log().debug("passedThresholdFilters: applying " + filters.length + " filters to resource " + resource);
        }
        int count = 1;
        String operator = thresholdEntity.getThresholdConfig().getBasethresholddef().getFilterOperator().toLowerCase();
        boolean andResult = true;
        for (ResourceFilter f : filters) {
            if (ThresholdingSet.log().isDebugEnabled()) {
                ThresholdingSet.log().debug("passedThresholdFilters: filter #" + count + ": field=" + f.getField() + ", regex='" + f.getContent() + "'");
            }
            ++count;
            String attr = resource.getLabelValue(f.getField());
            if (attr != null) {
                try {
                    Pattern p = Pattern.compile(f.getContent());
                    Matcher m = p.matcher(attr);
                    boolean pass = m.matches();
                    if (ThresholdingSet.log().isDebugEnabled()) {
                        ThresholdingSet.log().debug("passedThresholdFilters: the value of " + f.getField() + " is " + attr + ". Pass filter? " + pass);
                    }
                    if (operator.equals("or") && pass) {
                        return true;
                    }
                    if (!operator.equals("and")) continue;
                    boolean bl = andResult = andResult && pass;
                    if (andResult) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    ThresholdingSet.log().warn("passedThresholdFilters: the regular expression " + f.getContent() + " is invalid: " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            ThresholdingSet.log().warn("passedThresholdFilters: can't find value of " + f.getField() + " for resource " + resource);
        }
        return operator.equals("and") && andResult;
    }

    protected void initThresholdsDao() {
        if (!this.m_initialized) {
            ThresholdingSet.log().debug("initThresholdsDao: Initializing Factories and DAOs");
            this.m_initialized = true;
            DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
            try {
                ThresholdingConfigFactory.init();
                defaultThresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
                defaultThresholdsDao.afterPropertiesSet();
            }
            catch (Throwable t) {
                ThresholdingSet.log().error("initThresholdsDao: Could not initialize DefaultThresholdsDao: " + t, t);
                throw new RuntimeException("Could not initialize DefaultThresholdsDao: " + t, t);
            }
            try {
                ThreshdConfigFactory.init();
            }
            catch (Throwable t) {
                ThresholdingSet.log().error("initThresholdsDao: Could not initialize ThreshdConfigFactory: " + t, t);
                throw new RuntimeException("Could not initialize ThreshdConfigFactory: " + t, t);
            }
            this.m_thresholdsDao = defaultThresholdsDao;
        }
    }

    private List<String> getThresholdGroupNames(int nodeId, String hostAddress, String serviceName) {
        ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
        LinkedList<String> groupNameList = new LinkedList<String>();
        for (Package pkg : configManager.getConfiguration().getPackage()) {
            if (!configManager.serviceInPackageAndEnabled(serviceName, pkg)) {
                if (!ThresholdingSet.log().isDebugEnabled()) continue;
                ThresholdingSet.log().debug("getThresholdGroupNames: address/service: " + hostAddress + "/" + serviceName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName());
                continue;
            }
            if (ThresholdingSet.log().isDebugEnabled()) {
                ThresholdingSet.log().debug("getThresholdGroupNames: checking ipaddress " + hostAddress + " for inclusion in pkg " + pkg.getName());
            }
            if (!configManager.interfaceInPackage(hostAddress, pkg)) {
                if (!ThresholdingSet.log().isDebugEnabled()) continue;
                ThresholdingSet.log().debug("getThresholdGroupNames: address/service: " + hostAddress + "/" + serviceName + " not scheduled, interface does not belong to package: " + pkg.getName());
                continue;
            }
            for (Service svc : pkg.getService()) {
                if (!svc.getName().equals(serviceName)) continue;
                for (Parameter parameter : svc.getParameter()) {
                    if (!parameter.getKey().equals("thresholding-group")) continue;
                    String groupName = parameter.getValue();
                    groupNameList.add(groupName);
                    if (!ThresholdingSet.log().isDebugEnabled()) continue;
                    ThresholdingSet.log().debug("getThresholdGroupNames:  address/service: " + hostAddress + "/" + serviceName + ". Adding Group " + groupName);
                }
            }
        }
        return groupNameList;
    }

    protected void updateScheduledOutages() {
        this.m_scheduledOutages.clear();
        ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
        for (Package pkg : configManager.getConfiguration().getPackage()) {
            for (String outageCal : pkg.getOutageCalendarCollection()) {
                ThresholdingSet.log().info("updateScheduledOutages[node=" + this.m_nodeId + "]: checking scheduled outage '" + outageCal + "'");
                try {
                    Outage outage = PollOutagesConfigFactory.getInstance().getOutage(outageCal);
                    if (outage == null) {
                        ThresholdingSet.log().info("updateScheduledOutages[node=" + this.m_nodeId + "]: scheduled outage '" + outageCal + "' is not defined.");
                        continue;
                    }
                    ThresholdingSet.log().debug("updateScheduledOutages[node=" + this.m_nodeId + "]: outage calendar '" + outage.getName() + "' found on package '" + pkg.getName() + "'");
                    this.m_scheduledOutages.add(outageCal);
                }
                catch (Exception e) {
                    ThresholdingSet.log().info("updateScheduledOutages[node=" + this.m_nodeId + "]: scheduled outage '" + outageCal + "' does not exist.");
                }
            }
        }
    }

    private static Map<String, Set<ThresholdEntity>> getEntityMap(ThresholdGroup thresholdGroup, String resourceType) {
        if (ThresholdingSet.log().isDebugEnabled()) {
            ThresholdingSet.log().debug("getEntityMap: checking if the resourceType '" + resourceType + "' exists on threshold group " + thresholdGroup);
        }
        Map<String, Set<ThresholdEntity>> entityMap = null;
        if ("node".equals(resourceType)) {
            entityMap = thresholdGroup.getNodeResourceType().getThresholdMap();
        } else if ("if".equals(resourceType)) {
            entityMap = thresholdGroup.getIfResourceType().getThresholdMap();
        } else {
            Map<String, ThresholdResourceType> typeMap = thresholdGroup.getGenericResourceTypeMap();
            if (typeMap == null) {
                ThresholdingSet.log().error("getEntityMap: Generic Resource Type map was null (this shouldn't happen) for threshold group " + thresholdGroup.getName());
                return null;
            }
            ThresholdResourceType thisResourceType = typeMap.get(resourceType);
            if (thisResourceType == null) {
                ThresholdingSet.log().info("getEntityMap: No thresholds configured for resource type " + resourceType + " in threshold group " + thresholdGroup.getName() + ". Skipping this group.");
                return null;
            }
            entityMap = thisResourceType.getThresholdMap();
        }
        return entityMap;
    }

    public String toString() {
        return this.m_thresholdGroups.toString();
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(ThresholdingSet.class);
    }
}

