/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdResourceType;

public class ThresholdGroup {
    private String m_name;
    private File m_rrdRepository;
    private ThresholdResourceType m_nodeResourceType;
    private ThresholdResourceType m_ifResourceType;
    private Map<String, ThresholdResourceType> m_genericResourceTypeMap = new HashMap<String, ThresholdResourceType>();

    public ThresholdResourceType getIfResourceType() {
        return this.m_ifResourceType;
    }

    public void setIfResourceType(ThresholdResourceType ifResourceType) {
        this.m_ifResourceType = ifResourceType;
    }

    public void setName(String name) {
        this.m_name = name == null ? null : name.intern();
    }

    public ThresholdGroup(String name) {
        this.m_name = name == null ? null : name.intern();
    }

    public String getName() {
        return this.m_name;
    }

    public void setRrdRepository(File rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    public File getRrdRepository() {
        return this.m_rrdRepository;
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setNodeResourceType(ThresholdResourceType nodeResourceType) {
        this.m_nodeResourceType = nodeResourceType;
    }

    public ThresholdResourceType getNodeResourceType() {
        return this.m_nodeResourceType;
    }

    public Map<String, ThresholdResourceType> getGenericResourceTypeMap() {
        return this.m_genericResourceTypeMap;
    }

    public void setGenericResourceTypeMap(Map<String, ThresholdResourceType> genericResourceTypeMap) {
        this.m_genericResourceTypeMap = genericResourceTypeMap;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName() + "={node:{");
        if (this.getNodeResourceType() != null) {
            buf.append(this.getNodeResourceType().getThresholdMap().values());
        }
        buf.append("}; iface:{");
        if (this.getIfResourceType() != null) {
            buf.append(this.getIfResourceType().getThresholdMap().values());
        }
        if (this.getGenericResourceTypeMap() != null) {
            for (String rType : this.getGenericResourceTypeMap().keySet()) {
                buf.append("}; " + rType + ":{");
                buf.append(this.getGenericResourceTypeMap().get(rType).getThresholdMap().values());
                buf.append("}");
            }
        }
        buf.append("}");
        String toString = buf.toString();
        return toString;
    }

    public void delete() {
        this.delete(this.getNodeResourceType());
        this.delete(this.getIfResourceType());
        for (String type : this.getGenericResourceTypeMap().keySet()) {
            this.delete(this.getGenericResourceTypeMap().get(type));
        }
    }

    private void delete(ThresholdResourceType type) {
        Map<String, Set<ThresholdEntity>> entityMap = type.getThresholdMap();
        for (String key : entityMap.keySet()) {
            for (ThresholdEntity e : entityMap.get(key)) {
                e.delete();
            }
        }
    }
}

