/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

public abstract class BaseThresholdDefConfigWrapper {
    Basethresholddef m_baseDef;

    protected BaseThresholdDefConfigWrapper(Basethresholddef baseDef) {
        this.m_baseDef = baseDef;
    }

    public static BaseThresholdDefConfigWrapper getConfigWrapper(Basethresholddef baseDef) throws ThresholdExpressionException {
        if (baseDef instanceof Threshold) {
            return new ThresholdConfigWrapper((Threshold)baseDef);
        }
        if (baseDef instanceof Expression) {
            return new ExpressionConfigWrapper((Expression)baseDef);
        }
        return null;
    }

    public abstract String getDatasourceExpression();

    public abstract Collection<String> getRequiredDatasources();

    public abstract double evaluate(Map<String, Double> var1) throws ThresholdExpressionException;

    public String getDsType() {
        return this.m_baseDef.getDsType();
    }

    public String getDsLabel() {
        return this.m_baseDef.getDsLabel();
    }

    public double getRearm() {
        return this.m_baseDef.getRearm();
    }

    public int getTrigger() {
        return this.m_baseDef.getTrigger();
    }

    public String getType() {
        return this.m_baseDef.getType();
    }

    public double getValue() {
        return this.m_baseDef.getValue();
    }

    public boolean hasRearm() {
        return this.m_baseDef.hasRearm();
    }

    public boolean hasTrigger() {
        return this.m_baseDef.hasTrigger();
    }

    public boolean hasValue() {
        return this.m_baseDef.hasValue();
    }

    public String getTriggeredUEI() {
        return this.m_baseDef.getTriggeredUEI();
    }

    public String getRearmedUEI() {
        return this.m_baseDef.getRearmedUEI();
    }

    public Basethresholddef getBasethresholddef() {
        return this.m_baseDef;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseThresholdDefConfigWrapper)) {
            return false;
        }
        BaseThresholdDefConfigWrapper o = (BaseThresholdDefConfigWrapper)obj;
        return this.getType().equals(o.getType()) && this.getDsType().equals(o.getDsType()) && this.getDatasourceExpression().equals(o.getDatasourceExpression());
    }

    public int hashCode() {
        return new HashCodeBuilder(97, 3).append((Object)this.m_baseDef).toHashCode();
    }

    public boolean identical(BaseThresholdDefConfigWrapper o) {
        return this.equals(o) && (this.getDsLabel() == o.getDsLabel() || this.getDsLabel() != null && this.getDsLabel().equals(o.getDsLabel())) && (this.getTriggeredUEI() == o.getTriggeredUEI() || this.getTriggeredUEI() != null && this.getTriggeredUEI().equals(o.getTriggeredUEI())) && (this.getRearmedUEI() == o.getRearmedUEI() || this.getRearmedUEI() != null && this.getRearmedUEI().equals(o.getRearmedUEI())) && this.getValue() == o.getValue() && this.getRearm() == o.getRearm() && this.getTrigger() == o.getTrigger() && this.getBasethresholddef().getFilterOperator().equals(o.getBasethresholddef().getFilterOperator()) && Arrays.equals(this.getBasethresholddef().getResourceFilter(), o.getBasethresholddef().getResourceFilter());
    }

    public void merge(BaseThresholdDefConfigWrapper threshold) {
        this.m_baseDef = threshold.getBasethresholddef();
    }
}

