/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollJob;
import org.opennms.netmgt.poller.remote.PollJobDetail;
import org.opennms.netmgt.poller.remote.PollObserver;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PolledServiceTrigger;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Poller
implements InitializingBean,
PollObserver,
ConfigurationChangedListener,
PropertyChangeListener {
    private PollerFrontEnd m_pollerFrontEnd;
    private Scheduler m_scheduler;
    private long m_initialSpreadTime = 300000L;

    public void setPollerFrontEnd(PollerFrontEnd pollerFrontEnd) {
        this.m_pollerFrontEnd = pollerFrontEnd;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setInitialSpreadTime(long initialSpreadTime) {
        this.m_initialSpreadTime = initialSpreadTime;
    }

    public void afterPropertiesSet() throws Exception {
        this.assertNotNull(this.m_scheduler, "scheduler");
        this.assertNotNull(this.m_pollerFrontEnd, "pollerFrontEnd");
        this.m_pollerFrontEnd.addConfigurationChangedListener(this);
        this.m_pollerFrontEnd.addPropertyChangeListener(this);
        if (this.m_pollerFrontEnd.isStarted()) {
            this.schedulePolls();
        } else {
            this.log().debug("Poller not yet registered");
        }
    }

    private void unschedulePolls() throws Exception {
        if (this.m_scheduler.isShutdown()) {
            return;
        }
        for (String jobName : this.m_scheduler.getJobNames("pollJobGroup")) {
            this.m_scheduler.deleteJob(jobName, "pollJobGroup");
        }
    }

    private void schedulePolls() throws Exception {
        this.log().debug("Enter schedulePolls");
        Collection<PolledService> polledServices = this.m_pollerFrontEnd.getPolledServices();
        if (polledServices == null || polledServices.size() == 0) {
            this.log().warn("No polling scheduled.");
            this.log().debug("Exit schedulePolls");
            return;
        }
        long startTime = System.currentTimeMillis();
        long scheduleSpacing = this.m_initialSpreadTime / (long)polledServices.size();
        for (PolledService polledService : polledServices) {
            String jobName = polledService.toString();
            if (this.m_scheduler.deleteJob(jobName, "pollJobGroup")) {
                this.log().debug(String.format("Job for %s already scheduled.  Rescheduling", polledService));
            } else {
                this.log().debug("Scheduling job for " + polledService);
            }
            Date initialPollTime = new Date(startTime);
            this.m_pollerFrontEnd.setInitialPollTime(polledService.getServiceId(), initialPollTime);
            PolledServiceTrigger pollTrigger = new PolledServiceTrigger(polledService);
            pollTrigger.setStartTime(initialPollTime);
            PollJobDetail jobDetail = new PollJobDetail(jobName, PollJob.class);
            jobDetail.setPolledService(polledService);
            jobDetail.setPollerFrontEnd(this.m_pollerFrontEnd);
            this.m_scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)pollTrigger);
            startTime += scheduleSpacing;
        }
        this.log().debug("Exit schedulePolls");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }

    @Override
    public void pollCompleted(String pollId, PollStatus pollStatus) {
        this.log().info("Complete Poll for " + pollId + " status = " + pollStatus);
    }

    @Override
    public void pollStarted(String pollId) {
        this.log().info("Begin Poll for " + pollId);
    }

    @Override
    public void configurationChanged(PropertyChangeEvent e) {
        try {
            this.unschedulePolls();
            this.schedulePolls();
        }
        catch (Throwable ex) {
            this.log().fatal("Unable to schedule polls!", ex);
            throw new RuntimeException("Unable to schedule polls!");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                if ("paused".equals(evt.getPropertyName())) {
                    this.unschedulePolls();
                } else if ("disconnected".equals(evt.getPropertyName())) {
                    this.unschedulePolls();
                }
            } else if ("paused".equals(evt.getPropertyName())) {
                this.schedulePolls();
            } else if ("disconnected".equals(evt.getPropertyName())) {
                this.schedulePolls();
            } else if ("started".equals(evt.getPropertyName())) {
                this.unschedulePolls();
            }
        }
        catch (Throwable ex) {
            this.log().fatal("Unable to schedule polls!", ex);
            throw new RuntimeException("Unable to schedule polls!");
        }
    }
}

