/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.ntp.NtpMessage;

@Distributable
public final class NtpMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 123;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 5000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)123);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        DatagramSocket socket = null;
        double responseTime = -1.0;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(tracker.getSoTimeout());
            tracker.reset();
            while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
                try {
                    byte[] data = new NtpMessage().toByteArray();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipv4Addr, port);
                    tracker.startAttempt();
                    socket.send(outgoing);
                    DatagramPacket incoming = new DatagramPacket(data, data.length);
                    socket.receive(incoming);
                    responseTime = tracker.elapsedTimeInMillis();
                    double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
                    NtpMessage msg = new NtpMessage(incoming.getData());
                    double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
                    if (log.isDebugEnabled()) {
                        log.debug("poll: valid NTP request received the local clock offset is " + localClockOffset + ", responseTime= " + responseTime + "ms");
                    }
                    log.debug("poll: NTP message : " + msg.toString());
                    serviceStatus = PollStatus.available((Double)responseTime);
                }
                catch (InterruptedIOException ex) {
                    // empty catch block
                }
                tracker.nextAttempt();
            }
        }
        catch (NoRouteToHostException e) {
            serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address: " + ipv4Addr, e);
        }
        catch (ConnectException e) {
            serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
        }
        catch (IOException ex) {
            serviceStatus = this.logDown(Level.INFO, "IOException while polling address: " + ipv4Addr, ex);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return serviceStatus;
    }
}

