/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.notifd.NotificationStrategy;

public class JavaMailNotificationStrategy
implements NotificationStrategy {
    @Override
    public int send(List<Argument> arguments) {
        this.log().debug("In the JavaMailNotification class.");
        try {
            JavaMailer jm = this.buildMessage(arguments);
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log().error("send: Error sending notification.", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private JavaMailer buildMessage(List<Argument> arguments) throws JavaMailerException {
        JavaMailer jm = new JavaMailer();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            this.log().debug("Current arg switch: " + i + " of " + arguments.size() + " is: " + arg.getSwitch());
            this.log().debug("Current arg  value: " + i + " of " + arguments.size() + " is: " + arg.getValue());
            if ("-email".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-pemail".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_PAGER_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-subject".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_SUBJECT");
                jm.setSubject(arg.getValue());
                continue;
            }
            if ("-nm".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_NUM_MSG");
                jm.setMessageText(arg.getValue());
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            this.log().debug("Found: PARAM_TEXT_MSG");
            jm.setMessageText(arg.getValue());
        }
        return jm;
    }
}

