/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTable;
import org.opennms.netmgt.linkd.snmp.FdbTableGet;
import org.opennms.netmgt.linkd.snmp.IntelVlanTable;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private static final int SNMP_IF_TYPE_L2_VLAN = 135;
    private static final int SNMP_IF_TYPE_L3_VLAN = 136;
    private String packageName;
    private List<NodeToNodeLink> m_links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> m_maclinks = new ArrayList<MacToNodeLink>();
    private Map<Integer, LinkableNode> m_bridgeNodes = new HashMap<Integer, LinkableNode>();
    private List<LinkableNode> m_routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_cdpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> m_atNodes = new ArrayList<LinkableNode>();
    private List<String> m_macsParsed = new ArrayList<String>();
    private List<String> macsExcluded = new ArrayList<String>();
    private Map<String, List<OnmsAtInterface>> m_macToAtinterface = new HashMap<String, List<OnmsAtInterface>>();
    private boolean enableDownloadDiscovery = false;
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private boolean forceIpRouteDiscoveryOnEtherNet = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;
    private Linkd m_linkd;

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            LogUtils.warnf((Object)this, (String)"run: linkd collections are suspended!", (Object[])new Object[0]);
        } else {
            int curNodeId;
            Collection<LinkableNode> linkableNodes = this.m_linkd.getLinkableNodesOnPackage(this.getPackageName());
            LogUtils.debugf((Object)this, (String)"run: LinkableNodes/package found: %d/%s", (Object[])new Object[]{linkableNodes.size(), this.getPackageName()});
            LogUtils.debugf((Object)this, (String)"run: discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes: %b/%b/%b", (Object[])new Object[]{this.discoveryUsingBridge, this.discoveryUsingCdp, this.discoveryUsingRoutes});
            LogUtils.debugf((Object)this, (String)"run: enableDownloadDiscovery: %b", (Object[])new Object[]{this.enableDownloadDiscovery});
            for (LinkableNode linkableNode : linkableNodes) {
                LogUtils.debugf((Object)this, (String)"run: Iterating on LinkableNode's found node with ID %d", (Object[])new Object[]{linkableNode.getNodeId()});
                if (linkableNode.isBridgeNode() && this.discoveryUsingBridge) {
                    this.m_bridgeNodes.put(new Integer(linkableNode.getNodeId()), linkableNode);
                }
                if (linkableNode.hasCdpInterfaces() && this.discoveryUsingCdp) {
                    this.m_cdpNodes.add(linkableNode);
                }
                if (linkableNode.hasRouteInterfaces() && this.discoveryUsingRoutes) {
                    this.m_routerNodes.add(linkableNode);
                }
                if (!linkableNode.hasAtInterfaces()) continue;
                this.m_atNodes.add(linkableNode);
            }
            this.populateMacToAtInterface();
            if (this.enableDownloadDiscovery) {
                LogUtils.infof((Object)this, (String)"run: fetching further unknown MAC address SNMP bridge table info", (Object[])new Object[0]);
                this.parseBridgeNodes();
            } else {
                LogUtils.infof((Object)this, (String)"run: skipping fetch of further unknown MAC address SNMP bridge table info", (Object[])new Object[0]);
            }
            if (this.m_cdpNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: finding links among nodes using Cisco Discovery Protocol", (Object[])new Object[0]);
            }
            for (LinkableNode curNode : this.m_cdpNodes) {
                int curCdpNodeId = curNode.getNodeId();
                InetAddress curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.infof((Object)this, (String)"run: parsing nodeid %d IP address %s with %d CDP interfaces.", (Object[])new Object[]{curCdpNodeId, curCdpIpAddr, curNode.getCdpInterfaces().size()});
                for (CdpInterface cdpInterface : curNode.getCdpInterfaces()) {
                    LinkableNode targetNode;
                    int cdpIfIndex = cdpInterface.getCdpIfIndex();
                    if (cdpIfIndex < 0) {
                        LogUtils.warnf((Object)this, (String)"run: found not valid CDP IfIndex %d.  Skipping.", (Object[])new Object[]{cdpIfIndex});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found CDP ifindex %d", (Object[])new Object[]{cdpIfIndex});
                    InetAddress targetIpAddr = cdpInterface.getCdpTargetIpAddr();
                    String hostAddress = InetAddressUtils.str((InetAddress)targetIpAddr);
                    if (!this.m_linkd.isInterfaceInPackage(targetIpAddr, this.getPackageName())) {
                        LogUtils.debugf((Object)this, (String)"run: IP address %s Not in package: %s.  Skipping.", (Object[])new Object[]{hostAddress, this.getPackageName()});
                        continue;
                    }
                    int targetCdpNodeId = cdpInterface.getCdpTargetNodeId();
                    if (targetCdpNodeId == -1) {
                        LogUtils.debugf((Object)this, (String)"run: no node id found for IP address %s.  Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found nodeid/CDP target ipaddress: %d:%s", (Object[])new Object[]{targetCdpNodeId, InetAddressUtils.str((InetAddress)targetIpAddr)});
                    if (targetCdpNodeId == curCdpNodeId) {
                        LogUtils.debugf((Object)this, (String)"run: node id found for IP address %s is itself.  Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    int cdpDestIfindex = cdpInterface.getCdpTargetIfIndex();
                    if (cdpDestIfindex < 0) {
                        LogUtils.warnf((Object)this, (String)"run: found not valid CDP destination IfIndex %d.  Skipping.", (Object[])new Object[]{cdpDestIfindex});
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: found CDP target ifindex %d", (Object[])new Object[]{cdpDestIfindex});
                    LogUtils.debugf((Object)this, (String)"run: parsing CDP link: nodeid=%d ifindex=%d nodeparentid=%d parentifindex=%d", (Object[])new Object[]{curCdpNodeId, cdpIfIndex, targetCdpNodeId, cdpDestIfindex});
                    boolean add = false;
                    if (curNode.isBridgeNode() && this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.m_bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetNode, cdpDestIfindex);
                        LogUtils.debugf((Object)this, (String)"run: both node are bridge nodes! Adding: %b", (Object[])new Object[]{add});
                    } else if (curNode.isBridgeNode()) {
                        LogUtils.debugf((Object)this, (String)"run: source node is bridge node, target node is not bridge node! Adding: %b", (Object[])new Object[]{add});
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetCdpNodeId);
                    } else if (this.isBridgeNode(targetCdpNodeId)) {
                        LogUtils.debugf((Object)this, (String)"run: source node is not bridge node, target node is bridge node! Adding: %b", (Object[])new Object[]{add});
                        targetNode = this.m_bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(targetNode, cdpDestIfindex, curCdpNodeId);
                    } else {
                        LogUtils.debugf((Object)this, (String)"run: no node is bridge node! Adding CDP link", (Object[])new Object[0]);
                        add = true;
                    }
                    if (!add) continue;
                    NodeToNodeLink lk = new NodeToNodeLink(targetCdpNodeId, cdpDestIfindex);
                    lk.setNodeparentid(curCdpNodeId);
                    lk.setParentifindex(cdpIfIndex);
                    LogUtils.infof((Object)this, (String)"run: CDP link added: %s", (Object[])new Object[]{lk.toString()});
                    this.addNodetoNodeLink(lk);
                }
                LogUtils.infof((Object)this, (String)"run: done parsing nodeid %d IP address %s with %d CDP interfaces.", (Object[])new Object[]{curCdpNodeId, curCdpIpAddr, curNode.getCdpInterfaces().size()});
            }
            if (this.m_cdpNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: done finding links among nodes using Cisco Discovery Protocol", (Object[])new Object[0]);
            }
            if (this.m_bridgeNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: trying to find backbone ethernet links among bridge nodes using Spanning Tree Protocol", (Object[])new Object[0]);
            }
            for (LinkableNode curNode : this.m_bridgeNodes.values()) {
                curNodeId = curNode.getNodeId();
                InetAddress cupIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.infof((Object)this, (String)"run: parsing bridge nodeid %d IP address %s with %d VLANs", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
                for (Map.Entry entry : curNode.getStpInterfaces().entrySet()) {
                    String vlan = (String)entry.getKey();
                    String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                    LogUtils.debugf((Object)this, (String)"run: found bridge identifier %s", (Object[])new Object[]{curBaseBridgeAddress});
                    String designatedRoot = null;
                    if (!curNode.hasStpRoot(vlan)) {
                        LogUtils.debugf((Object)this, (String)"run: designated root bridge identifier not found. Skipping %s", (Object[])new Object[]{curBaseBridgeAddress});
                        continue;
                    }
                    designatedRoot = curNode.getStpRoot(vlan);
                    if (designatedRoot == null || designatedRoot.equals("0000000000000000")) {
                        LogUtils.warnf((Object)this, (String)"run: designated root is invalid, skipping: %s", (Object[])new Object[]{designatedRoot});
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                        LogUtils.debugf((Object)this, (String)"run: STP designated root is the bridge itself. Skipping.", (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: STP designated root is another bridge. %s Parsing STP Interface", (Object[])new Object[]{designatedRoot});
                    for (OnmsStpInterface stpIface : (List)entry.getValue()) {
                        int stpbridgeport = stpIface.getBridgePort();
                        if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                            LogUtils.debugf((Object)this, (String)"run: bridge port %d already found. Skipping.", (Object[])new Object[]{stpbridgeport});
                            continue;
                        }
                        String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                        String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                        LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with STP designated bridge %s and STP designated port %s", (Object[])new Object[]{stpbridgeport, stpPortDesignatedBridge, stpPortDesignatedPort});
                        if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                            LogUtils.warnf((Object)this, (String)"run: designated bridge is invalid, skipping: %s", (Object[])new Object[]{stpPortDesignatedBridge});
                            continue;
                        }
                        if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                            LogUtils.debugf((Object)this, (String)"run: designated bridge for port %d is bridge itself", (Object[])new Object[]{stpbridgeport});
                            continue;
                        }
                        if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                            LogUtils.warnf((Object)this, (String)"run: designated port is invalid: %s", (Object[])new Object[]{stpPortDesignatedPort});
                            continue;
                        }
                        int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                        LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                        if (designatedNode == null) {
                            LogUtils.debugf((Object)this, (String)"run: no nodeid found for STP bridge address %s. Nothing to save.", (Object[])new Object[]{stpPortDesignatedBridge});
                            continue;
                        }
                        int designatednodeid = designatedNode.getNodeId();
                        LogUtils.debugf((Object)this, (String)"run: found designated nodeid %d", (Object[])new Object[]{designatednodeid});
                        if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) {
                            LogUtils.debugf((Object)this, (String)"run: other bridge found between nodes. No links to save!", (Object[])new Object[0]);
                            continue;
                        }
                        int curIfIndex = curNode.getIfindex(stpbridgeport);
                        if (curIfIndex == -1) {
                            LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on node: %s", (Object[])new Object[]{curNode.toString()});
                            continue;
                        }
                        int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                        if (designatedifindex == -1) {
                            LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on designated node: %s", (Object[])new Object[]{designatedNode.toString()});
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to bridge %d.", (Object[])new Object[]{curNodeId, stpbridgeport});
                        curNode.addBackBoneBridgePorts(stpbridgeport);
                        this.m_bridgeNodes.put(new Integer(curNodeId), curNode);
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to helper class BB port bridge port %d.", (Object[])new Object[]{designatednodeid, designatedbridgeport});
                        designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                        this.m_bridgeNodes.put(new Integer(designatednodeid), designatedNode);
                        LogUtils.debugf((Object)this, (String)"run: adding links on BB bridge port %d", (Object[])new Object[]{designatedbridgeport});
                        this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(designatednodeid);
                        lk.setParentifindex(designatedifindex);
                        LogUtils.infof((Object)this, (String)("run: saving STP bridge link: " + lk.toString()), (Object[])new Object[0]);
                        this.addNodetoNodeLink(lk);
                    }
                }
                LogUtils.infof((Object)this, (String)"run: done parsing bridge nodeid %d IP address %s with %d VLANs", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)cupIpAddr), curNode.getStpInterfaces().size()});
            }
            if (this.m_bridgeNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: done finding backbone ethernet links among bridge nodes using Spanning Tree Protocol", (Object[])new Object[0]);
            }
            if (this.m_bridgeNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: trying to find links using MAC Address Forwarding Table", (Object[])new Object[0]);
            }
            for (LinkableNode curNode : this.m_bridgeNodes.values()) {
                curNodeId = curNode.getNodeId();
                LogUtils.infof((Object)this, (String)"run: parsing bridge node with ID %d", (Object[])new Object[]{curNodeId});
                for (Integer curBridgePort : curNode.getPortMacs().keySet()) {
                    LogUtils.debugf((Object)this, (String)"run: parsing bridge port %d with MAC address %s", (Object[])new Object[]{curBridgePort, curNode.getMacAddressesOnBridgePort(curBridgePort).toString()});
                    if (curNode.isBackBoneBridgePort(curBridgePort)) {
                        LogUtils.debugf((Object)this, (String)"run: Port %d is a backbone bridge port. Skipping.", (Object[])new Object[]{curBridgePort});
                        continue;
                    }
                    int n = curNode.getIfindex(curBridgePort);
                    if (n == -1) {
                        LogUtils.warnf((Object)this, (String)"run: got invalid ifIndex on bridge port %d", (Object[])new Object[]{curBridgePort});
                        continue;
                    }
                    Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                    List<LinkableNode> bridgesOnPort = this.getBridgesFromMacs(macs);
                    if (bridgesOnPort.isEmpty()) {
                        LogUtils.debugf((Object)this, (String)"run: no bridge info found on port %d. Saving MACs.", (Object[])new Object[]{curBridgePort});
                        this.addLinks(macs, curNodeId, n);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)"run: bridge info found on port %d. Finding nearest.", (Object[])new Object[]{curBridgePort});
                    for (LinkableNode endNode : bridgesOnPort) {
                        int endNodeid = endNode.getNodeId();
                        int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                        if (endBridgePort == -1) {
                            LogUtils.warnf((Object)this, (String)"run: no valid port found on bridge nodeid %d for node bridge identifiers nodeid %d. Skipping.", (Object[])new Object[]{endNodeid, curNodeId});
                            continue;
                        }
                        boolean isTargetNode = this.isNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort);
                        if (!isTargetNode) continue;
                        int endIfindex = endNode.getIfindex(endBridgePort);
                        if (endIfindex == -1) {
                            LogUtils.warnf((Object)this, (String)"run: got invalid ifindex on designated bridge port %d", (Object[])new Object[]{endBridgePort});
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding backbone port %d to bridge", (Object[])new Object[]{curNodeId, curBridgePort});
                        curNode.addBackBoneBridgePorts(curBridgePort);
                        this.m_bridgeNodes.put(curNodeId, curNode);
                        LogUtils.debugf((Object)this, (String)"run: backbone port found for node %d. Adding to helper class backbone port bridge port %d", (Object[])new Object[]{endNodeid, endBridgePort});
                        endNode.addBackBoneBridgePorts(endBridgePort);
                        this.m_bridgeNodes.put(endNodeid, endNode);
                        this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, n);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, n);
                        lk.setNodeparentid(endNodeid);
                        lk.setParentifindex(endIfindex);
                        LogUtils.infof((Object)this, (String)("run: saving bridge link: " + lk.toString()), (Object[])new Object[0]);
                        this.addNodetoNodeLink(lk);
                    }
                }
                LogUtils.infof((Object)this, (String)"run: done parsing bridge node with ID %d", (Object[])new Object[]{curNodeId});
            }
            if (this.m_bridgeNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: done finding links using MAC Address Forwarding Table", (Object[])new Object[0]);
            }
            if (this.m_routerNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: finding non-ethernet links on Router nodes", (Object[])new Object[0]);
            }
            for (LinkableNode curNode : this.m_routerNodes) {
                curNodeId = curNode.getNodeId();
                InetAddress curIpAddr = curNode.getSnmpPrimaryIpAddr();
                LogUtils.infof((Object)this, (String)"run: parsing router node with ID %d IP address %s and %d router interfaces", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
                for (RouterInterface routerInterface : curNode.getRouteInterfaces()) {
                    LogUtils.debugf((Object)this, (String)("run: parsing RouterInterface: " + routerInterface.toString()), (Object[])new Object[0]);
                    if (routerInterface.getMetric() == -1) {
                        LogUtils.warnf((Object)this, (String)"run: Router interface has invalid metric %d. Skipping.", (Object[])new Object[]{routerInterface.getMetric()});
                        continue;
                    }
                    if (this.forceIpRouteDiscoveryOnEtherNet) {
                        LogUtils.debugf((Object)this, (String)"run: forceIpRouteDiscoveryOnEtherNet is set, skipping validation of the SNMP interface type", (Object[])new Object[0]);
                    } else {
                        int snmpiftype = routerInterface.getSnmpiftype();
                        LogUtils.debugf((Object)this, (String)("run: force IP route discovery getting SnmpIfType: " + snmpiftype), (Object[])new Object[0]);
                        if (snmpiftype == 6) {
                            LogUtils.debugf((Object)this, (String)"run: Ethernet interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                            continue;
                        }
                        if (snmpiftype == 53) {
                            LogUtils.debugf((Object)this, (String)"run: PropVirtual interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                            continue;
                        }
                        if (snmpiftype == 135) {
                            LogUtils.debugf((Object)this, (String)"run: Layer2 VLAN interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                            continue;
                        }
                        if (snmpiftype == 136) {
                            LogUtils.debugf((Object)this, (String)"run: Layer3 VLAN interface for nodeid %d. Skipping.", (Object[])new Object[]{curNodeId});
                            continue;
                        }
                        if (snmpiftype == -1) {
                            LogUtils.debugf((Object)this, (String)"run: interface on node %d has unknown snmpiftype %d. Skipping.", (Object[])new Object[]{curNodeId, snmpiftype});
                            continue;
                        }
                    }
                    InetAddress nexthop = routerInterface.getNextHop();
                    String hostAddress = InetAddressUtils.str((InetAddress)nexthop);
                    if (hostAddress.equals("0.0.0.0")) {
                        LogUtils.debugf((Object)this, (String)"run: nexthop address is broadcast address %s. Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    if (nexthop.isLoopbackAddress()) {
                        LogUtils.debugf((Object)this, (String)"run: nexthop address is localhost address %s. Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    if (!this.m_linkd.isInterfaceInPackage(nexthop, this.getPackageName())) {
                        LogUtils.debugf((Object)this, (String)"run: nexthop address is not in package %s/%s. Skipping.", (Object[])new Object[]{hostAddress, this.getPackageName()});
                        continue;
                    }
                    int nextHopNodeid = routerInterface.getNextHopNodeid();
                    if (nextHopNodeid == -1) {
                        LogUtils.debugf((Object)this, (String)"run: no node id found for IP next hop address %s. Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    if (nextHopNodeid == curNodeId) {
                        LogUtils.debugf((Object)this, (String)"run: node id found for IP next hop address %s is itself. Skipping.", (Object[])new Object[]{hostAddress});
                        continue;
                    }
                    int ifindex = routerInterface.getIfindex();
                    if (ifindex == 0) {
                        LogUtils.debugf((Object)this, (String)"run: route interface has ifindex %d, trying to get ifIndex from nextHopNet: %s", (Object[])new Object[]{ifindex, routerInterface.getNextHopNet()});
                        ifindex = DiscoveryLink.getIfIndexFromRouter(curNode, routerInterface.getNextHopNet());
                        if (ifindex == -1) {
                            LogUtils.debugf((Object)this, (String)"run: found not correct ifindex %d. Skipping.", (Object[])new Object[]{ifindex});
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)"run: found correct ifindex %d.", (Object[])new Object[]{ifindex});
                    }
                    NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routerInterface.getNextHopIfindex());
                    lk.setNodeparentid(curNodeId);
                    lk.setParentifindex(ifindex);
                    LogUtils.infof((Object)this, (String)("run: saving route link: " + lk.toString()), (Object[])new Object[0]);
                    this.addNodetoNodeLink(lk);
                }
                LogUtils.infof((Object)this, (String)"run: done parsing router node with ID %d IP address %s and %d router interfaces", (Object[])new Object[]{curNodeId, InetAddressUtils.str((InetAddress)curIpAddr), curNode.getRouteInterfaces().size()});
            }
            if (this.m_routerNodes.size() > 0) {
                LogUtils.infof((Object)this, (String)"run: done finding non-ethernet links on Router nodes", (Object[])new Object[0]);
            }
            this.m_bridgeNodes.clear();
            this.m_routerNodes.clear();
            this.m_cdpNodes.clear();
            this.m_macsParsed.clear();
            this.macsExcluded.clear();
            this.m_macToAtinterface.clear();
            this.m_atNodes.clear();
            this.m_linkd.updateDiscoveryLinkCollection(this);
            this.m_links.clear();
            this.m_maclinks.clear();
        }
        this.isRunned = true;
        this.reschedule();
    }

    protected void populateMacToAtInterface() {
        LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: using atNodes to populate macToAtinterface", (Object[])new Object[0]);
        for (LinkableNode curNode : this.m_atNodes) {
            for (OnmsAtInterface at : curNode.getAtInterfaces()) {
                int nodeid = at.getNode().getId();
                String macAddress = at.getMacAddress();
                LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: Parsing AtInterface nodeid/ipaddr/macaddr: %d/%s/%s", (Object[])new Object[]{nodeid, InetAddressUtils.str((InetAddress)at.getIpAddress()), macAddress});
                if (!this.m_linkd.isInterfaceInPackage(at.getIpAddress(), this.getPackageName())) {
                    LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: at interface: %s does not belong to package: %s! Not adding to discoverable atinterface.", (Object[])new Object[]{InetAddressUtils.str((InetAddress)at.getIpAddress()), this.getPackageName()});
                    this.macsExcluded.add(macAddress);
                    continue;
                }
                if (this.isMacIdentifierOfBridgeNode(macAddress)) {
                    LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: AtInterface %s belongs to bridge node! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                    this.macsExcluded.add(macAddress);
                    continue;
                }
                if (macAddress.indexOf("00000c07ac") == 0 || macAddress.indexOf("00000c9ff") == 0) {
                    LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: AtInterface %s is Cisco HSRP address! Not adding to discoverable atinterface.", (Object[])new Object[]{macAddress});
                    this.macsExcluded.add(macAddress);
                    continue;
                }
                List<OnmsAtInterface> ats = this.m_macToAtinterface.get(macAddress);
                if (ats == null) {
                    ats = new ArrayList<OnmsAtInterface>();
                }
                LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: Adding to discoverable atinterface.", (Object[])new Object[0]);
                ats.add(at);
                this.m_macToAtinterface.put(macAddress, ats);
                LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: MAC %s now has atinterface reference: %d", (Object[])new Object[]{macAddress, ats.size()});
            }
        }
        LogUtils.debugf((Object)this, (String)"populateMacToAtInterface: end populateMacToAtinterface", (Object[])new Object[0]);
    }

    private static int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.m_routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isCdpNode(int nodeid) {
        for (LinkableNode curNode : this.m_cdpNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndBridgePort(LinkableNode bridge, int bridgeport) {
        Set<String> macsOnBridge = bridge.getMacAddressesOnBridgePort(bridgeport);
        if (macsOnBridge == null || macsOnBridge.isEmpty()) {
            return true;
        }
        for (String macaddr : macsOnBridge) {
            if (!this.isMacIdentifierOfBridgeNode(macaddr)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        boolean hasbridge2forwardingRule = false;
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return false;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return false;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1)) {
                hasbridge2forwardingRule = true;
                continue;
            }
            if (bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return false;
        }
        return hasbridge2forwardingRule;
    }

    private Set<String> getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private List<LinkableNode> getBridgesFromMacs(Set<String> macs) {
        ArrayList<LinkableNode> bridges = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.add(curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: parsing bridge identifier " + curBridgeIdentifier), (Object[])new Object[0]);
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                for (Integer p : endBridge.getBridgePortsFromMac(curBridgeIdentifier)) {
                    port = p;
                    if (endBridge.isBackBoneBridgePort(port)) {
                        LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: found backbone bridge port " + port + " .... Skipping."), (Object[])new Object[0]);
                        continue;
                    }
                    if (port == -1) {
                        LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: no port found on bridge nodeid " + endBridge.getNodeId() + " for node bridge identifiers nodeid " + startBridge.getNodeId() + " . .....Skipping."), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: using MAC address table found bridge port " + port + " on node " + endBridge.getNodeId()), (Object[])new Object[0]);
                    return port;
                }
                continue;
            }
            LogUtils.debugf((Object)this, (String)("getBridgePortOnEndBridge: bridge identifier not found on node " + endBridge.getNodeId()), (Object[])new Object[0]);
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval + this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.m_links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.m_maclinks.toArray(new MacToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("unschedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, int nodeid2) {
        int bridgeport = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: node/backbone bridge port " + node1.getNodeId() + "/" + bridgeport + " already parsed. Skipping."), (Object[])new Object[0]);
            return false;
        }
        if (!this.isEndBridgePort(node1, bridgeport)) {
            LogUtils.warnf((Object)this, (String)"parseCdpLinkOn: link cannot be saved. Skipping.", (Object[])new Object[0]);
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport);
        this.m_bridgeNodes.put(node1.getNodeId(), node1);
        Set<String> macs = node1.getMacAddressesOnBridgePort(bridgeport);
        this.addLinks(macs, node1.getNodeId(), ifindex1);
        return true;
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, LinkableNode node2, int ifindex2) {
        int bridgeport1 = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport1)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: backbone bridge port " + bridgeport1 + " already parsed. Skipping."), (Object[])new Object[0]);
            return false;
        }
        int bridgeport2 = node2.getBridgePort(ifindex2);
        if (node2.isBackBoneBridgePort(bridgeport2)) {
            LogUtils.debugf((Object)this, (String)("parseCdpLinkOn: backbone bridge port " + bridgeport2 + " already parsed. Skipping."), (Object[])new Object[0]);
            return false;
        }
        if (!this.isNearestBridgeLink(node1, bridgeport1, node2, bridgeport2)) {
            LogUtils.debugf((Object)this, (String)"parseCdpLinkOn: link found not on nearest. Skipping.", (Object[])new Object[0]);
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport1);
        this.m_bridgeNodes.put(node1.getNodeId(), node1);
        node2.addBackBoneBridgePorts(bridgeport2);
        this.m_bridgeNodes.put(node2.getNodeId(), node2);
        LogUtils.debugf((Object)this, (String)"parseCdpLinkOn: Adding node on links.", (Object[])new Object[0]);
        this.addLinks(this.getMacsOnBridgeLink(node1, bridgeport1, node2, bridgeport2), node1.getNodeId(), ifindex1);
        return true;
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            LogUtils.warnf((Object)this, (String)"addNodetoNodeLink: node link is null.", (Object[])new Object[0]);
            return;
        }
        for (NodeToNodeLink curNnLink : this.m_links) {
            if (!curNnLink.equals(nnlink)) continue;
            LogUtils.infof((Object)this, (String)"addNodetoNodeLink: link %s exists, not adding", (Object[])new Object[]{nnlink.toString()});
            return;
        }
        LogUtils.debugf((Object)this, (String)"addNodetoNodeLink: adding link %s", (Object[])new Object[]{nnlink.toString()});
        this.m_links.add(nnlink);
    }

    private void addLinks(Set<String> macs, int nodeid, int ifindex) {
        if (macs == null || macs.isEmpty()) {
            LogUtils.debugf((Object)this, (String)"addLinks: MAC address list on link is empty.", (Object[])new Object[0]);
        } else {
            for (String curMacAddress : macs) {
                if (this.m_macsParsed.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: MAC address " + curMacAddress + " just found on other bridge port! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.macsExcluded.contains(curMacAddress)) {
                    LogUtils.warnf((Object)this, (String)("addLinks: MAC address " + curMacAddress + " is excluded from discovery package! Skipping..."), (Object[])new Object[0]);
                    continue;
                }
                if (this.m_macToAtinterface.containsKey(curMacAddress)) {
                    List<OnmsAtInterface> ats = this.m_macToAtinterface.get(curMacAddress);
                    for (OnmsAtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNode().getId(), at.getIfIndex());
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                } else {
                    LogUtils.debugf((Object)this, (String)"addLinks: not find nodeid for ethernet MAC address %s found on node/ifindex %d/%d", (Object[])new Object[]{curMacAddress, nodeid, ifindex});
                    MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                    lMac.setNodeparentid(nodeid);
                    lMac.setParentifindex(ifindex);
                    this.m_maclinks.add(lMac);
                }
                this.m_macsParsed.add(curMacAddress);
            }
        }
    }

    @Override
    public boolean equals(ReadyRunnable r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(r.getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable Discovery Link discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/package: " + this.discoveryUsingBridge() + "/" + this.discoveryUsingCdp() + "/" + this.discoveryUsingRoutes() + "/" + this.getPackageName();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBridgeNodes() {
        LogUtils.debugf((Object)this, (String)"parseBridgeNodes: searching bridge port for bridge identifier not yet already found. Iterating on bridge nodes.", (Object[])new Object[0]);
        ArrayList<LinkableNode> bridgenodeschanged = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing bridge: %d/%s", (Object[])new Object[]{curNode.getNodeId(), curNode.getSnmpPrimaryIpAddr()});
            List<String> macs = this.getNotAlreadyFoundMacsOnNode(curNode);
            if (macs.isEmpty()) continue;
            SnmpAgentConfig agentConfig = null;
            String className = null;
            LinkdConfig linkdConfig = this.m_linkd.getLinkdConfig();
            linkdConfig.getReadLock().lock();
            try {
                InetAddress addr;
                boolean useVlan = linkdConfig.isVlanDiscoveryEnabled();
                if (linkdConfig.getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                    useVlan = linkdConfig.getPackage(this.getPackageName()).getEnableVlanDiscovery();
                }
                if (useVlan && linkdConfig.hasClassName(curNode.getSysoid())) {
                    className = linkdConfig.getVlanClassName(curNode.getSysoid());
                }
                if ((addr = curNode.getSnmpPrimaryIpAddr()) == null) {
                    LogUtils.errorf((Object)this, (String)"parseBridgeNodes: Failed to load SNMP parameter from SNMP configuration file.", (Object[])new Object[0]);
                    return;
                }
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(addr);
                String community = agentConfig.getReadCommunity();
                for (String mac : macs) {
                    LogUtils.debugf((Object)this, (String)"parseBridgeNodes: parsing MAC: %s", (Object[])new Object[]{mac});
                    if (className != null && (className.equals(CiscoVlanTable.class.getName()) || className.equals(IntelVlanTable.class.getName()))) {
                        for (OnmsVlan vlan : curNode.getVlans()) {
                            if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                                LogUtils.debugf((Object)this, (String)"parseBridgeNodes: skipping VLAN: %s", (Object[])new Object[]{vlan.getVlanName()});
                                continue;
                            }
                            agentConfig.setReadCommunity(community + "@" + vlan.getVlanId());
                            curNode = DiscoveryLink.collectMacAddress(this, agentConfig, curNode, mac, vlan.getVlanId());
                            agentConfig.setReadCommunity(community);
                        }
                        continue;
                    }
                    int vlan = 1;
                    if (useVlan) {
                        vlan = 0;
                    }
                    curNode = DiscoveryLink.collectMacAddress(this, agentConfig, curNode, mac, vlan);
                }
                bridgenodeschanged.add(curNode);
            }
            finally {
                linkdConfig.getReadLock().unlock();
            }
        }
        for (LinkableNode node : bridgenodeschanged) {
            this.m_bridgeNodes.put(node.getNodeId(), node);
        }
    }

    private static LinkableNode collectMacAddress(DiscoveryLink discoveryLink, SnmpAgentConfig agentConfig, LinkableNode node, String mac, int vlan) {
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: finding entry in bridge forwarding table for MAC on node: %s/%d", (Object[])new Object[]{mac, node.getNodeId()});
        int bridgeport = coll.getBridgePort();
        if (bridgeport > 0 && coll.getBridgePortStatus() == 3) {
            node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: found MAC on bridge port: %d", (Object[])new Object[]{bridgeport});
        } else {
            bridgeport = coll.getQBridgePort();
            if (bridgeport > 0 && coll.getQBridgePortStatus() == 3) {
                node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
                LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: found MAC on bridge port: %d", (Object[])new Object[]{bridgeport});
            } else {
                LogUtils.debugf((Object)discoveryLink, (String)"collectMacAddress: MAC not found: %d", (Object[])new Object[]{bridgeport});
            }
        }
        return node;
    }

    private List<String> getNotAlreadyFoundMacsOnNode(LinkableNode node) {
        LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Searching Not Yet Found Bridge Identifier Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        ArrayList<String> macs = new ArrayList<String>();
        for (LinkableNode curNode : this.m_bridgeNodes.values()) {
            if (node.getNodeId() == curNode.getNodeId()) continue;
            for (String curMac : curNode.getBridgeIdentifiers()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Found a node/Bridge Identifier %d/%s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curNode.getNodeId(), curMac, node.getNodeId()});
                macs.add(curMac);
            }
        }
        LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Searching Not Yet Found MAC Address Occurrence on Node: %d", (Object[])new Object[]{node.getNodeId()});
        for (String curMac : this.m_macToAtinterface.keySet()) {
            if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
            LogUtils.debugf((Object)this, (String)"getNotAlreadyFoundMacsOnNode: Found a MAC Address %s that was not found in bridge forwarding table for bridge node: %d", (Object[])new Object[]{curMac, node.getNodeId()});
            macs.add(curMac);
        }
        return macs;
    }

    public boolean isEnableDownloadDiscovery() {
        return this.enableDownloadDiscovery;
    }

    public void setEnableDownloadDiscovery(boolean enableDownloaddiscovery) {
        this.enableDownloadDiscovery = enableDownloaddiscovery;
    }

    public boolean isForceIpRouteDiscoveryOnEtherNet() {
        return this.forceIpRouteDiscoveryOnEtherNet;
    }

    public void setForceIpRouteDiscoveryOnEtherNet(boolean forceIpRouteDiscoveryOnEtherNet) {
        this.forceIpRouteDiscoveryOnEtherNet = forceIpRouteDiscoveryOnEtherNet;
    }
}

