/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.eventd.processor.EventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class DefaultEventHandlerImpl
implements InitializingBean,
EventHandler {
    private List<EventProcessor> m_eventProcessors;

    @Override
    public EventHandlerRunnable createRunnable(Log eventLog) {
        return new EventHandlerRunnable(eventLog);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventProcessors != null ? 1 : 0) != 0, (String)"property eventPersisters must be set");
    }

    public List<EventProcessor> getEventProcessors() {
        return this.m_eventProcessors;
    }

    public void setEventProcessors(List<EventProcessor> eventProcessors) {
        this.m_eventProcessors = eventProcessors;
    }

    public class EventHandlerRunnable
    implements Runnable {
        private Log m_eventLog;

        public EventHandlerRunnable(Log eventLog) {
            Assert.notNull((Object)eventLog, (String)"eventLog argument must not be null");
            this.m_eventLog = eventLog;
        }

        @Override
        public void run() {
            Events events = this.m_eventLog.getEvents();
            if (events == null || events.getEventCount() <= 0) {
                return;
            }
            block3: for (Event event : events.getEventCollection()) {
                if (DefaultEventHandlerImpl.this.log().isDebugEnabled()) {
                    String uuid = event.getUuid();
                    DefaultEventHandlerImpl.this.log().debug("Event {");
                    DefaultEventHandlerImpl.this.log().debug("  uuid  = " + (uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                    DefaultEventHandlerImpl.this.log().debug("  uei   = " + event.getUei());
                    DefaultEventHandlerImpl.this.log().debug("  src   = " + event.getSource());
                    DefaultEventHandlerImpl.this.log().debug("  iface = " + event.getInterface());
                    DefaultEventHandlerImpl.this.log().debug("  time  = " + event.getTime());
                    if (event.getParmCollection().size() > 0) {
                        DefaultEventHandlerImpl.this.log().debug("  parms {");
                        for (Parm parm : event.getParmCollection()) {
                            if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                            DefaultEventHandlerImpl.this.log().debug("    (" + parm.getParmName().trim() + ", " + parm.getValue().getContent().trim() + ")");
                        }
                        DefaultEventHandlerImpl.this.log().debug("  }");
                    }
                    DefaultEventHandlerImpl.this.log().debug("}");
                }
                for (EventProcessor eventProcessor : DefaultEventHandlerImpl.this.m_eventProcessors) {
                    try {
                        eventProcessor.process(this.m_eventLog.getHeader(), event);
                    }
                    catch (SQLException e) {
                        DefaultEventHandlerImpl.this.log().warn("Unable to process event using processor " + eventProcessor + "; not processing with any later processors.  Exception: " + e, (Throwable)e);
                        continue block3;
                    }
                    catch (Throwable t) {
                        DefaultEventHandlerImpl.this.log().warn("Unknown exception processing event with processor " + eventProcessor + "; not processing with any later processors.  Exception: " + t, t);
                        continue block3;
                    }
                }
            }
        }
    }
}

