/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationManager;

public class NotificationFactory
extends NotificationManager {
    private static NotificationFactory instance;
    protected File m_notifConfFile;
    private static boolean initialized;
    private File m_noticeConfFile;
    private long m_lastModified;

    private NotificationFactory() {
        super(NotifdConfigFactory.getInstance(), DataSourceFactory.getInstance());
    }

    public static synchronized NotificationFactory getInstance() {
        if (!initialized) {
            return null;
        }
        return instance;
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException, ClassNotFoundException, SQLException, PropertyVetoException {
        if (!initialized) {
            DataSourceFactory.init();
            instance = new NotificationFactory();
            instance.reload();
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws IOException, MarshalException, ValidationException {
        this.m_noticeConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NOTIFICATIONS_CONF_FILE_NAME);
        FileInputStream configIn = null;
        try {
            configIn = new FileInputStream(this.m_noticeConfFile);
            this.m_lastModified = this.m_noticeConfFile.lastModified();
            this.parseXML(configIn);
        }
        finally {
            if (configIn != null) {
                IOUtils.closeQuietly((InputStream)configIn);
            }
        }
    }

    @Override
    protected void saveXML(String xmlString) throws IOException {
        if (xmlString != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_noticeConfFile), "UTF-8");
            fileWriter.write(xmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    @Override
    public void update() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_noticeConfFile.lastModified()) {
            this.reload();
        }
    }

    static {
        initialized = false;
    }
}

