/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.archiver.events.EventsArchiverConfiguration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class EventsArchiverConfigFactory {
    private static EventsArchiverConfigFactory m_singleton = null;
    private EventsArchiverConfiguration m_config;
    private static boolean m_loaded = false;

    private EventsArchiverConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this.m_config = (EventsArchiverConfiguration)CastorUtils.unmarshal(EventsArchiverConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENTS_ARCHIVER_CONFIG_FILE_NAME);
        m_singleton = new EventsArchiverConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        EventsArchiverConfigFactory.init();
    }

    public static synchronized EventsArchiverConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized String getArchiveAge() {
        return this.m_config.getArchiveAge();
    }

    public synchronized String getSeparator() {
        return this.m_config.getSeparator();
    }
}

