/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpResult;

public class SnmpIfCollector
extends AggregateTracker {
    private Map<SnmpInstId, SNMPCollectorEntry> m_results = new TreeMap<SnmpInstId, SNMPCollectorEntry>();
    private String m_primaryIf;
    private List<SnmpAttributeType> m_objList;
    private SnmpCollectionSet m_collectionSet;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append("@");
        buffer.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        buffer.append(": Primary Interface: " + this.m_primaryIf);
        buffer.append(", object list: " + this.m_objList);
        buffer.append(", CollectionSet: ");
        if (this.m_collectionSet == null) {
            buffer.append("(null)");
        } else {
            buffer.append(this.m_collectionSet.getClass().getName());
            buffer.append("@");
            buffer.append(Integer.toHexString(this.m_collectionSet.hashCode()));
        }
        return buffer.toString();
    }

    public SnmpIfCollector(InetAddress address, List<SnmpAttributeType> objList, SnmpCollectionSet collectionSet) {
        super(SnmpAttributeType.getCollectionTrackers(objList));
        SnmpIfCollector.log().debug("COLLECTING on list of " + objList.size() + " items");
        SnmpIfCollector.log().debug("List is " + objList);
        this.m_primaryIf = InetAddressUtils.str((InetAddress)address);
        this.m_objList = objList;
        this.m_collectionSet = collectionSet;
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(SnmpIfCollector.class);
    }

    public List<SNMPCollectorEntry> getEntries() {
        return new ArrayList<SNMPCollectorEntry>(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        SnmpIfCollector.log().warn(this.m_primaryIf + ": genErr collecting ifData. " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        SnmpIfCollector.log().info(this.m_primaryIf + ": noSuchName collecting ifData. " + msg);
    }

    protected void reportTooBigErr(String msg) {
        SnmpIfCollector.log().info(this.m_primaryIf + ": request tooBig. " + msg);
    }

    protected void storeResult(SnmpResult res) {
        if (res.getBase().toString().equals(".1.3.6.1.2.1.31.1.1.1.18") && (res.getValue().isNull() || res.getValue().toDisplayString() == null || res.getValue().toDisplayString().equals(""))) {
            SnmpIfCollector.log().debug("Skipping storeResult. Null or zero length ifAlias");
            return;
        }
        SNMPCollectorEntry entry = this.m_results.get(res.getInstance());
        if (entry == null) {
            SnmpIfCollector.log().debug("Creating new SNMPCollectorEntry entry");
            entry = new SNMPCollectorEntry(this.m_objList, this.m_collectionSet);
            this.m_results.put(res.getInstance(), entry);
        }
        entry.storeResult(res);
    }

    public boolean hasData() {
        return !this.m_results.isEmpty();
    }

    public CollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }
}

