/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;

public class ForceRescanState {
    private CollectionAgent m_agent;
    private EventProxy m_eventProxy;
    private boolean m_forceRescanSent = false;

    public ForceRescanState(CollectionAgent agent, EventProxy eventProxy) {
        this.m_agent = agent;
        this.m_eventProxy = eventProxy;
    }

    public EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public Event createForceResanEvent() {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/forceRescan", "SnmpCollector");
        bldr.setNodeid((long)this.m_agent.getNodeId());
        bldr.setInterface(this.m_agent.getInetAddress());
        bldr.setService("SNMP");
        bldr.setHost(InetAddressUtils.getLocalHostName());
        return bldr.getEvent();
    }

    public CollectionAgent getAgent() {
        return this.m_agent;
    }

    void sendForceRescanEvent() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("generateForceRescanEvent: interface = " + this.getAgent().getHostAddress());
        }
        try {
            this.getEventProxy().send(this.createForceResanEvent());
        }
        catch (EventProxyException e) {
            this.log().error("generateForceRescanEvent: Unable to send forceRescan event.", (Throwable)e);
        }
    }

    void rescanIndicated() {
        if (!this.m_forceRescanSent) {
            this.sendForceRescanEvent();
            this.m_forceRescanSent = true;
        }
    }
}

