/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

public final class Pop3Plugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "POP3";
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug("Pop3Plugin: connected to host: " + host + " on port: " + port);
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringTokenizer t = new StringTokenizer(lineRdr.readLine());
                if (!t.nextToken().equals("+OK")) continue;
                String cmd = "QUIT\r\n";
                socket.getOutputStream().write(cmd.getBytes());
                t = new StringTokenizer(lineRdr.readLine());
                if (!t.nextToken().equals("+OK")) continue;
                isAServer = true;
                continue;
            }
            catch (ConnectException cE) {
                log.debug("Pop3Plugin: Connection refused to " + InetAddressUtils.str((InetAddress)host) + ":" + port);
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info("Pop3Plugin: No route to host " + InetAddressUtils.str((InetAddress)host) + " was available", (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug("Pop3Plugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                isAServer = false;
                log.info("Pop3Plugin: An unexpected I/O exception occured contacting host " + InetAddressUtils.str((InetAddress)host), (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                log.error("Pop3Plugin: An undeclared throwable exception was caught contacting host " + InetAddressUtils.str((InetAddress)host), t);
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 110, 0, 5000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int retries = 0;
        int timeout = 5000;
        int port = 110;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)110);
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", port);
        }
        return result;
    }
}

