/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;

public final class DbSnmpInterfaceEntry {
    private static final String SQL_LOAD_REC = "SELECT snmpIpAdEntNetMask, snmpPhysAddr, snmpIfDescr, snmpIfType, snmpIfName, snmpIfSpeed, snmpIfAdminStatus, snmpIfOperStatus, snmpIfAlias, snmpCollect FROM snmpInterface WHERE nodeID = ? AND snmpIfIndex = ?";
    private boolean m_fromDb;
    private long m_nodeId;
    private int m_ifIndex;
    private InetAddress m_netmask;
    private String m_physAddr;
    private String m_ifDescription;
    private int m_ifType;
    private String m_ifName;
    private String m_ifAlias;
    private long m_ifSpeed;
    private int m_ifAdminStatus;
    private int m_ifOperStatus;
    private String m_collect;
    private int m_changed;
    private static final int CHANGED_NETMASK = 2;
    private static final int CHANGED_PHYSADDR = 4;
    private static final int CHANGED_DESCRIPTION = 8;
    private static final int CHANGED_IFTYPE = 16;
    private static final int CHANGED_IFNAME = 32;
    private static final int CHANGED_IFSPEED = 64;
    private static final int CHANGED_IFADMINSTATUS = 128;
    private static final int CHANGED_IFOPERSTATUS = 256;
    private static final int CHANGED_IFALIAS = 512;
    private static final int CHANGED_COLLECT = 1024;

    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO snmpInterface (nodeID,snmpIfIndex");
        StringBuffer values = new StringBuffer("?,?");
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",snmpIpAdEntNetMask");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",snmpPhysAddr");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",snmpIfDescr");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",snmpIfType");
        }
        if ((this.m_changed & 0x20) == 32) {
            values.append(",?");
            names.append(",snmpIfName");
        }
        if ((this.m_changed & 0x40) == 64) {
            values.append(",?");
            names.append(",snmpIfSpeed");
        }
        if ((this.m_changed & 0x80) == 128) {
            values.append(",?");
            names.append(",snmpIfAdminStatus");
        }
        if ((this.m_changed & 0x100) == 256) {
            values.append(",?");
            names.append(",snmpIfOperStatus");
        }
        if ((this.m_changed & 0x200) == 512) {
            values.append(",?");
            names.append(",snmpIfAlias");
        }
        if ((this.m_changed & 0x400) == 1024) {
            values.append(",?");
            names.append(",snmpCollect");
        }
        names.append(") VALUES (").append(values).append(')');
        log.debug("DbSnmpInterfaceEntry.insert: SQL insert statment = " + names.toString());
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            names = null;
            int ndx = 1;
            stmt.setLong(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_ifIndex);
            if ((this.m_changed & 2) == 2) {
                stmt.setString(ndx++, InetAddressUtils.str((InetAddress)this.m_netmask));
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, this.m_physAddr);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, this.m_ifDescription);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setInt(ndx++, this.m_ifType);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setString(ndx++, this.m_ifName);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setLong(ndx++, this.m_ifSpeed);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setInt(ndx++, this.m_ifAdminStatus);
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setInt(ndx++, this.m_ifOperStatus);
            }
            if ((this.m_changed & 0x200) == 512) {
                stmt.setString(ndx++, this.m_ifAlias);
            }
            if ((this.m_changed & 0x400) == 1024) {
                stmt.setString(ndx++, this.m_collect);
            }
            int rc = stmt.executeUpdate();
            log.debug("DbSnmpInterfaceEntry.insert: SQL update result = " + rc);
        }
        catch (SQLException e) {
            log.error(String.format("Insertion of snmpinterface entry failed: nodeid = %s, ifIndex = %s", this.m_nodeId, this.m_ifIndex));
            throw e;
        }
        catch (RuntimeException e) {
            log.error(String.format("Insertion of snmpinterface entry failed: nodeid = %s, ifIndex = %s", this.m_nodeId, this.m_ifIndex));
            throw e;
        }
        finally {
            d.cleanUp();
        }
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE snmpInterface SET ");
        int comma = 32;
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("snmpIpAdEntNetMask = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("snmpPhysAddr = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("snmpIfDescr = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("snmpIfType = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("snmpIfName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("snmpIfSpeed = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("snmpIfAdminStatus = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("snmpIfOperStatus = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x200) == 512) {
            sqlText.append((char)comma).append("snmpIfAlias = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x400) == 1024) {
            sqlText.append((char)comma).append("snmpCollect = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeID = ? AND snmpIfIndex = ? ");
        log.debug("DbSnmpInterfaceEntry.update: SQL update statment = " + sqlText.toString());
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            sqlText = null;
            int ndx = 1;
            if ((this.m_changed & 2) == 2) {
                if (this.m_netmask == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, InetAddressUtils.str((InetAddress)this.m_netmask));
                }
            }
            if ((this.m_changed & 4) == 4) {
                if (this.m_physAddr == null) {
                    stmt.setNull(ndx++, 1);
                } else {
                    stmt.setString(ndx++, this.m_physAddr);
                }
            }
            if ((this.m_changed & 8) == 8) {
                if (this.m_ifDescription == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_ifDescription);
                }
            }
            if ((this.m_changed & 0x10) == 16) {
                if (this.m_ifType == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_ifType);
                }
            }
            if ((this.m_changed & 0x20) == 32) {
                if (this.m_ifName == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_ifName);
                }
            }
            if ((this.m_changed & 0x40) == 64) {
                if (this.m_ifSpeed == -1L) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setLong(ndx++, this.m_ifSpeed);
                }
            }
            if ((this.m_changed & 0x80) == 128) {
                if (this.m_ifAdminStatus == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_ifAdminStatus);
                }
            }
            if ((this.m_changed & 0x100) == 256) {
                if (this.m_ifOperStatus == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_ifOperStatus);
                }
            }
            if ((this.m_changed & 0x200) == 512) {
                if (this.m_ifAlias == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_ifAlias);
                }
            }
            if ((this.m_changed & 0x400) == 1024) {
                if (this.m_collect == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_collect);
                }
            }
            stmt.setLong(ndx++, this.m_nodeId);
            if (this.m_ifIndex == -1) {
                stmt.setNull(ndx++, 4);
            } else {
                stmt.setInt(ndx++, this.m_ifIndex);
            }
            int rc = stmt.executeUpdate();
            log.debug("DbSnmpInterfaceEntry.update: update result = " + rc);
        }
        catch (SQLException e) {
            log.error(String.format("Update of snmpinterface entry failed: nodeid = %s, ifIndex = %s", this.m_nodeId, this.m_ifIndex));
            throw e;
        }
        catch (RuntimeException e) {
            log.error(String.format("Update of snmpinterface entry failed: nodeid = %s, ifIndex = %s", this.m_nodeId, this.m_ifIndex));
            throw e;
        }
        finally {
            d.cleanUp();
        }
        stmt.close();
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_REC);
            d.watch((Object)stmt);
            stmt.setLong(1, this.m_nodeId);
            stmt.setInt(2, this.m_ifIndex);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            if ((str = rset.getString(ndx++)) != null && !rset.wasNull()) {
                this.m_netmask = InetAddressUtils.addr((String)str);
            }
            this.m_physAddr = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_physAddr = null;
            }
            this.m_ifDescription = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifDescription = null;
            }
            this.m_ifType = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifIndex = -1;
            }
            this.m_ifName = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifName = null;
            }
            this.m_ifSpeed = rset.getLong(ndx++);
            if (rset.wasNull()) {
                this.m_ifSpeed = -1L;
            }
            this.m_ifAdminStatus = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifAdminStatus = -1;
            }
            this.m_ifOperStatus = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifOperStatus = -1;
            }
            this.m_ifAlias = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifAlias = null;
            }
            this.m_collect = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_collect = null;
            }
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
        return true;
    }

    private DbSnmpInterfaceEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    private DbSnmpInterfaceEntry(long nodeId, int ifIndex) {
        this(nodeId, ifIndex, true);
    }

    private DbSnmpInterfaceEntry(long nodeId, int ifIndex, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nodeId;
        this.m_ifIndex = ifIndex;
        this.m_netmask = null;
        this.m_physAddr = null;
        this.m_ifDescription = null;
        this.m_ifType = -1;
        this.m_ifName = null;
        this.m_ifSpeed = -1L;
        this.m_ifAdminStatus = -1;
        this.m_ifOperStatus = -1;
        this.m_ifAlias = null;
        this.m_collect = null;
        this.m_changed = 0;
    }

    long getNodeId() {
        return this.m_nodeId;
    }

    boolean hasIfIndex() {
        return this.m_ifIndex != -1;
    }

    int getIfIndex() {
        return this.m_ifIndex;
    }

    InetAddress getNetmask() {
        return this.m_netmask;
    }

    void setNetmask(InetAddress mask) {
        this.m_netmask = mask;
        this.m_changed |= 2;
    }

    boolean hasNetmaskChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateNetmask(InetAddress newNetmask) {
        if (newNetmask == null || newNetmask.equals(this.m_netmask)) {
            return false;
        }
        this.setNetmask(newNetmask);
        return true;
    }

    String getPhysicalAddress() {
        return this.m_physAddr;
    }

    void setPhysicalAddress(String addr) {
        this.m_physAddr = addr;
        this.m_changed |= 4;
    }

    boolean hasPhysicalAddressChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updatePhysicalAddress(String newPhysAddr) {
        if (newPhysAddr == null || newPhysAddr.equals(this.m_physAddr)) {
            return false;
        }
        this.setPhysicalAddress(newPhysAddr);
        return true;
    }

    String getDescription() {
        return this.m_ifDescription;
    }

    void setDescription(String descr) {
        this.m_ifDescription = descr;
        this.m_changed |= 8;
    }

    boolean hasDescriptionChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateDescription(String newIfDescription) {
        if (newIfDescription == null || newIfDescription.equals(this.m_ifDescription)) {
            return false;
        }
        this.setDescription(newIfDescription);
        return true;
    }

    String getName() {
        return this.m_ifName;
    }

    void setName(String name) {
        this.m_ifName = name;
        this.m_changed |= 0x20;
    }

    boolean hasNameChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateName(String newIfName) {
        if (newIfName == null || newIfName.equals(this.m_ifName)) {
            return false;
        }
        this.setName(newIfName);
        return true;
    }

    int getType() {
        return this.m_ifType;
    }

    void setType(int type) {
        this.m_ifType = type;
        this.m_changed |= 0x10;
    }

    boolean hasTypeChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateType(int newIfType) {
        if (newIfType == -1 || newIfType == this.m_ifType) {
            return false;
        }
        this.setType(newIfType);
        return true;
    }

    long getSpeed() {
        return this.m_ifSpeed;
    }

    void setSpeed(long speed) {
        this.m_ifSpeed = speed;
        this.m_changed |= 0x40;
    }

    boolean hasSpeedChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateSpeed(long newIfSpeed) {
        if (newIfSpeed == -1L || newIfSpeed == this.m_ifSpeed) {
            return false;
        }
        this.setSpeed(newIfSpeed);
        return true;
    }

    int getAdminStatus() {
        return this.m_ifAdminStatus;
    }

    void setAdminStatus(int status) {
        this.m_ifAdminStatus = status;
        this.m_changed |= 0x80;
    }

    boolean hasAdminStatusChanged() {
        return (this.m_changed & 0x80) == 128;
    }

    boolean updateAdminStatus(int newIfAdminStatus) {
        if (newIfAdminStatus == -1 || newIfAdminStatus == this.m_ifAdminStatus) {
            return false;
        }
        this.setAdminStatus(newIfAdminStatus);
        return true;
    }

    int getOperationalStatus() {
        return this.m_ifOperStatus;
    }

    void setOperationalStatus(int status) {
        this.m_ifOperStatus = status;
        this.m_changed |= 0x100;
    }

    boolean hasOperationalStatusChanged() {
        return (this.m_changed & 0x100) == 256;
    }

    boolean updateOperationalStatus(int newIfOperStatus) {
        if (newIfOperStatus == -1 || newIfOperStatus == this.m_ifOperStatus) {
            return false;
        }
        this.setOperationalStatus(newIfOperStatus);
        return true;
    }

    public String getAlias() {
        return this.m_ifAlias;
    }

    void setAlias(String alias) {
        this.m_ifAlias = alias;
        this.m_changed |= 0x200;
    }

    boolean hasAliasChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    boolean updateAlias(String newIfAlias) {
        if (newIfAlias == null || newIfAlias.equals(this.m_ifAlias)) {
            return false;
        }
        this.setAlias(newIfAlias);
        return true;
    }

    String getCollect() {
        return this.m_collect;
    }

    void setCollect(String collect) {
        this.m_collect = collect;
        this.m_changed |= 0x400;
    }

    boolean hasCollectChanged() {
        return (this.m_changed & 0x400) == 1024;
    }

    boolean updateCollect(String newCollect) {
        if (newCollect == null || newCollect.equals(this.m_collect)) {
            return false;
        }
        this.setCollect(newCollect);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn("Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    static DbSnmpInterfaceEntry create(int nid, int ifIndex) {
        return new DbSnmpInterfaceEntry(nid, ifIndex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbSnmpInterfaceEntry get(long nodeId, int ifIndex) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbSnmpInterfaceEntry dbSnmpInterfaceEntry = DbSnmpInterfaceEntry.get(db, nodeId, ifIndex);
            return dbSnmpInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbSnmpInterfaceEntry.class).warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    public static DbSnmpInterfaceEntry get(Connection db, long nodeId, int ifIndex) throws SQLException {
        DbSnmpInterfaceEntry entry = new DbSnmpInterfaceEntry(nodeId, ifIndex);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from database   = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier = ").append(this.m_nodeId).append(sep);
        buf.append("IP Netmask      = ").append(InetAddressUtils.str((InetAddress)this.m_netmask)).append(sep);
        buf.append("MAC             = ").append(this.m_physAddr).append(sep);
        buf.append("ifIndex         = ").append(this.m_ifIndex).append(sep);
        buf.append("ifDescr         = ").append(this.m_ifDescription).append(sep);
        buf.append("ifType          = ").append(this.m_ifType).append(sep);
        buf.append("ifName          = ").append(this.m_ifName).append(sep);
        buf.append("ifSpeed         = ").append(this.m_ifSpeed).append(sep);
        buf.append("ifAdminStatus   = ").append(this.m_ifAdminStatus).append(sep);
        buf.append("ifOperStatus    = ").append(this.m_ifOperStatus).append(sep);
        buf.append("ifAlias         = ").append(this.m_ifAlias).append(sep);
        buf.append("collect         = ").append(this.m_collect).append(sep);
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            Integer temp = new Integer(args[1]);
            DbSnmpInterfaceEntry entry = DbSnmpInterfaceEntry.get(Integer.parseInt(args[0]), temp);
            System.out.println(entry.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

