/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false, tempDbClass=MockDatabase.class)
@Transactional
public class SyslogdTest {
    String m_localhost = "127.0.0.1";
    private Syslogd m_syslogd;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/etc/syslogd-configuration.xml");
            SyslogdConfigFactory.setInstance((SyslogdConfig)new SyslogdConfigFactory(stream));
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        this.m_syslogd = new Syslogd();
        this.m_syslogd.init();
        boolean foundBeer = false;
        boolean foundMalt = false;
        Assert.assertEquals((long)10514L, (long)SyslogdConfigFactory.getInstance().getSyslogPort());
        for (UeiMatch match : SyslogdConfigFactory.getInstance().getUeiList().getUeiMatch()) {
            if (match.getProcessMatch() == null) continue;
            if (!foundBeer && "beerd".equals(match.getProcessMatch().getExpression())) {
                foundBeer = true;
                continue;
            }
            if (foundMalt || !"maltd".equals(match.getProcessMatch().getExpression())) continue;
            foundMalt = true;
        }
        Assert.assertTrue((boolean)foundBeer);
        Assert.assertTrue((boolean)foundMalt);
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNotGreaterOrEqual((Level)Level.FATAL);
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg) throws UnknownHostException, InterruptedException {
        this.startSyslogdGracefully();
        EventBuilder expectedEventBldr = new EventBuilder(expectedUEI, "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)expectedHost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage(expectedLogMsg);
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient sc = new SyslogClient(null, 10, 24);
        DatagramPacket pkt = sc.getPacket(7, testPDU);
        SyslogdConfig config = SyslogdConfigFactory.getInstance();
        Thread worker = new Thread((Runnable)new SyslogConnection(pkt, config.getForwardingRegexp(), config.getMatchingGroupHost(), config.getMatchingGroupMessage(), config.getUeiList(), config.getHideMessages(), config.getDiscardUei()), SyslogConnection.class.getSimpleName());
        worker.run();
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
        Event receivedEvent = ea.getAnticipatedEventsRecieved().get(0);
        Assert.assertEquals((String)"Log messages do not match", (Object)expectedLogMsg, (Object)receivedEvent.getLogmsg().getContent());
        return ea.getAnticipatedEventsRecieved();
    }

    private List<Event> doMessageTest(String testPDU, String expectedHost, String expectedUEI, String expectedLogMsg, Map<String, String> expectedParams) throws UnknownHostException, InterruptedException {
        List<Event> receivedEvents = this.doMessageTest(testPDU, expectedHost, expectedUEI, expectedLogMsg);
        HashMap<String, String> actualParms = new HashMap<String, String>();
        for (Parm actualParm : receivedEvents.get(0).getParmCollection()) {
            actualParms.put(actualParm.getParmName(), actualParm.getValue().getContent());
        }
        for (String expectedKey : expectedParams.keySet()) {
            String expectedValue = expectedParams.get(expectedKey);
            Assert.assertTrue((String)("Actual event does not have a parameter called " + expectedKey), (boolean)actualParms.containsKey(expectedKey));
            Assert.assertEquals((String)("Actual event has a parameter called " + expectedKey + " but its value does not match"), (Object)expectedValue, actualParms.get(expectedKey));
        }
        return receivedEvents;
    }

    @Test
    public void testMessaging() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 0, 24);
            s.syslog(3, "Hello.");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void testMyPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 24);
            s.syslog(7, "2007-01-01 host.domain.com A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void testRegexSeverityMatch() throws Exception {
        this.startSyslogdGracefully();
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 beer - Not just for dinner anymore";
        String testUEI = "uei.opennms.org/tests/syslogd/nonMessageMatch/severityOnly";
        String testMsg = "beer - Not just for dinner anymore";
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/nonMessageMatch/severityOnly", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("beer - Not just for dinner anymore");
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 24);
            s.syslog(2, "2007-01-01 127.0.0.1 beer - Not just for dinner anymore");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexFacilitySeverityProcessMatch() throws Exception {
        this.startSyslogdGracefully();
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 maltd: beer - Not just for lunch anymore";
        String testUEI = "uei.opennms.org/tests/syslogd/nonMessageMatch/facilitySeverityProcess";
        String testMsg = "beer - Not just for lunch anymore";
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/nonMessageMatch/facilitySeverityProcess", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("beer - Not just for lunch anymore");
        expectedEventBldr.addParam("process", "maltd");
        expectedEventBldr.addParam("service", "local1");
        expectedEventBldr.addParam("severity", "Warning");
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient("maltd", 10, 136);
            s.syslog(4, "2007-01-01 127.0.0.1 maltd: beer - Not just for lunch anymore");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexFacilitySeverityMatch() throws Exception {
        this.startSyslogdGracefully();
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 beer - Not just for lunch anymore";
        String testUEI = "uei.opennms.org/tests/syslogd/nonMessageMatch/facilitySeverity";
        String testMsg = "beer - Not just for lunch anymore";
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/nonMessageMatch/facilitySeverity", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("beer - Not just for lunch anymore");
        expectedEventBldr.addParam("service", "local1");
        expectedEventBldr.addParam("severity", "Warning");
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 136);
            s.syslog(4, "2007-01-01 127.0.0.1 beer - Not just for lunch anymore");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexFacilityMatch() throws Exception {
        this.startSyslogdGracefully();
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 beer - Not just for lunch anymore";
        String testUEI = "uei.opennms.org/tests/syslogd/nonMessageMatch/facilityOnly";
        String testMsg = "beer - Not just for lunch anymore";
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/nonMessageMatch/facilityOnly", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("beer - Not just for lunch anymore");
        expectedEventBldr.addParam("service", "local0");
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 128);
            s.syslog(7, "2007-01-01 127.0.0.1 beer - Not just for lunch anymore");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexProcessMatch() throws Exception {
        this.startSyslogdGracefully();
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 beerd: beer - Not just for breakfast anymore";
        String testUEI = "uei.opennms.org/tests/syslogd/nonMessageMatch/processOnly";
        String testMsg = "beer - Not just for breakfast anymore";
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/nonMessageMatch/processOnly", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("beer - Not just for breakfast anymore");
        expectedEventBldr.addParam("process", "beerd");
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient("beerd", 10, 24);
            s.syslog(7, "2007-01-01 127.0.0.1 beerd: beer - Not just for breakfast anymore");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testIPPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 24);
            s.syslog(7, "2007-01-01 127.0.0.1 A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void testResolvePatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 24);
            s.syslog(7, "2007-01-01 www.opennms.org A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void startSyslogdGracefully() {
        block2: {
            try {
                this.m_syslogd.start();
            }
            catch (UndeclaredThrowableException ute) {
                if (ute.getCause() instanceof BindException) break block2;
                throw ute;
            }
        }
    }

    @Test
    public void testSubstrUEIRewrite() throws Exception {
        this.doMessageTest("2007-01-01 localhost A CRISCO message", this.m_localhost, "uei.opennms.org/tests/syslogd/substrUeiRewriteTest", "A CRISCO message");
    }

    @Test
    public void testRegexUEIRewrite() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        this.doMessageTest("2007-01-01 localhost foo: 100 out of 666 tests failed for bar", this.m_localhost, "uei.opennms.org/tests/syslogd/regexUeiRewriteTest", "100 out of 666 tests failed for bar");
    }

    @Test
    public void testSubstrTESTTestThatRemovesATESTString() throws Exception {
        this.doMessageTest("2007-01-01 localhost A CRISCO message that is also a TESTHIDING message -- hide me!", this.m_localhost, "uei.opennms.org/tests/syslogd/substrUeiRewriteTest", "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
    }

    @Test
    public void testRegexTESTTestThatRemovesADoubleSecretString() throws Exception {
        this.doMessageTest("2007-01-01 localhost foo: 100 out of 666 tests failed for doubleSecret", this.m_localhost, "uei.opennms.org/tests/syslogd/regexUeiRewriteTest", "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
    }

    @Test
    public void testSubstrDiscard() throws Exception {
        this.startSyslogdGracefully();
        String testPDU = "2007-01-01 127.0.0.1 A JUNK message";
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 24);
        sc.syslog(7, "2007-01-01 127.0.0.1 A JUNK message");
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexDiscard() throws Exception {
        this.startSyslogdGracefully();
        String testPDU = "2007-01-01 127.0.0.1 A TrAsH message";
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        SyslogClient sc = null;
        sc = new SyslogClient(null, 10, 24);
        sc.syslog(7, "2007-01-01 127.0.0.1 A TrAsH message");
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testRegexUEIWithBothKindsOfParameterAssignments() throws Exception {
        String testPDU = "2007-01-01 127.0.0.1 coffee: Secretly replaced rangerrick's coffee with 42 wombats";
        String expectedUEI = "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/bothKinds";
        String expectedLogMsg = "Secretly replaced rangerrick's coffee with 42 wombats";
        String[] testGroups = new String[]{"rangerrick's", "42", "wombats"};
        HashMap<String, String> expectedParms = new HashMap<String, String>();
        expectedParms.put("group1", testGroups[0]);
        expectedParms.put("whoseBeverage", testGroups[0]);
        expectedParms.put("group2", testGroups[1]);
        expectedParms.put("count", testGroups[1]);
        expectedParms.put("group3", testGroups[2]);
        expectedParms.put("replacementItem", testGroups[2]);
        this.doMessageTest("2007-01-01 127.0.0.1 coffee: Secretly replaced rangerrick's coffee with 42 wombats", this.m_localhost, "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/bothKinds", "Secretly replaced rangerrick's coffee with 42 wombats", expectedParms);
    }

    @Test
    public void testRegexUEIWithOnlyUserSpecifiedParameterAssignments() throws InterruptedException {
        this.startSyslogdGracefully();
        String localhost = this.m_localhost;
        String testPDU = "2007-01-01 127.0.0.1 tea: Secretly replaced cmiskell's tea with 666 ferrets";
        String testUEI = "uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/userSpecifiedOnly";
        String testMsg = "Secretly replaced cmiskell's tea with 666 ferrets";
        String[] testGroups = new String[]{"cmiskell's", "666", "ferrets"};
        EventBuilder expectedEventBldr = new EventBuilder("uei.opennms.org/tests/syslogd/regexParameterAssignmentTest/userSpecifiedOnly", "syslogd");
        expectedEventBldr.setInterface(InetAddressUtils.addr((String)localhost));
        expectedEventBldr.setLogDest("logndisplay");
        expectedEventBldr.setLogMessage("Secretly replaced cmiskell's tea with 666 ferrets");
        expectedEventBldr.addParam("whoseBeverage", testGroups[0]);
        expectedEventBldr.addParam("count", testGroups[1]);
        expectedEventBldr.addParam("replacementItem", testGroups[2]);
        EventAnticipator ea = new EventAnticipator();
        this.m_eventIpcManager.addEventListener(ea);
        ea.anticipateEvent(expectedEventBldr.getEvent());
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 24);
            s.syslog(7, "2007-01-01 127.0.0.1 tea: Secretly replaced cmiskell's tea with 666 ferrets");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ea.verifyAnticipated(5000L, 0L, 0L, 0, 0);
    }
}

